/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAphorismTile;
import me.desht.pneumaticcraft.common.util.DramaSplash;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SharedConstants;
import org.apache.commons.lang3.ArrayUtils;

public class GuiAphorismTile
extends Screen {
    public final TileEntityAphorismTile tile;
    private String[] textLines;
    public int cursorY;
    public int cursorX;
    public int updateCounter;

    public GuiAphorismTile(TileEntityAphorismTile tile) {
        super(new ItemStack((IItemProvider)ModBlocks.APHORISM_TILE.get()).func_200301_q());
        this.tile = tile;
        this.textLines = tile.getTextLines();
        if (PNCConfig.Client.aphorismDrama && this.textLines.length == 1 && this.textLines[0].equals("")) {
            List<String> l = PneumaticCraftUtils.splitString(DramaSplash.getInstance().getSplash(), 20);
            tile.setTextLines(l.toArray(new String[0]));
        }
        NetworkHandler.sendToServer(new PacketAphorismTileUpdate(tile));
    }

    public static void openGui(TileEntityAphorismTile te) {
        if (te instanceof TileEntityAphorismTile) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiAphorismTile(te));
        }
    }

    public void tick() {
        ++this.updateCounter;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (ClientUtils.isKeyDown(290)) {
            GuiUtils.showPopupHelpScreen(this, this.font, PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"gui.aphorismTile.helpText", (Object[])new Object[0]), 40));
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean updateTE = false;
        switch (keyCode) {
            case 256: {
                NetworkHandler.sendToServer(new PacketAphorismTileUpdate(this.tile));
                break;
            }
            case 265: {
                --this.cursorY;
                if (this.cursorY >= 0) break;
                this.cursorY = this.textLines.length - 1;
                break;
            }
            case 264: 
            case 335: {
                ++this.cursorY;
                if (this.cursorY < this.textLines.length) break;
                this.cursorY = 0;
                break;
            }
            case 257: {
                ++this.cursorY;
                this.textLines = this.insertLine("", this.cursorY);
                updateTE = true;
                break;
            }
            case 259: {
                if (this.textLines[this.cursorY].length() > 0) {
                    this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.textLines[this.cursorY].length() - 1);
                    if (this.textLines[this.cursorY].endsWith("\u00a7")) {
                        this.textLines[this.cursorY] = this.textLines[this.cursorY].substring(0, this.textLines[this.cursorY].length() - 1);
                    }
                } else if (this.textLines.length > 1) {
                    this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)this.cursorY);
                    --this.cursorY;
                    if (this.cursorY < 0) {
                        this.cursorY = 0;
                    }
                }
                updateTE = true;
                break;
            }
            case 261: {
                if (Screen.hasShiftDown()) {
                    this.textLines = new String[1];
                    this.textLines[0] = "";
                    this.cursorY = 0;
                } else if (this.textLines.length > 1) {
                    this.textLines = (String[])ArrayUtils.remove((Object[])this.textLines, (int)this.cursorY);
                    if (this.cursorY > this.textLines.length - 1) {
                        this.cursorY = this.textLines.length - 1;
                    }
                }
                updateTE = true;
            }
        }
        if (updateTE) {
            this.tile.setTextLines(this.textLines);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char ch, int keyCode) {
        if (SharedConstants.func_71566_a((char)ch)) {
            if (Screen.hasAltDown()) {
                if (ch >= 'a' && ch <= 'f' || ch >= 'l' && ch <= 'o' || ch == 'r' || ch >= '0' && ch <= '9') {
                    this.textLines[this.cursorY] = this.textLines[this.cursorY] + "\u00a7" + ch;
                }
            } else {
                this.textLines[this.cursorY] = this.textLines[this.cursorY] + ch;
            }
            this.tile.setTextLines(this.textLines);
        }
        return super.charTyped(ch, keyCode);
    }

    public void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    public void onClose() {
        this.minecraft.field_195559_v.func_197967_a(false);
        super.onClose();
    }

    private String[] insertLine(String line, int pos) {
        String[] newLines = new String[this.textLines.length + 1];
        newLines[pos] = line;
        if (pos > 0) {
            System.arraycopy(this.textLines, 0, newLines, 0, pos);
        }
        if (pos < this.textLines.length) {
            System.arraycopy(this.textLines, pos, newLines, pos + 1, this.textLines.length - pos);
        }
        return newLines;
    }
}

