/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.registries.GeneratorsGases;
import mekanism.generators.common.slot.ReactorInventorySlot;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FusionReactor {
    private static final int MAX_INJECTION = 98;
    private static double burnTemperature = 1.0E8;
    private static double burnRatio = 1.0;
    private static double plasmaHeatCapacity = 100.0;
    public static double caseHeatCapacity = 1.0;
    public static double inverseInsulation = 100000.0;
    private static double thermocoupleEfficiency = 0.05;
    private static double steamTransferEfficiency = 0.2;
    private static double plasmaCaseConductivity = 0.2;
    private static double caseWaterConductivity = 0.3;
    private static double caseAirConductivity = 0.1;
    public TileEntityReactorController controller;
    private Set<TileEntityReactorBlock> reactorBlocks = new ObjectOpenHashSet();
    private Set<ITileHeatHandler> heatHandlers = new ObjectOpenHashSet();
    private double lastPlasmaTemperature = 300.0;
    private double lastCaseTemperature = 300.0;
    private int injectionRate = 0;
    private boolean burning = false;
    public boolean formed = false;

    public FusionReactor(TileEntityReactorController c) {
        this.controller = c;
    }

    public void addTemperatureFromEnergyInput(FloatingLong energyAdded) {
        if (this.isBurning()) {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(plasmaHeatCapacity).doubleValue());
        } else {
            this.setPlasmaTemp(this.getPlasmaTemp() + energyAdded.divide(plasmaHeatCapacity).multiply(10L).doubleValue());
        }
    }

    private boolean hasHohlraum() {
        IGasHandler gasHandlerItem;
        Optional capability;
        ItemStack hohlraum;
        if (this.controller != null && !this.controller.getReactorSlot().isEmpty() && (hohlraum = this.controller.getReactorSlot().getStack()).func_77973_b() instanceof ItemHohlraum && (capability = MekanismUtils.toOptional((LazyOptional)hohlraum.getCapability(Capabilities.GAS_HANDLER_CAPABILITY))).isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getGasTankCount() > 0) {
            return gasHandlerItem.getGasInTank(0).getAmount() == gasHandlerItem.getGasTankCapacity(0);
        }
        return false;
    }

    public void simulateServer() {
        if (this.getPlasmaTemp() >= burnTemperature) {
            if (!this.burning && this.hasHohlraum()) {
                this.vaporiseHohlraum();
            }
            if (this.burning) {
                this.injectFuel();
                long fuelBurned = this.burnFuel();
                if (fuelBurned == 0L) {
                    this.setBurning(false);
                }
            }
        } else {
            this.setBurning(false);
        }
        this.transferHeat();
        if (this.burning) {
            this.kill();
        }
        this.updateTemperatures();
    }

    public void updateTemperatures() {
        this.lastPlasmaTemperature = this.getPlasmaTemp();
        this.lastCaseTemperature = this.getHeatCapacitor().getTemperature();
    }

    private void vaporiseHohlraum() {
        IGasHandler gasHandlerItem;
        ReactorInventorySlot reactorSlot = this.controller.getReactorSlot();
        ItemStack hohlraum = reactorSlot.getStack();
        Optional capability = MekanismUtils.toOptional((LazyOptional)hohlraum.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
        if (capability.isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getGasTankCount() > 0) {
            this.getFuelTank().insert((ChemicalStack)gasHandlerItem.getGasInTank(0), Action.EXECUTE, AutomationType.INTERNAL);
            this.lastPlasmaTemperature = this.getPlasmaTemp();
            reactorSlot.setStack(ItemStack.field_190927_a);
            this.setBurning(true);
        }
    }

    private void injectFuel() {
        long amountNeeded = this.getFuelTank().getNeeded();
        long amountAvailable = 2L * Math.min(this.getDeuteriumTank().getStored(), this.getTritiumTank().getStored());
        long amountToInject = Math.min(amountNeeded, Math.min(amountAvailable, (long)this.injectionRate));
        amountToInject -= amountToInject % 2L;
        long injectingAmount = amountToInject / 2L;
        MekanismUtils.logMismatchedStackSize((long)this.getDeuteriumTank().shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        MekanismUtils.logMismatchedStackSize((long)this.getTritiumTank().shrinkStack(injectingAmount, Action.EXECUTE), (long)injectingAmount);
        this.getFuelTank().insert((ChemicalStack)GeneratorsGases.FUSION_FUEL.getGasStack(amountToInject), Action.EXECUTE, AutomationType.INTERNAL);
    }

    private long burnFuel() {
        long fuelBurned = (long)Math.min((double)this.getFuelTank().getStored(), Math.max(0.0, this.lastPlasmaTemperature - burnTemperature) * burnRatio);
        MekanismUtils.logMismatchedStackSize((long)this.getFuelTank().shrinkStack(fuelBurned, Action.EXECUTE), (long)fuelBurned);
        this.setPlasmaTemp(this.getPlasmaTemp() + ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).multiply(fuelBurned).divide(plasmaHeatCapacity).doubleValue());
        return fuelBurned;
    }

    private void transferHeat() {
        double plasmaCaseHeat = plasmaCaseConductivity * (this.lastPlasmaTemperature - this.lastCaseTemperature);
        this.setPlasmaTemp(this.getPlasmaTemp() - plasmaCaseHeat / plasmaHeatCapacity);
        this.getHeatCapacitor().handleHeat(plasmaCaseHeat);
        double caseWaterHeat = caseWaterConductivity * (this.lastCaseTemperature - 300.0);
        int waterToVaporize = (int)(steamTransferEfficiency * caseWaterHeat / HeatUtils.getVaporizationEnthalpy());
        waterToVaporize = Math.min(waterToVaporize, Math.min(this.getWaterTank().getFluidAmount(), MathUtils.clampToInt((long)this.getSteamTank().getNeeded())));
        if (waterToVaporize > 0) {
            MekanismUtils.logMismatchedStackSize((long)this.getWaterTank().shrinkStack(waterToVaporize, Action.EXECUTE), (long)waterToVaporize);
            this.getSteamTank().insert((ChemicalStack)MekanismGases.STEAM.getGasStack((long)waterToVaporize), Action.EXECUTE, AutomationType.INTERNAL);
        }
        caseWaterHeat = (double)waterToVaporize * HeatUtils.getVaporizationEnthalpy() / steamTransferEfficiency;
        this.getHeatCapacitor().handleHeat(-caseWaterHeat);
        for (ITileHeatHandler source : this.heatHandlers) {
            source.simulate();
        }
        double caseAirHeat = caseAirConductivity * (this.lastCaseTemperature - 300.0);
        this.getHeatCapacitor().handleHeat(-caseAirHeat);
        this.controller.energyContainer.insert(FloatingLong.create((double)(caseAirHeat * thermocoupleEfficiency)), Action.EXECUTE, AutomationType.INTERNAL);
    }

    public BasicHeatCapacitor getHeatCapacitor() {
        return this.controller.heatCapacitor;
    }

    public IExtendedFluidTank getWaterTank() {
        return this.controller.waterTank;
    }

    public IGasTank getSteamTank() {
        return this.controller.steamTank;
    }

    public IGasTank getDeuteriumTank() {
        return this.controller.deuteriumTank;
    }

    public IGasTank getTritiumTank() {
        return this.controller.tritiumTank;
    }

    public IGasTank getFuelTank() {
        return this.controller.fuelTank;
    }

    public double getLastPlasmaTemp() {
        return this.lastPlasmaTemperature;
    }

    public void setLastPlasmaTemp(double temp) {
        this.lastPlasmaTemperature = temp;
    }

    public double getPlasmaTemp() {
        return this.controller.plasmaTemperature;
    }

    public void setPlasmaTemp(double temp) {
        this.controller.plasmaTemperature = temp;
    }

    public double getLastCaseTemp() {
        return this.lastCaseTemperature;
    }

    public void setLastCaseTemp(double temp) {
        this.lastCaseTemperature = temp;
    }

    private void kill() {
        AxisAlignedBB death_zone = new AxisAlignedBB((double)(this.controller.func_174877_v().func_177958_n() - 1), (double)(this.controller.func_174877_v().func_177956_o() - 3), (double)(this.controller.func_174877_v().func_177952_p() - 1), (double)(this.controller.func_174877_v().func_177958_n() + 2), (double)this.controller.func_174877_v().func_177956_o(), (double)(this.controller.func_174877_v().func_177952_p() + 2));
        List entitiesToDie = this.controller.func_145831_w().func_217357_a(Entity.class, death_zone);
        for (Entity entity : entitiesToDie) {
            entity.func_70097_a(DamageSource.field_76376_m, 50000.0f);
        }
    }

    private void unformMultiblock(boolean keepBurning) {
        for (TileEntityReactorBlock block : this.reactorBlocks) {
            block.setReactor(null);
        }
        this.controller.setReactor(this);
        this.reactorBlocks.clear();
        this.formed = false;
        this.setBurning(this.burning && keepBurning);
    }

    public void formMultiblock(boolean keepBurning) {
        Coord4D controllerPosition = Coord4D.get((TileEntity)this.controller);
        Coord4D centreOfReactor = controllerPosition.offset(Direction.DOWN, 2);
        this.unformMultiblock(true);
        this.reactorBlocks.add(this.controller);
        if (!(this.createFrame(centreOfReactor) && this.addSides(centreOfReactor) && this.centerIsClear(centreOfReactor))) {
            this.unformMultiblock(keepBurning);
            if (!this.controller.isRemote() && !this.controller.func_145837_r()) {
                this.controller.setActive(false);
                this.controller.sendUpdatePacket();
            }
            return;
        }
        this.formed = true;
        if (!this.controller.isRemote()) {
            this.controller.setActive(true);
            this.controller.sendUpdatePacket();
        }
    }

    private boolean createFrame(Coord4D center) {
        int[][] positions = new int[][]{{2, 2, 0}, {2, 1, 1}, {2, 0, 2}, {2, -1, 1}, {2, -2, 0}, {2, -1, -1}, {2, 0, -2}, {2, 1, -1}, {1, 2, 1}, {1, 1, 2}, {1, -1, 2}, {1, -2, 1}, {1, -2, -1}, {1, -1, -2}, {1, 1, -2}, {1, 2, -1}, {0, 2, 2}, {0, -2, 2}, {0, -2, -2}, {0, 2, -2}, {-1, 2, 1}, {-1, 1, 2}, {-1, -1, 2}, {-1, -2, 1}, {-1, -2, -1}, {-1, -1, -2}, {-1, 1, -2}, {-1, 2, -1}, {-2, 2, 0}, {-2, 1, 1}, {-2, 0, 2}, {-2, -1, 1}, {-2, -2, 0}, {-2, -1, -1}, {-2, 0, -2}, {-2, 1, -1}};
        BlockPos centerPos = center.getPos();
        for (int[] coords : positions) {
            TileEntityReactorBlock tile = (TileEntityReactorBlock)MekanismUtils.getTileEntity(TileEntityReactorBlock.class, (IBlockReader)this.controller.func_145831_w(), (BlockPos)centerPos.func_177982_a(coords[0], coords[1], coords[2]));
            if (tile == null || !tile.isFrame()) {
                return false;
            }
            this.reactorBlocks.add(tile);
            tile.setReactor(this);
        }
        return true;
    }

    private boolean addSides(Coord4D center) {
        int[][] positions = new int[][]{{2, 0, 0}, {2, 1, 0}, {2, 0, 1}, {2, -1, 0}, {2, 0, -1}, {-2, 0, 0}, {-2, 1, 0}, {-2, 0, 1}, {-2, -1, 0}, {-2, 0, -1}, {0, 2, 0}, {1, 2, 0}, {0, 2, 1}, {-1, 2, 0}, {0, 2, -1}, {0, -2, 0}, {1, -2, 0}, {0, -2, 1}, {-1, -2, 0}, {0, -2, -1}, {0, 0, 2}, {1, 0, 2}, {0, 1, 2}, {-1, 0, 2}, {0, -1, 2}, {0, 0, -2}, {1, 0, -2}, {0, 1, -2}, {-1, 0, -2}, {0, -1, -2}};
        BlockPos centerPos = center.getPos();
        for (int[] coords : positions) {
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.controller.func_145831_w(), (BlockPos)centerPos.func_177982_a(coords[0], coords[1], coords[2]));
            if (CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.LASER_RECEPTOR_CAPABILITY, null).isPresent() && (coords[1] != 0 || coords[0] != 0 && coords[2] != 0)) {
                return false;
            }
            if (!(tile instanceof TileEntityReactorBlock)) {
                return false;
            }
            TileEntityReactorBlock tileReactor = (TileEntityReactorBlock)tile;
            this.reactorBlocks.add(tileReactor);
            tileReactor.setReactor(this);
            this.heatHandlers.add((ITileHeatHandler)tileReactor);
        }
        return true;
    }

    private boolean centerIsClear(Coord4D center) {
        BlockPos centerPos = center.getPos();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos transPos = centerPos.func_177982_a(x, y, z);
                    BlockState state = this.controller.func_145831_w().func_180495_p(transPos);
                    Block tile = state.func_177230_c();
                    if (tile.isAir(state, (IBlockReader)this.controller.func_145831_w(), transPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isFormed() {
        return this.formed;
    }

    public int getInjectionRate() {
        return this.injectionRate;
    }

    public void setInjectionRate(int rate) {
        this.injectionRate = rate;
        int capRate = Math.min(Math.max(1, rate), 98);
        capRate -= capRate % 2;
        this.controller.updateMaxCapacities(capRate);
        if (this.controller.func_145831_w() != null && !this.controller.isRemote()) {
            if (!this.controller.waterTank.isEmpty()) {
                this.controller.waterTank.setStackSize(Math.min(this.controller.waterTank.getFluidAmount(), this.controller.waterTank.getCapacity()), Action.EXECUTE);
            }
            if (!this.controller.steamTank.isEmpty()) {
                this.controller.steamTank.setStackSize(Math.min(this.controller.steamTank.getStored(), this.controller.steamTank.getCapacity()), Action.EXECUTE);
            }
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burn) {
        this.burning = burn;
    }

    public int getMinInjectionRate(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        double aMin = burnTemperature * burnRatio * plasmaCaseConductivity * (k + caseAirConductivity) / (((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue() * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) - plasmaCaseConductivity * (k + caseAirConductivity));
        return (int)(2.0 * Math.ceil(aMin / 2.0));
    }

    public double getMaxPlasmaTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return (double)this.injectionRate * ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue() / plasmaCaseConductivity * (plasmaCaseConductivity + k + caseAirConductivity) / (k + caseAirConductivity);
    }

    public double getMaxCasingTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        return ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).multiply((long)this.injectionRate).divide(k + caseAirConductivity).doubleValue();
    }

    public double getIgnitionTemperature(boolean active) {
        double k = active ? caseWaterConductivity : 0.0;
        double energyPerFusionFuel = ((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFusionFuel.get()).doubleValue();
        return burnTemperature * energyPerFusionFuel * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) / (energyPerFusionFuel * burnRatio * (plasmaCaseConductivity + k + caseAirConductivity) - plasmaCaseConductivity * (k + caseAirConductivity));
    }

    public FloatingLong getPassiveGeneration(boolean active, boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(active);
        return FloatingLong.create((double)(thermocoupleEfficiency * caseAirConductivity * temperature));
    }

    public long getSteamPerTick(boolean current) {
        double temperature = current ? this.getLastCaseTemp() : this.getMaxCasingTemperature(true);
        return MathUtils.clampToLong((double)(steamTransferEfficiency * caseWaterConductivity * temperature / HeatUtils.getVaporizationEnthalpy()));
    }

    public static double getInverseConductionCoefficient() {
        return 1.0 / caseAirConductivity;
    }
}

