/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FertilizerItem
extends Item {
    private final FertilizerType fertilizerType;

    public FertilizerItem(FertilizerType fertilizerType) {
        super(new Item.Properties().func_200916_a(FarmingForBlockheads.itemGroup));
        this.fertilizerType = fertilizerType;
    }

    public ActionResultType func_195939_a(ItemUseContext useContext) {
        PlayerEntity player = useContext.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = useContext.func_195991_k();
        BlockPos pos = useContext.func_195995_a();
        ItemStack heldItem = useContext.func_195996_i();
        if (this.tryApplyFertilizerAt(world, pos) || this.tryApplyFertilizerAt(world, pos.func_177977_b())) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(useContext);
    }

    private boolean tryApplyFertilizerAt(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        BlockState newState = this.fertilizerType.applyFertilizer(state);
        if (newState != state) {
            world.func_175656_a(pos, newState);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        TranslationTextComponent chatComponent = new TranslationTextComponent("tooltip.farmingforblockheads:fertilizer_" + this.fertilizerType.name().toLowerCase(Locale.ENGLISH), new Object[0]);
        chatComponent.func_150256_b().func_150238_a(this.fertilizerType.getFarmlandTrait().getTraitColor());
        tooltip.add((ITextComponent)chatComponent);
    }

    public static enum FertilizerType {
        HEALTHY,
        RICH,
        STABLE;


        public boolean canFertilize(BlockState state) {
            Block sourceBlock = state.func_177230_c();
            return sourceBlock == Blocks.field_150458_ak || sourceBlock instanceof FertilizedFarmlandBlock;
        }

        public BlockState applyFertilizer(BlockState state) {
            Block targetBlock;
            if (!this.canFertilize(state)) {
                return state;
            }
            int moisture = (Integer)state.func_177229_b((IProperty)BlockStateProperties.field_208133_ah);
            ArrayList<FertilizedFarmlandBlock.FarmlandTrait> traits = new ArrayList<FertilizedFarmlandBlock.FarmlandTrait>();
            traits.add(this.getFarmlandTrait());
            Block sourceBlock = state.func_177230_c();
            if (sourceBlock instanceof FertilizedFarmlandBlock) {
                traits.addAll(((FertilizedFarmlandBlock)sourceBlock).getTraits());
            }
            if ((targetBlock = FertilizerType.getBlockForTraits(traits)) == null) {
                return state;
            }
            BlockState newState = targetBlock.func_176223_P();
            return (BlockState)newState.func_206870_a((IProperty)FertilizedFarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(moisture));
        }

        private FertilizedFarmlandBlock.FarmlandTrait getFarmlandTrait() {
            switch (this) {
                case HEALTHY: {
                    return new FertilizedFarmlandBlock.FarmlandHealthyTrait();
                }
                case RICH: {
                    return new FertilizedFarmlandBlock.FarmlandRichTrait();
                }
                case STABLE: {
                    return new FertilizedFarmlandBlock.FarmlandStableTrait();
                }
            }
            return null;
        }

        @Nullable
        private static Block getBlockForTraits(List<FertilizedFarmlandBlock.FarmlandTrait> traits) {
            boolean hasStableTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandStableTrait);
            boolean hasHealthyTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandHealthyTrait);
            boolean hasRichTrait = traits.stream().anyMatch(it -> it instanceof FertilizedFarmlandBlock.FarmlandRichTrait);
            if (hasStableTrait && !hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandStable;
            }
            if (!hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRich;
            }
            if (!hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthy;
            }
            if (hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRichStable;
            }
            if (hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthyStable;
            }
            return null;
        }
    }
}

