/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.client.GuiEditShapes;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.groups.BlockBlacklist;
import oreexcavation.groups.ItemBlacklist;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.network.PacketExcavation;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.ToolEffectiveCheck;

public class EventHandler {
    public static MiningAgent captureAgent;
    public static boolean skipNext;
    public static boolean isExcavating;
    private static int cTick;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null) {
            return;
        }
        boolean shapeKey = ExcavationKeys.shapeKey.func_151468_f();
        boolean editKey = ExcavationKeys.shapeEdit.func_151468_f();
        if (editKey || shapeKey && (event.getModifiers() & 2) != 0) {
            mc.func_147108_a((Screen)new GuiEditShapes());
        } else if (shapeKey) {
            ShapeRegistry.INSTANCE.toggleShape();
            ExcavateShape shape = ShapeRegistry.INSTANCE.getActiveShape();
            if (shape == null) {
                mc.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Excavate Shape: NONE"), false);
            } else {
                mc.field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Excavate Shape: " + shape.getName()), false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || !event.getEntity().func_70089_S() || event.isCanceled()) {
            return;
        }
        if (captureAgent != null) {
            if (event.getEntity() instanceof ItemEntity) {
                ItemEntity eItem = (ItemEntity)event.getEntity();
                ItemStack stack = eItem.func_92059_d();
                captureAgent.addItemDrop(stack);
                event.setCanceled(true);
            } else if (event.getEntity() instanceof ExperienceOrbEntity) {
                ExperienceOrbEntity orb = (ExperienceOrbEntity)event.getEntity();
                captureAgent.addExperience(orb.func_70526_d());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        MiningAgent agent;
        if (event.getWorld().func_201672_e().field_72995_K || event.isCanceled()) {
            return;
        }
        if (captureAgent != null && !captureAgent.hasMinedPosition(event.getPos())) {
            return;
        }
        if (!(event.getPlayer() instanceof ServerPlayerEntity) || event.getPlayer() instanceof FakePlayer) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        if (player.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !ExcavationSettings.openHand) {
            return;
        }
        if (EventHandler.isToolBlacklisted(player.func_184586_b(Hand.MAIN_HAND))) {
            return;
        }
        if (EventHandler.isBlockBlacklisted(event.getState())) {
            return;
        }
        if (event.getState().func_177230_c().isAir(event.getState(), (IBlockReader)event.getWorld(), event.getPos())) {
            return;
        }
        BlockPos p = event.getPos();
        BlockState s = event.getState();
        if ((ExcavationSettings.ignoreTools || ToolEffectiveCheck.canHarvestBlock(event.getWorld().func_201672_e(), s, p, (PlayerEntity)player)) && (agent = MiningScheduler.INSTANCE.getActiveAgent(player.func_110124_au())) == null) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74772_a("pos", p.func_218275_a());
            tag.func_74768_a("stateId", Block.func_196246_j((BlockState)s));
            tag.func_74768_a("side", ExcavateShape.getFacing((PlayerEntity)player, s, p).func_176745_a());
            OreExcavation.instance.network.sendTo((Object)new PacketExcavation(tag), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (skipNext) {
            skipNext = false;
            return;
        }
        MiningScheduler.INSTANCE.tickAgents(ServerLifecycleHooks.getCurrentServer());
        captureAgent = null;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if ((cTick = (cTick + 1) % 10) != 0 || Minecraft.func_71410_x().field_71439_g == null || !isExcavating || !ExcavationSettings.mustHold) {
            return;
        }
        boolean canContinue = true;
        if (ExcavationSettings.mineMode < 0) {
            canContinue = false;
        } else if (ExcavationSettings.mineMode == 0) {
            if (!ExcavationKeys.excavateKey.func_151470_d()) {
                canContinue = false;
            }
        } else if (ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_225608_bj_()) {
            canContinue = false;
        }
        if (!canContinue) {
            isExcavating = false;
            CompoundNBT tags = new CompoundNBT();
            tags.func_74757_a("cancel", true);
            OreExcavation.instance.network.sendToServer((Object)new PacketExcavation(tags));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201672_e().field_72995_K || event.getWorld().func_201672_e().func_73046_m() == null || event.getWorld().func_201672_e().func_73046_m().func_71278_l()) {
            return;
        }
        MiningScheduler.INSTANCE.resetAll();
        captureAgent = null;
    }

    public static boolean isBlockBlacklisted(BlockState state) {
        if (state == null || state.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        return BlockBlacklist.INSTANCE.isBanned(state) != ExcavationSettings.invertBBlacklist;
    }

    public static boolean isToolBlacklisted(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return ItemBlacklist.INSTANCE.isBanned(stack) != ExcavationSettings.invertTBlacklist;
    }

    static {
        skipNext = false;
        isExcavating = false;
        cTick = 0;
    }
}

