/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory.container;

import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.util.helpers.InventoryHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ContainerCoFH
extends Container {
    protected boolean falseSlotSupport = true;
    protected boolean hasPlayerInventory;

    public ContainerCoFH(@Nullable ContainerType<?> type, int id, PlayerInventory inventory, PlayerEntity player) {
        super(type, id);
    }

    protected void bindPlayerInventory(PlayerInventory inventory) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, xOffset + i * 18, yOffset + 58));
        }
        this.hasPlayerInventory = true;
    }

    protected int getPlayerInventoryHorizontalOffset() {
        return 8;
    }

    protected abstract int getPlayerInventoryVerticalOffset();

    protected abstract int getSizeInventory();

    protected boolean supportsShiftClick(PlayerEntity player, int slotId) {
        return this.supportsShiftClick(slotId);
    }

    protected boolean supportsShiftClick(int slotId) {
        return true;
    }

    protected boolean performMerge(int slotId, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.field_75151_b.size();
        int invHotbar = invFull - 9;
        if (slotId < invBase) {
            return this.func_75135_a(stack, invBase, invFull, true);
        }
        boolean res = this.func_75135_a(stack, 0, invBase, false);
        if (!res && this.hasPlayerInventory) {
            if (slotId >= invHotbar) {
                return this.func_75135_a(stack, invBase, invHotbar, false);
            }
            return this.func_75135_a(stack, invHotbar, invFull, false);
        }
        return res;
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotId) {
        if (!this.supportsShiftClick(player, slotId)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (!this.performMerge(slotId, stackInSlot)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, stack);
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return stack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (this.falseSlotSupport) {
            Slot slot;
            Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
            if (slot instanceof SlotFalseCopy) {
                if (dragType == 2) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75215_d(player.field_71071_by.func_70445_o().func_190926_b() ? ItemStack.field_190927_a : player.field_71071_by.func_70445_o().func_77946_l());
                }
                return player.field_71071_by.func_70445_o();
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190896_a(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.func_75141_a(i, stacks.get(i));
        }
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return InventoryHelper.mergeItemStack(this.field_75151_b, stack, startIndex, endIndex, reverseDirection);
    }
}

