/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.preview;

import com.terraforged.core.settings.Settings;
import com.terraforged.mod.gui.OverlayScreen;
import com.terraforged.mod.gui.element.TerraButton;
import com.terraforged.mod.gui.page.BasePage;
import com.terraforged.mod.gui.page.Page;
import com.terraforged.mod.gui.preview.Preview;
import com.terraforged.mod.gui.preview.PreviewSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;

public class PreviewPage
extends BasePage {
    private final Preview preview;
    private final Settings settings;
    private final CompoundNBT previewerSettings = NBTHelper.serialize(new PreviewSettings());

    public PreviewPage(Settings settings, int seed) {
        this.preview = new Preview(seed);
        this.settings = settings;
    }

    public int getSeed() {
        return this.preview.getSeed();
    }

    public void apply(Consumer<Settings> consumer) {
        consumer.accept(this.settings);
        this.preview.update(this.settings, this.previewerSettings);
    }

    @Override
    public void close() {
        this.preview.close();
    }

    @Override
    public void save() {
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column right = this.getColumn(1);
        this.preview.x = 0;
        this.preview.y = 0;
        this.preview.setWidth(256);
        this.preview.setHeight(320);
        this.addElements(right.left, right.top, right, this.previewerSettings, right.scrollPane::addButton, this::update);
        right.scrollPane.addButton((Widget)new TerraButton("New Seed"){

            public void onPress() {
                PreviewPage.this.preview.regenerate();
                PreviewPage.this.update();
            }
        });
        right.scrollPane.addButton((Widget)this.preview);
        TerraButton spacer = PreviewPage.createSpacer();
        for (int i = 0; i < 7; ++i) {
            right.scrollPane.addButton((Widget)spacer);
        }
        this.update();
    }

    @Override
    protected void update() {
        this.preview.update(this.settings, this.previewerSettings);
    }

    private static TerraButton createSpacer() {
        return new TerraButton(""){

            public void render(int x, int y, float tick) {
            }
        };
    }
}

