/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.climate.Climate;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.mod.biome.modifier.AbstractMaxHeightModifier;
import com.terraforged.mod.material.MaterialHelper;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;

public class SandBiomeModifier
extends AbstractMaxHeightModifier {
    private final Set<Biome> biomes = ForgeRegistries.BIOMES.getValues().stream().filter(biome -> MaterialHelper.isSand(biome.func_203944_q().func_204108_a().func_177230_c())).collect(Collectors.toSet());

    public SandBiomeModifier(Seed seed, Climate climate, Levels levels) {
        super(seed, climate, 50, 2, levels.scale(8), levels.ground(5), levels.ground(25));
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public boolean test(Biome biome) {
        return biome.func_201856_r() == Biome.Category.DESERT || this.biomes.contains(biome);
    }

    @Override
    protected Biome getModifiedBiome(Biome in, Cell<Terrain> cell, int x, int z, float ox, float oz) {
        return Biomes.field_150589_Z;
    }
}

