/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.map.BiomeMapBuilder;
import com.terraforged.mod.biome.map.DefaultBiome;
import com.terraforged.mod.biome.provider.BiomeHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import me.dags.noise.util.NoiseUtil;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public abstract class AbstractBiomeMap
implements BiomeMap {
    private final Biome[][] beach;
    private final Biome[][] river;
    private final Biome[][] wetland;
    private final Biome[][] ocean;
    private final Biome[][] deepOcean;
    protected final DefaultBiome defaultLand = this::defaultBiome;
    protected final DefaultBiome defaultBeach = this::defaultBeach;
    protected final DefaultBiome defaultRiver = this::defaultRiver;
    protected final DefaultBiome defaultWetland = this::defaultWetland;
    protected final DefaultBiome defaultOcean = this::defaultOcean;
    protected final DefaultBiome defaultDeepOcean = this::defaultDeepOcean;

    protected AbstractBiomeMap(BiomeMapBuilder builder) {
        this.river = builder.rivers();
        this.beach = builder.beaches();
        this.ocean = builder.oceans();
        this.wetland = builder.wetlands();
        this.deepOcean = builder.deepOceans();
    }

    @Override
    public Biome getBeach(float temperature, float moisture, float shape) {
        return this.get(this.beach, this.getCategory(temperature), shape, temperature, this.defaultBeach);
    }

    @Override
    public Biome getRiver(float temperature, float moisture, float shape) {
        return this.get(this.river, this.getCategory(temperature), shape, temperature, this.defaultRiver);
    }

    @Override
    public Biome getWetland(float temperature, float moisture, float shape) {
        return this.get(this.wetland, this.getCategory(temperature), shape, temperature, this.defaultWetland);
    }

    @Override
    public Biome getOcean(float temperature, float moisture, float shape) {
        return this.get(this.ocean, this.getCategory(temperature), shape, temperature, this.defaultOcean);
    }

    @Override
    public Biome getDeepOcean(float temperature, float moisture, float shape) {
        return this.get(this.deepOcean, this.getCategory(temperature), shape, temperature, this.defaultDeepOcean);
    }

    @Override
    public Set<Biome> getOceanBiomes(Biome.TempCategory temp) {
        return Sets.newHashSet((Object[])this.ocean[temp.ordinal() - 1]);
    }

    @Override
    public Set<Biome> getDeepOceanBiomes(Biome.TempCategory temp) {
        return Sets.newHashSet((Object[])this.deepOcean[temp.ordinal() - 1]);
    }

    @Override
    public Set<Biome> getRivers(Biome.TempCategory temp) {
        return Sets.newHashSet((Object[])this.river[temp.ordinal() - 1]);
    }

    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("rivers", (JsonElement)this.collect(this.river));
        root.add("wetland", (JsonElement)this.collect(this.wetland));
        root.add("beaches", (JsonElement)this.collect(this.beach));
        root.add("oceans", (JsonElement)this.collect(this.ocean));
        root.add("deepOceans", (JsonElement)this.collect(this.deepOcean));
        return root;
    }

    private JsonObject collect(Biome[][] biomes) {
        JsonObject root = new JsonObject();
        for (Biome.TempCategory temp : Biome.TempCategory.values()) {
            if (temp == Biome.TempCategory.OCEAN) continue;
            JsonArray array = new JsonArray();
            Biome[] group = biomes[temp.ordinal() - 1];
            if (group != null) {
                HashSet set = new HashSet();
                Collections.addAll(set, group);
                set.stream().map(BiomeHelper::getId).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            }
            root.add(temp.name(), (JsonElement)array);
        }
        return root;
    }

    protected Biome.TempCategory getCategory(float value) {
        if ((double)value < 0.25) {
            return Biome.TempCategory.COLD;
        }
        if ((double)value > 0.75) {
            return Biome.TempCategory.WARM;
        }
        return Biome.TempCategory.MEDIUM;
    }

    protected Biome defaultBeach(float temperature) {
        if ((double)temperature < 0.25) {
            return Biomes.field_150577_O;
        }
        if ((double)temperature > 0.75) {
            return ModBiomes.WARM_BEACH;
        }
        return Biomes.field_76787_r;
    }

    protected Biome defaultRiver(float temperature) {
        if ((double)temperature < 0.15) {
            return Biomes.field_76777_m;
        }
        return Biomes.field_76781_i;
    }

    protected Biome defaultWetland(float temperature) {
        if ((double)temperature < 0.15) {
            return ModBiomes.TAIGA_SCRUB;
        }
        return ModBiomes.MARSHLAND;
    }

    protected Biome defaultOcean(float temperature) {
        if ((double)temperature < 0.3) {
            return Biomes.field_76776_l;
        }
        if ((double)temperature > 0.7) {
            return Biomes.field_203614_T;
        }
        return Biomes.field_76771_b;
    }

    protected Biome defaultDeepOcean(float temperature) {
        if ((double)temperature < 0.3) {
            return Biomes.field_203620_Z;
        }
        if ((double)temperature > 0.7) {
            return Biomes.field_203617_W;
        }
        return Biomes.field_150575_M;
    }

    protected Biome defaultBiome(float temperature) {
        if ((double)temperature < 0.3) {
            return ModBiomes.TAIGA_SCRUB;
        }
        if ((double)temperature > 0.7) {
            return ModBiomes.SAVANNA_SCRUB;
        }
        return Biomes.field_76772_c;
    }

    protected Biome get(Biome[][] group, Biome.TempCategory category, float shape, float temp, DefaultBiome def) {
        return this.get(group, category.ordinal() - 1, shape, temp, def);
    }

    protected Biome get(Biome[][] group, BiomeType type, float shape, float temp, DefaultBiome def) {
        return this.get(group, type.ordinal(), shape, temp, def);
    }

    protected Biome get(Biome[][] group, int ordinal, float shape, float temp, DefaultBiome def) {
        if (ordinal >= group.length) {
            return def.getDefaultBiome(temp);
        }
        Biome[] biomes = group[ordinal];
        if (biomes == null || biomes.length == 0) {
            return def.getDefaultBiome(temp);
        }
        int index = NoiseUtil.round((float)(biomes.length - 1) * shape);
        return biomes[index];
    }
}

