/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.decorator;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.biome.BiomeType;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import me.dags.noise.Module;
import me.dags.noise.Source;

public class DesertStacks
implements Decorator {
    private final float minY;
    private final float maxY;
    private final Levels levels;
    private final Module module;

    public DesertStacks(Seed seed, Levels levels) {
        Module mask = Source.perlin(seed.next(), 500, 1).clamp(0.7, 1.0).map(0.0, 1.0);
        Module shape = Source.perlin(seed.next(), 25, 1).clamp(0.6, 1.0).map(0.0, 1.0).mult(Source.perlin(seed.next(), 8, 1).alpha(0.1));
        Module top = Source.perlin(seed.next(), 4, 1).alpha(0.25);
        Module scale = Source.perlin(seed.next(), 400, 1).clamp(levels.scale(20), levels.scale(35));
        Module stack = (x, y) -> {
            float value = shape.getValue(x, y);
            if ((double)value > 0.3) {
                return top.getValue(x, y);
            }
            return value * 0.95f;
        };
        this.minY = levels.water(0);
        this.maxY = levels.water(50);
        this.levels = levels;
        this.module = stack.scale(scale).mult(mask);
    }

    @Override
    public boolean apply(Cell<Terrain> cell, float x, float y) {
        if (BiomeType.DESERT != cell.biomeType) {
            return false;
        }
        if (cell.value <= this.minY || cell.value > this.maxY) {
            return false;
        }
        float value = this.module.getValue(x, y);
        cell.value += (value *= cell.biomeEdge);
        return value > this.levels.unit;
    }
}

