/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.grid;

import com.terraforged.core.util.grid.FixedList;
import com.terraforged.core.util.grid.MappedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.dags.noise.util.NoiseUtil;

public class FixedGrid<T>
implements Iterable<MappedList<FixedList<T>>> {
    private final MappedList<MappedList<FixedList<T>>> grid;

    private FixedGrid(MappedList<MappedList<FixedList<T>>> grid) {
        this.grid = grid;
    }

    public int size() {
        return this.grid.size();
    }

    public FixedList<T> get(float x, float y) {
        return (FixedList)((MappedList)this.grid.get(y)).get(x);
    }

    public T get(float x, float y, float z) {
        MappedList row = (MappedList)this.grid.get(y);
        FixedList cell = (FixedList)row.get(x);
        return cell.get(z);
    }

    @Override
    public Iterator<MappedList<FixedList<T>>> iterator() {
        return this.grid.iterator();
    }

    public static <T> FixedGrid<T> create(List<List<List<T>>> grid, float minX, float minY, float rangeX, float rangeY) {
        ArrayList list = new ArrayList();
        for (List<List<T>> src : grid) {
            ArrayList<FixedList<T>> row = new ArrayList<FixedList<T>>(src.size());
            for (List<T> cell : src) {
                row.add(FixedList.of(cell));
            }
            list.add(MappedList.of(row, minX, rangeX));
        }
        return new FixedGrid<T>(MappedList.of(list, minY, rangeY));
    }

    public static <T> FixedGrid<T> generate(int size, List<T> values, Function<T, Float> xFunc, Function<T, Float> yFunc) {
        List<List> src = FixedGrid.createList(size, () -> FixedGrid.createList(size, ArrayList::new));
        List<List<List<T>>> dest = FixedGrid.createList(size, () -> FixedGrid.createList(size, ArrayList::new));
        float minX = 1.0f;
        float maxX = 0.0f;
        float minY = 1.0f;
        float maxY = 0.0f;
        for (T value : values) {
            float x = xFunc.apply(value).floatValue();
            float y = yFunc.apply(value).floatValue();
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        int maxIndex = size - 1;
        float rangeX = maxX - minX;
        float rangeY = maxY - minY;
        for (T value : values) {
            float colVal = (xFunc.apply(value).floatValue() - minX) / rangeX;
            float rowVal = (yFunc.apply(value).floatValue() - minY) / rangeY;
            int colIndex = NoiseUtil.round((float)maxIndex * colVal);
            int rowIndex = NoiseUtil.round((float)maxIndex * rowVal);
            List row = src.get(rowIndex);
            List group = (List)row.get(colIndex);
            group.add(value);
        }
        for (int y = 0; y < size; ++y) {
            List srcRow = src.get(y);
            List<List<T>> destRow = dest.get(y);
            for (int x = 0; x < size; ++x) {
                List srcGroup = (List)srcRow.get(x);
                List<T> destGroup = destRow.get(x);
                if (srcGroup.isEmpty()) {
                    float fx = minX + (float)x / (float)maxIndex * rangeX;
                    float fy = minY + (float)x / (float)maxIndex * rangeY;
                    FixedGrid.addClosest(values, destGroup, fx, fy, xFunc, yFunc);
                    continue;
                }
                destGroup.addAll(srcGroup);
            }
        }
        return FixedGrid.create(dest, minX, minY, rangeX, rangeY);
    }

    private static <T> void addClosest(List<T> source, List<T> dest, float fx, float fy, Function<T, Float> xFunc, Function<T, Float> yFunc) {
        float dist2 = Float.MAX_VALUE;
        HashMap distances = new HashMap();
        for (T t : source) {
            if (distances.containsKey(t)) continue;
            float dx = fx - xFunc.apply(t).floatValue();
            float dy = fy - yFunc.apply(t).floatValue();
            float d2 = dx * dx + dy * dy;
            distances.put(t, Float.valueOf(d2));
            if (!(d2 < dist2)) continue;
            dist2 = d2;
        }
        if (dist2 <= 0.0f) {
            dist2 = 1.0f;
        }
        ArrayList sorted = new ArrayList(distances.keySet());
        sorted.sort((o1, o2) -> Float.compare(distances.getOrDefault(o1, Float.valueOf(Float.MAX_VALUE)).floatValue(), distances.getOrDefault(o2, Float.valueOf(Float.MAX_VALUE)).floatValue()));
        for (Object t : sorted) {
            float d2 = ((Float)distances.get(t)).floatValue();
            if (!(d2 / dist2 < 1.025f)) continue;
            dest.add(t);
        }
    }

    private static <T> List<T> createList(int size, Supplier<T> supplier) {
        ArrayList<T> list = new ArrayList<T>();
        while (list.size() < size) {
            list.add(supplier.get());
        }
        return list;
    }
}

