/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.settings;

import com.terraforged.core.util.serialization.annotation.Comment;
import com.terraforged.core.util.serialization.annotation.Range;
import com.terraforged.core.util.serialization.annotation.Serializable;
import com.terraforged.core.world.terrain.TerrainPopulator;
import me.dags.noise.Module;

@Serializable
public class TerrainSettings {
    @Range(min=0.0f, max=1.0f)
    @Comment(value={"Globally controls the vertical scaling of terrain"})
    public float globalVerticalScale = 0.985f;
    @Range(min=0.0f, max=5.0f)
    @Comment(value={"Globally controls the horizontal scaling of terrain"})
    public float globalHorizontalScale = 1.0f;
    public Terrain steppe = new Terrain(5.0f, 1.0f, 1.0f);
    public Terrain plains = new Terrain(5.0f, 1.0f, 1.0f);
    public Terrain hills = new Terrain(2.0f, 1.0f, 1.0f);
    public Terrain dales = new Terrain(2.0f, 1.0f, 1.0f);
    public Terrain plateau = new Terrain(2.0f, 1.0f, 1.0f);
    public Terrain badlands = new Terrain(2.0f, 1.0f, 1.0f);
    public Terrain torridonian = new Terrain(0.5f, 1.0f, 1.0f);
    public Terrain mountains = new Terrain(0.5f, 1.0f, 1.0f);
    public Terrain volcano = new Terrain(1.0f, 1.0f, 1.0f);

    @Serializable
    public static class Terrain {
        @Range(min=0.0f, max=10.0f)
        @Comment(value={"Controls how common this terrain type is"})
        public float weight = 1.0f;
        @Range(min=0.0f, max=2.0f)
        @Comment(value={"Controls the base height of this terrain"})
        public float baseScale = 1.0f;
        @Range(min=0.0f, max=10.0f)
        @Comment(value={"Stretches or compresses the terrain vertically"})
        public float verticalScale = 1.0f;
        @Range(min=0.0f, max=10.0f)
        @Comment(value={"Stretches or compresses the terrain horizontally"})
        public float horizontalScale = 1.0f;

        public Terrain() {
        }

        public Terrain(float weight, float vertical, float horizontal) {
            this.weight = weight;
            this.verticalScale = vertical;
            this.horizontalScale = horizontal;
        }

        public Module apply(double bias, double scale, Module module) {
            double moduleBias = bias * (double)this.baseScale;
            double moduleScale = scale * (double)this.verticalScale;
            Module outputModule = module.scale(moduleScale).bias(moduleBias);
            return TerrainPopulator.clamp(outputModule);
        }
    }
}

