/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnegative;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.IngredientLookupState;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLogicStateListener;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;

public class RecipeGuiLogic
implements IRecipeGuiLogic {
    private final IRecipeManager recipeManager;
    private final RecipeTransferManager recipeTransferManager;
    private final IRecipeLogicStateListener stateListener;
    private final IngredientManager ingredientManager;
    private boolean initialState = true;
    private IngredientLookupState state;
    private final Stack<IngredientLookupState> history = new Stack();
    private List<Object> recipes = Collections.emptyList();

    public RecipeGuiLogic(IRecipeManager recipeManager, RecipeTransferManager recipeTransferManager, IRecipeLogicStateListener stateListener, IngredientManager ingredientManager) {
        this.recipeManager = recipeManager;
        this.recipeTransferManager = recipeTransferManager;
        this.stateListener = stateListener;
        this.ingredientManager = ingredientManager;
        List<IRecipeCategory> recipeCategories = recipeManager.getRecipeCategories();
        this.state = new IngredientLookupState(null, recipeCategories, 0, 0);
    }

    @Override
    public <V> boolean setFocus(Focus<V> focus) {
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(focus.getValue());
        IFocus<?> translatedFocus = ingredientHelper.translateFocus(focus, Focus::new);
        Focus<?> checkedTranslatedFocus = Focus.check(translatedFocus);
        List<IRecipeCategory> recipeCategories = this.recipeManager.getRecipeCategories(translatedFocus);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (!this.initialState) {
            this.history.push(this.state);
        }
        int recipeCategoryIndex = this.getRecipeCategoryIndexToShowFirst(recipeCategories);
        IngredientLookupState state = new IngredientLookupState(checkedTranslatedFocus, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Nonnegative
    private int getRecipeCategoryIndexToShowFirst(List<IRecipeCategory> recipeCategories) {
        Container openContainer;
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player != null && (openContainer = player.field_71070_bA) != null) {
            for (int i = 0; i < recipeCategories.size(); ++i) {
                IRecipeCategory recipeCategory = recipeCategories.get(i);
                IRecipeTransferHandler recipeTransferHandler = this.recipeTransferManager.getRecipeTransferHandler(openContainer, recipeCategory);
                if (recipeTransferHandler == null) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public boolean back() {
        if (this.history.empty()) {
            return false;
        }
        IngredientLookupState state = this.history.pop();
        this.setState(state);
        return true;
    }

    @Override
    public void clearHistory() {
        while (!this.history.empty()) {
            this.history.pop();
        }
    }

    private void setState(IngredientLookupState state) {
        this.state = state;
        this.initialState = false;
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public boolean setCategoryFocus() {
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        if (!this.initialState) {
            this.history.push(this.state);
        }
        List<IRecipeCategory> recipeCategories = this.recipeManager.getRecipeCategories();
        int recipeCategoryIndex = recipeCategories.indexOf(recipeCategory);
        IngredientLookupState state = new IngredientLookupState(null, recipeCategories, recipeCategoryIndex, 0);
        this.setState(state);
        return true;
    }

    @Override
    public boolean setCategoryFocus(List<ResourceLocation> recipeCategoryUids) {
        List<IRecipeCategory> recipeCategories = this.recipeManager.getRecipeCategories(recipeCategoryUids);
        if (recipeCategories.isEmpty()) {
            return false;
        }
        if (!this.initialState) {
            this.history.push(this.state);
        }
        IngredientLookupState state = new IngredientLookupState(null, recipeCategories, 0, 0);
        this.setState(state);
        return true;
    }

    @Override
    public List<Object> getRecipeCatalysts() {
        IRecipeCategory category = this.getSelectedRecipeCategory();
        return this.getRecipeCatalysts(category);
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory recipeCategory) {
        return this.recipeManager.getRecipeCatalysts(recipeCategory);
    }

    @Override
    public void setRecipesPerPage(int recipesPerPage) {
        if (this.state.getRecipesPerPage() != recipesPerPage) {
            this.state.setRecipesPerPage(recipesPerPage);
            this.updateRecipes();
        }
    }

    private void updateRecipes() {
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        Focus<?> focus = this.state.getFocus();
        this.recipes = focus != null ? this.recipeManager.getRecipes(recipeCategory, focus) : this.recipeManager.getRecipes(recipeCategory);
    }

    @Override
    public IRecipeCategory getSelectedRecipeCategory() {
        return (IRecipeCategory)this.state.getRecipeCategories().get(this.state.getRecipeCategoryIndex());
    }

    @Override
    public ImmutableList<IRecipeCategory> getRecipeCategories() {
        return this.state.getRecipeCategories();
    }

    @Override
    public List<RecipeLayout> getRecipeLayouts(int posX, int posY, int spacingY) {
        int firstRecipeIndex;
        ArrayList<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
        IRecipeCategory recipeCategory = this.getSelectedRecipeCategory();
        int recipeWidgetIndex = 0;
        int recipePosY = posY;
        for (int recipeIndex = firstRecipeIndex = this.state.getRecipeIndex() - this.state.getRecipeIndex() % this.state.getRecipesPerPage(); recipeIndex < this.recipes.size() && recipeLayouts.size() < this.state.getRecipesPerPage(); ++recipeIndex) {
            RecipeLayout recipeLayout;
            Object recipe = this.recipes.get(recipeIndex);
            if ((recipeLayout = RecipeLayout.create(recipeWidgetIndex++, recipeCategory, recipe, this.state.getFocus(), posX, recipePosY)) == null) {
                this.recipes.remove(recipeIndex);
                this.recipeManager.hideRecipe(recipe, recipeCategory.getUid());
                --recipeIndex;
                continue;
            }
            recipeLayouts.add(recipeLayout);
            recipePosY += spacingY;
        }
        return recipeLayouts;
    }

    @Override
    public void nextRecipeCategory() {
        int recipesTypesCount = this.state.getRecipeCategories().size();
        this.state.setRecipeCategoryIndex((this.state.getRecipeCategoryIndex() + 1) % recipesTypesCount);
        this.state.setRecipeIndex(0);
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public void setRecipeCategory(IRecipeCategory category) {
        int index = this.state.getRecipeCategories().indexOf((Object)category);
        if (index < 0) {
            return;
        }
        this.state.setRecipeCategoryIndex(index);
        this.state.setRecipeIndex(0);
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public boolean hasMultiplePages() {
        return this.recipes.size() > this.state.getRecipesPerPage();
    }

    @Override
    public void previousRecipeCategory() {
        int recipesTypesCount = this.state.getRecipeCategories().size();
        this.state.setRecipeCategoryIndex((recipesTypesCount + this.state.getRecipeCategoryIndex() - 1) % recipesTypesCount);
        this.state.setRecipeIndex(0);
        this.updateRecipes();
        this.stateListener.onStateChange();
    }

    @Override
    public void nextPage() {
        this.state.setRecipeIndex(this.state.getRecipeIndex() + this.state.getRecipesPerPage());
        if (this.state.getRecipeIndex() >= this.recipes.size()) {
            this.state.setRecipeIndex(0);
        }
        this.stateListener.onStateChange();
    }

    @Override
    public void previousPage() {
        this.state.setRecipeIndex(this.state.getRecipeIndex() - this.state.getRecipesPerPage());
        if (this.state.getRecipeIndex() < 0) {
            int pageCount = this.pageCount(this.state.getRecipesPerPage());
            this.state.setRecipeIndex((pageCount - 1) * this.state.getRecipesPerPage());
        }
        this.stateListener.onStateChange();
    }

    private int pageCount(int recipesPerPage) {
        if (this.recipes.size() <= 1) {
            return 1;
        }
        return MathUtil.divideCeil(this.recipes.size(), recipesPerPage);
    }

    @Override
    public String getPageString() {
        int pageIndex = MathUtil.divideCeil(this.state.getRecipeIndex() + 1, this.state.getRecipesPerPage());
        return pageIndex + "/" + this.pageCount(this.state.getRecipesPerPage());
    }

    @Override
    public boolean hasMultipleCategories() {
        return this.state.getRecipeCategories().size() > 1;
    }

    @Override
    public boolean hasAllCategories() {
        return this.state.getRecipeCategories().size() == this.recipeManager.getRecipeCategories().size();
    }
}

