/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementContainer;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.BaseContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;

public abstract class BaseListContainerElement
extends BaseContainerElement {
    protected List<IElement> elements = Lists.newArrayList();

    public BaseListContainerElement(String id) {
        super(id);
    }

    @Override
    @NotNull
    protected List<IElement> getElementList() {
        return this.elements;
    }

    public final void addElement(IElement element) {
        if (element != null) {
            this.elements.add(element);
            if (element instanceof IElementContainer) {
                ((IElementContainer)((Object)element)).initContainer();
            }
            element.setOwner(this);
        }
    }

    @Override
    public void load(CompoundNBT nbt) {
        CompoundNBT ct = nbt.func_74775_l(this.getID());
        for (IElement ele : this.elements) {
            ele.load(ct);
        }
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        CompoundNBT ct = nbt.func_74775_l(this.getID());
        for (IElement ele : this.elements) {
            ele.save(ct);
        }
        return nbt;
    }

    @Override
    public void update() {
        GuiUtils.updateAll(this.elements);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawBackground(this.elements, mouseX, mouseY, partialTicks, this);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.drawForeground(this.elements, mouseX, mouseY, this);
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        GuiUtils.drawTooltips(this.elements, mouseX, mouseY, this);
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseClickedCheckAll(this.elements, mouseX, mouseY, mouseButton, this);
        return false;
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        GuiUtils.mouseReleasedCheckAll(this.elements, mouseX, mouseY, mouseButton, this);
        return false;
    }

    @Override
    public boolean emouseDragged(double mouseXStart, double mouseYStart, int mouseButton, double mouseXEnd, double mouseYEnd) {
        GuiUtils.mouseDraggedCheckAll(this.elements, mouseXStart, mouseYStart, mouseButton, mouseXEnd, mouseYEnd, this);
        return false;
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        GuiUtils.mouseScrolledCheckAll(this.elements, mouseX, mouseY, scrolled, this);
        return false;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        GuiUtils.keyPressedCheckAll(this.elements, key, scanCode, modifiers, this);
        return false;
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        GuiUtils.keyReleasedCheckAll(this.elements, key, scanCode, modifiers, this);
        return false;
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        GuiUtils.charTypedCheckAll(this.elements, ch, modifiers, this);
        return false;
    }
}

