/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api;

import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.registry.IAugmentRegistry;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalagriculture.api.registry.IMobSoulTypeRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;

public class MysticalAgricultureAPI {
    public static final String MOD_ID = "mysticalagriculture";
    public static final Set<CropType> CROP_TYPES = new HashSet<CropType>();
    public static final Set<CropTier> CROP_TIERS = new HashSet<CropTier>();
    private static ICropRegistry cropRegistry;
    private static IAugmentRegistry augmentRegistry;
    private static IMobSoulTypeRegistry soulTypeRegistry;

    public static CropType getCropTypeByName(String name) {
        return CROP_TYPES.stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
    }

    public static CropTier getCropTierById(ResourceLocation id) {
        return CROP_TIERS.stream().filter(c -> c.getId().equals((Object)id)).findFirst().orElse(null);
    }

    public static ICropRegistry getCropRegistry() {
        return cropRegistry;
    }

    public static void setCropRegistry(ICropRegistry registry) {
        if (cropRegistry == null && MysticalAgricultureAPI.isMysticalAgriculture()) {
            cropRegistry = registry;
        }
    }

    public static IAugmentRegistry getAugmentRegistry() {
        return augmentRegistry;
    }

    public static void setAugmentRegistry(IAugmentRegistry registry) {
        if (augmentRegistry == null && MysticalAgricultureAPI.isMysticalAgriculture()) {
            augmentRegistry = registry;
        }
    }

    public static IMobSoulTypeRegistry getMobSoulTypeRegistry() {
        return soulTypeRegistry;
    }

    public static void setMobSoulTypeRegistry(IMobSoulTypeRegistry registry) {
        if (soulTypeRegistry == null && MysticalAgricultureAPI.isMysticalAgriculture()) {
            soulTypeRegistry = registry;
        }
    }

    private static boolean isMysticalAgriculture() {
        return ModLoadingContext.get().getActiveContainer().getModId().equals(MOD_ID);
    }
}

