/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.generator.IRecipeBuilder;

@Deprecated
public final class RecipeGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Class<?>, Function<Object, JsonObject>> COMPONENT_SERIALIZERS = new HashMap();

    private RecipeGenerator() {
        throw new IllegalAccessError("Utility class");
    }

    public static void create(ResourceLocation name, IRecipeBuilder builder) {
        RecipeGenerator.writeFile(name, builder.build());
    }

    private static void writeFile(ResourceLocation name, JsonObject json) {
        String fileName = name.func_110623_a();
        String dirPath = "output/data/" + name.func_110624_b() + "/recipes";
        File output = new File(dirPath, fileName + ".json");
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            SilentLib.LOGGER.error("Could not create directory: {}", (Object)output.getParent());
            return;
        }
        try (FileWriter writer = new FileWriter(output);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
            SilentLib.LOGGER.info("Wrote recipe file {}", (Object)output.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compress4(ResourceLocation name, IItemProvider big, IItemProvider small) {
        RecipeGenerator.compress4(name, "", big, small);
    }

    public static void compress4(ResourceLocation name, ResourceLocation group, IItemProvider big, IItemProvider small) {
        RecipeGenerator.compress4(name, group.toString(), big, small);
    }

    public static void compress4(ResourceLocation name, String group, IItemProvider big, IItemProvider small) {
        RecipeGenerator.create(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "_compress"), ShapedBuilder.create(big).group(!group.isEmpty() ? group + "_compress" : "").layout("##", "##").key('#', small));
        RecipeGenerator.create(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "_uncompress"), ShapedBuilder.create(new ItemStack(small, 4)).group(!group.isEmpty() ? group + "_uncompress" : "").layout("#").key('#', big));
    }

    public static void compress9(ResourceLocation name, IItemProvider big, IItemProvider small) {
        RecipeGenerator.compress9(name, "", big, small);
    }

    public static void compress9(ResourceLocation name, ResourceLocation group, IItemProvider big, IItemProvider small) {
        RecipeGenerator.compress9(name, group.toString(), big, small);
    }

    public static void compress9(ResourceLocation name, String group, IItemProvider big, IItemProvider small) {
        RecipeGenerator.create(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "_compress"), ShapedBuilder.create(big).group(!group.isEmpty() ? group + "_compress" : "").layout("###", "###", "###").key('#', small));
        RecipeGenerator.create(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "_uncompress"), ShapedBuilder.create(new ItemStack(small, 9)).group(!group.isEmpty() ? group + "_uncompress" : "").layout("#").key('#', big));
    }

    public static JsonObject serialize(Object obj) {
        Function<Object, JsonObject> function = null;
        for (Class<?> clazz : COMPONENT_SERIALIZERS.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            function = COMPONENT_SERIALIZERS.get(clazz);
            break;
        }
        if (function == null) {
            throw new IllegalArgumentException("Don't know how to serialize object of type " + obj.getClass());
        }
        return (JsonObject)function.apply(obj);
    }

    public static JsonObject serializeItemStack(Object o) {
        ItemStack stack = (ItemStack)o;
        JsonObject json = new JsonObject();
        json.addProperty("item", Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString());
        if (stack.func_190916_E() > 1) {
            json.addProperty("count", (Number)stack.func_190916_E());
        }
        if (stack.func_77942_o()) {
            SilentLib.LOGGER.warn("Recipe component contains NBT and cannot be serialized properly: {}", o);
        }
        return json;
    }

    public static JsonObject serializeTag(Object o) {
        String tag = o.toString();
        JsonObject json = new JsonObject();
        json.addProperty("tag", tag);
        return json;
    }

    static {
        COMPONENT_SERIALIZERS.put(ItemStack.class, RecipeGenerator::serializeItemStack);
        COMPONENT_SERIALIZERS.put(IItemProvider.class, o -> RecipeGenerator.serialize(new ItemStack((IItemProvider)o)));
        COMPONENT_SERIALIZERS.put(String.class, RecipeGenerator::serializeTag);
        COMPONENT_SERIALIZERS.put(ResourceLocation.class, o -> RecipeGenerator.serializeTag(o.toString()));
        COMPONENT_SERIALIZERS.put(Tag.class, o -> RecipeGenerator.serializeTag(((Tag)o).func_199886_b()));
    }

    public static final class SmeltingBuilder
    implements IRecipeBuilder {
        private final ItemStack result;
        private String group = "";
        private Object ingredient;
        private float experience = 0.0f;
        private int cookingTime = 200;

        public static SmeltingBuilder create(ItemStack result) {
            return new SmeltingBuilder(result);
        }

        public static SmeltingBuilder create(IItemProvider result) {
            return new SmeltingBuilder(new ItemStack(result));
        }

        public static SmeltingBuilder create(IItemProvider result, int count) {
            return new SmeltingBuilder(new ItemStack(result, count));
        }

        private SmeltingBuilder(ItemStack result) {
            this.result = result;
        }

        public SmeltingBuilder group(ResourceLocation group) {
            return this.group(group.toString());
        }

        public SmeltingBuilder group(String group) {
            this.group = group;
            return this;
        }

        public SmeltingBuilder ingredient(Object ingredient) {
            this.ingredient = ingredient;
            return this;
        }

        public SmeltingBuilder experience(float experience) {
            this.experience = experience;
            return this;
        }

        public SmeltingBuilder cookingTime(int cookingTime) {
            this.cookingTime = cookingTime;
            return this;
        }

        @Override
        public JsonObject build() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "smelting");
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonObject ingredientObj = RecipeGenerator.serialize(this.ingredient);
            json.add("ingredient", (JsonElement)ingredientObj);
            ResourceLocation resultName = Objects.requireNonNull(this.result.func_77973_b().getRegistryName());
            json.addProperty("result", resultName.toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
            return json;
        }
    }

    public static final class ShapelessBuilder
    implements IRecipeBuilder {
        private final ItemStack result;
        private String group = "";
        private final Collection<Object> ingredients = new ArrayList<Object>();

        public static ShapelessBuilder create(ItemStack result) {
            return new ShapelessBuilder(result);
        }

        public static ShapelessBuilder create(IItemProvider result) {
            return new ShapelessBuilder(new ItemStack(result));
        }

        public static ShapelessBuilder create(IItemProvider result, int count) {
            return new ShapelessBuilder(new ItemStack(result, count));
        }

        private ShapelessBuilder(ItemStack result) {
            this.result = result;
        }

        public ShapelessBuilder group(ResourceLocation group) {
            return this.group(group.toString());
        }

        public ShapelessBuilder group(String group) {
            this.group = group;
            return this;
        }

        public ShapelessBuilder ingredient(Object ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public ShapelessBuilder ingredient(Object ingredient, int count) {
            for (int i = 0; i < count; ++i) {
                this.ingredients.add(ingredient);
            }
            return this;
        }

        @Override
        public JsonObject build() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "crafting_shapeless");
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray ingredientsObj = new JsonArray();
            this.ingredients.forEach(o -> ingredientsObj.add((JsonElement)RecipeGenerator.serialize(o)));
            json.add("ingredients", (JsonElement)ingredientsObj);
            JsonObject resultObj = RecipeGenerator.serialize(this.result);
            json.add("result", (JsonElement)resultObj);
            return json;
        }
    }

    public static final class ShapedBuilder
    implements IRecipeBuilder {
        private final ItemStack result;
        private String group = "";
        private final Collection<String> layout = new ArrayList<String>();
        private final Map<String, Object> ingredients = new HashMap<String, Object>();

        public static ShapedBuilder create(ItemStack result) {
            return new ShapedBuilder(result);
        }

        public static ShapedBuilder create(IItemProvider result) {
            return new ShapedBuilder(new ItemStack(result));
        }

        public static ShapedBuilder create(IItemProvider result, int count) {
            return new ShapedBuilder(new ItemStack(result, count));
        }

        private ShapedBuilder(ItemStack result) {
            this.result = result;
        }

        public ShapedBuilder group(ResourceLocation group) {
            return this.group(group.toString());
        }

        public ShapedBuilder group(String group) {
            this.group = group;
            return this;
        }

        public ShapedBuilder layout(String line1) {
            this.checkLayoutEmpty();
            this.layout.add(line1);
            return this;
        }

        public ShapedBuilder layout(String line1, String line2) {
            this.checkLayoutEmpty();
            this.layout.add(line1);
            this.layout.add(line2);
            return this;
        }

        public ShapedBuilder layout(String line1, String line2, String line3) {
            this.checkLayoutEmpty();
            this.layout.add(line1);
            this.layout.add(line2);
            this.layout.add(line3);
            return this;
        }

        private void checkLayoutEmpty() {
            if (!this.layout.isEmpty()) {
                throw new IllegalStateException("layout called more than once");
            }
        }

        public ShapedBuilder key(char key, Object obj) {
            String strKey = String.valueOf(key);
            if (this.ingredients.containsKey(strKey)) {
                throw new IllegalStateException("key already contains '" + key + "'");
            }
            this.ingredients.put(strKey, obj);
            return this;
        }

        @Override
        public JsonObject build() {
            JsonObject json = new JsonObject();
            json.addProperty("type", "crafting_shaped");
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray pattern = new JsonArray();
            this.layout.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            json.add("pattern", (JsonElement)pattern);
            JsonObject key = new JsonObject();
            this.ingredients.forEach((s, o) -> key.add(s, (JsonElement)RecipeGenerator.serialize(o)));
            json.add("key", (JsonElement)key);
            JsonObject resultObj = RecipeGenerator.serialize(this.result);
            json.add("result", (JsonElement)resultObj);
            return json;
        }
    }
}

