/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.powah.block.ITiles;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.recipe.Recipes;

public class EnergizingOrbTile
extends TileBase.Tickable<IVariant.Single, EnergizingOrbBlock> {
    private boolean containRecipe;
    private long requiredEnergy;
    private long energy;
    @Nullable
    private EnergizingRecipe recipe;

    public EnergizingOrbTile() {
        super(ITiles.ENERGIZING_ORB);
        this.inv.set(7);
    }

    public void readSync(CompoundNBT compound) {
        super.readSync(compound);
        this.containRecipe = compound.func_74767_n("ContainRecipe");
        this.requiredEnergy = compound.func_74763_f("RequiredEnergy");
        this.energy = compound.func_74763_f("EnergyBuffer");
    }

    public CompoundNBT writeSync(CompoundNBT compound) {
        compound.func_74757_a("ContainRecipe", this.containRecipe);
        compound.func_74772_a("RequiredEnergy", this.requiredEnergy);
        compound.func_74772_a("EnergyBuffer", this.energy);
        return super.writeSync(compound);
    }

    @Nullable
    public EnergizingRecipe currRecipe() {
        return this.recipe;
    }

    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        this.checkRecipe();
    }

    public void onSlotChanged(int index) {
        if (!this.isRemote()) {
            this.energy = 0L;
            this.checkRecipe();
        }
    }

    private void checkRecipe() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(Recipes.ENERGIZING, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.getInventory()), this.field_145850_b);
            if (recipe.isPresent()) {
                this.recipe = (EnergizingRecipe)recipe.get();
                this.requiredEnergy = this.recipe.getEnergy();
            } else {
                this.requiredEnergy = 0L;
            }
            this.setContainRecipe(recipe.isPresent());
            this.sync(1);
        }
    }

    public long fillEnergy(long amount) {
        long filled = Math.min(this.requiredEnergy - this.energy, amount);
        if (this.field_145850_b != null && this.recipe != null) {
            this.energy += filled;
            if (this.energy >= this.requiredEnergy) {
                ItemStack stack = this.recipe.func_77571_b();
                this.inv.clear();
                this.inv.setStack(0, stack.func_77946_l());
                this.requiredEnergy = 0L;
                this.energy = 0L;
                this.func_70296_d();
            }
        }
        return filled;
    }

    public boolean containRecipe() {
        return this.containRecipe;
    }

    public void setContainRecipe(boolean containRecipe) {
        this.containRecipe = containRecipe;
    }

    public long getRequiredEnergy() {
        return this.requiredEnergy;
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int getSlotLimit(int index) {
        return index == 0 ? 64 : 1;
    }

    public boolean canExtract(int slot, ItemStack stack) {
        return slot == 0;
    }

    public boolean canInsert(int index, ItemStack stack) {
        return index != 0 && this.inv.getStackInSlot(0).func_190926_b() && this.inv.getStackInSlot(index).func_190926_b();
    }
}

