/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.item;

import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.RefinedRelocation;
import net.blay09.mods.refinedrelocation.SortingChestType;
import net.blay09.mods.refinedrelocation.block.SortingChestBlock;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingUpgradable;
import net.blay09.mods.refinedrelocation.tile.SortingChestTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class SortingUpgradeItem
extends Item {
    public static final String name = "sorting_upgrade";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "sorting_upgrade");

    public SortingUpgradeItem() {
        super(new Item.Properties().func_200916_a(RefinedRelocation.itemGroup));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack itemStack = context.func_195996_i();
        Hand hand = Hand.MAIN_HAND;
        if (!world.field_72995_K) {
            BlockState state = world.func_180495_p(pos);
            if ((state.func_177230_c() == Blocks.field_150486_ae || state.func_177230_c() == Blocks.field_150447_bR) && SortingUpgradeItem.upgradeVanillaChest(player, world, pos, state)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null && tileEntity.getCapability(CapabilitySortingUpgradable.CAPABILITY, facing).isPresent()) {
                LazyOptional sortingUpgradableCap = tileEntity.getCapability(CapabilitySortingUpgradable.CAPABILITY, facing);
                return (ActionResultType)sortingUpgradableCap.map(sortingUpgradable -> {
                    Vec3d hit = context.func_221532_j();
                    if (sortingUpgradable.applySortingUpgrade(tileEntity, itemStack, player, world, pos, facing, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, hand)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemStack.func_190918_g(1);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.PASS;
                }).orElse((Object)ActionResultType.PASS);
            }
        }
        return ActionResultType.PASS;
    }

    private static boolean upgradeVanillaChest(PlayerEntity player, World world, BlockPos pos, BlockState state) {
        ChestTileEntity tileEntity = (ChestTileEntity)world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (ChestTileEntity.func_195481_a((IBlockReader)world, (BlockPos)pos) > 0) {
            return false;
        }
        ItemStack[] inventory = new ItemStack[tileEntity.func_70302_i_()];
        for (int i = 0; i < inventory.length; ++i) {
            inventory[i] = tileEntity.func_70301_a(i);
        }
        tileEntity.func_174888_l();
        BlockState newState = (BlockState)ModBlocks.sortingChests[SortingChestType.WOOD.ordinal()].func_176223_P().func_206870_a(SortingChestBlock.FACING, state.func_177229_b((IProperty)ChestBlock.field_176459_a));
        world.func_175656_a(pos, newState);
        SortingChestTileEntity tileSortingChest = (SortingChestTileEntity)world.func_175625_s(pos);
        if (tileSortingChest != null) {
            for (int i = 0; i < inventory.length; ++i) {
                tileSortingChest.getItemHandler().setStackInSlot(i, inventory[i]);
            }
        }
        return true;
    }
}

