/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.blay09.mods.refinedrelocation.ModItems;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.client.gui.base.ModContainerScreen;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiButtonBlockExtenderFilter;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiButtonStackLimiter;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiSideButton;
import net.blay09.mods.refinedrelocation.client.gui.element.GuiTooltipButton;
import net.blay09.mods.refinedrelocation.container.BlockExtenderContainer;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BlockExtenderScreen
extends ModContainerScreen<BlockExtenderContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedrelocation", "textures/gui/block_extender.png");
    private static final int UPDATE_INTERVAL = 20;
    private final TileBlockExtender tileEntity;
    private GuiButtonStackLimiter btnStackLimiter;
    private GuiButtonBlockExtenderFilter btnInputFilter;
    private GuiButtonBlockExtenderFilter btnOutputFilter;
    private Button btnSlotLock;
    private int stackLimiterIdx;
    private int slotLockIdx;
    private int inputFilterIdx;
    private int outputFilterIdx;
    private int ticksSinceUpdate;
    private int lastSentStackLimit;

    public BlockExtenderScreen(BlockExtenderContainer container, PlayerInventory playerInventory, ITextComponent displayName) {
        super(container, playerInventory, displayName);
        this.tileEntity = container.getTileEntity();
        this.field_147000_g = 176;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiSideButton(this.field_147003_i + 9, this.field_147009_r + 40, this.tileEntity, RelativeSide.LEFT));
        this.addButton(new GuiSideButton(this.field_147003_i + 26, this.field_147009_r + 40, this.tileEntity, RelativeSide.FRONT));
        this.addButton(new GuiSideButton(this.field_147003_i + 43, this.field_147009_r + 40, this.tileEntity, RelativeSide.RIGHT));
        this.addButton(new GuiSideButton(this.field_147003_i + 60, this.field_147009_r + 40, this.tileEntity, RelativeSide.BACK));
        this.addButton(new GuiSideButton(this.field_147003_i + 26, this.field_147009_r + 23, this.tileEntity, RelativeSide.TOP));
        this.addButton(new GuiSideButton(this.field_147003_i + 26, this.field_147009_r + 57, this.tileEntity, RelativeSide.BOTTOM));
        this.btnStackLimiter = new GuiButtonStackLimiter(0, 0, 24, 16, this.tileEntity);
        this.btnStackLimiter.visible = false;
        this.addButton(this.btnStackLimiter);
        this.btnInputFilter = new GuiButtonBlockExtenderFilter(0, 0, 0, 64, 16, false);
        this.btnInputFilter.visible = false;
        this.addButton(this.btnInputFilter);
        this.btnOutputFilter = new GuiButtonBlockExtenderFilter(0, 0, 0, 64, 16, true);
        this.btnOutputFilter.visible = false;
        this.addButton(this.btnOutputFilter);
        this.btnSlotLock = new GuiTooltipButton(0, 0, 64, 16, I18n.func_135052_a((String)"gui.refinedrelocation:block_extender.slot_lock", (Object[])new Object[0]), it -> {}){

            @Override
            public void addTooltip(List<String> list) {
                list.add(I18n.func_135052_a((String)"tooltip.refinedrelocation:slot_lock", (Object[])new Object[0]));
            }
        };
        this.btnSlotLock.visible = false;
        this.btnSlotLock.active = false;
        this.addButton(this.btnSlotLock);
    }

    @Override
    public void tick() {
        super.tick();
        this.stackLimiterIdx = -1;
        this.slotLockIdx = -1;
        this.inputFilterIdx = -1;
        this.outputFilterIdx = -1;
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = ((BlockExtenderContainer)this.field_147002_h).getUpgradeSlot(i).func_75211_c();
            if (itemStack.func_190926_b()) continue;
            if (itemStack.func_77973_b() == ModItems.stackLimiter) {
                this.stackLimiterIdx = i;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.slotLock) {
                this.slotLockIdx = i;
                continue;
            }
            if (itemStack.func_77973_b() == ModItems.inputFilter) {
                this.inputFilterIdx = i;
                continue;
            }
            if (itemStack.func_77973_b() != ModItems.outputFilter) continue;
            this.outputFilterIdx = i;
        }
        this.btnStackLimiter.visible = this.stackLimiterIdx != -1;
        this.btnStackLimiter.x = this.field_147003_i + 152 - this.btnStackLimiter.getWidth() - 3;
        this.btnStackLimiter.y = this.field_147009_r + 22 + this.stackLimiterIdx * 18;
        this.btnSlotLock.visible = this.slotLockIdx != -1;
        this.btnSlotLock.x = this.field_147003_i + 152 - this.btnSlotLock.getWidth() - 3;
        this.btnSlotLock.y = this.field_147009_r + 22 + this.slotLockIdx * 18;
        this.btnInputFilter.visible = this.inputFilterIdx != -1;
        this.btnInputFilter.x = this.field_147003_i + 152 - this.btnInputFilter.getWidth() - 3;
        this.btnInputFilter.y = this.field_147009_r + 22 + this.inputFilterIdx * 18;
        this.btnOutputFilter.visible = this.outputFilterIdx != -1;
        this.btnOutputFilter.x = this.field_147003_i + 152 - this.btnOutputFilter.getWidth() - 3;
        this.btnOutputFilter.y = this.field_147009_r + 22 + this.outputFilterIdx * 18;
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            if (this.lastSentStackLimit != this.tileEntity.getStackLimiterLimit()) {
                RefinedRelocationAPI.sendContainerMessageToServer("StackLimiter", this.tileEntity.getStackLimiterLimit());
                this.lastSentStackLimit = this.tileEntity.getStackLimiterLimit();
            }
            this.ticksSinceUpdate = 0;
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        ItemStack mouseStack;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = mouseStack = player != null ? player.field_71071_by.func_70445_o() : ItemStack.field_190927_a;
        if (!mouseStack.func_190926_b()) {
            int conflictSlot = -1;
            if (mouseStack.func_77973_b() == ModItems.stackLimiter && this.stackLimiterIdx != -1) {
                conflictSlot = this.stackLimiterIdx;
            } else if (mouseStack.func_77973_b() == ModItems.slotLock && this.slotLockIdx != -1) {
                conflictSlot = this.slotLockIdx;
            } else if (mouseStack.func_77973_b() == ModItems.inputFilter && this.inputFilterIdx != -1) {
                conflictSlot = this.inputFilterIdx;
            } else if (mouseStack.func_77973_b() == ModItems.outputFilter && this.outputFilterIdx != -1) {
                conflictSlot = this.outputFilterIdx;
            }
            if (conflictSlot != -1) {
                Slot slot = ((BlockExtenderContainer)this.field_147002_h).getUpgradeSlot(conflictSlot);
                AbstractGui.fill((int)(this.field_147003_i + slot.field_75223_e), (int)(this.field_147009_r + slot.field_75221_f), (int)(this.field_147003_i + slot.field_75223_e + 16), (int)(this.field_147009_r + slot.field_75221_f + 16), (int)0x55FF0000);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.font.func_211126_b(this.getTitle().func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    @Override
    public boolean onGuiAboutToClose() {
        RefinedRelocationAPI.sendContainerMessageToServer("StackLimiter", this.tileEntity.getStackLimiterLimit());
        return true;
    }
}

