/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.BasicTreeFeature;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;

public class MahoganyTreeFeature
extends BasicTreeFeature {
    protected MahoganyTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int leafLayers, int leavesOffset, int maxLeavesRadius, int leavesLayerHeight, IBlockPosQuery placeVinesOn, float hangingChance) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight, leafLayers, leavesOffset, maxLeavesRadius, leavesLayerHeight, placeVinesOn, hangingChance);
    }

    @Override
    protected void generateTrunk(Set<BlockPos> changedBlocks, MutableBoundingBox boundingBox, IWorld world, BlockPos start, int height) {
        int endHeight = height - this.leafLayers;
        for (int layer = 0; layer <= endHeight - 3; ++layer) {
            BlockPos middlePos = start.func_177981_b(layer);
            if (!this.replace.matches(world, middlePos)) continue;
            this.placeLog(world, middlePos, changedBlocks, boundingBox);
        }
        BlockPos branchStartPos = start.func_177981_b(endHeight - 2);
        int branchHeight = this.leafLayers - 1 + 1;
        this.generateBranch(changedBlocks, boundingBox, world, branchStartPos, Direction.NORTH, branchHeight);
        this.generateBranch(changedBlocks, boundingBox, world, branchStartPos, Direction.EAST, branchHeight);
        this.generateBranch(changedBlocks, boundingBox, world, branchStartPos, Direction.SOUTH, branchHeight);
        this.generateBranch(changedBlocks, boundingBox, world, branchStartPos, Direction.WEST, branchHeight);
    }

    private void generateBranch(Set<BlockPos> changedBlocks, MutableBoundingBox boundingBox, IWorld world, BlockPos middle, Direction direction, int height) {
        BlockPos pos = middle.func_177972_a(direction);
        if (this.replace.matches(world, pos)) {
            this.placeLog(world, pos, direction.func_176740_k(), changedBlocks, boundingBox);
        }
        for (int i = 0; i <= height - 1; ++i) {
            pos = middle.func_177967_a(direction, 2).func_177981_b(i + 1);
            if (!this.replace.matches(world, pos)) continue;
            this.placeLog(world, pos, Direction.Axis.Y, changedBlocks, boundingBox);
        }
        Direction logDirection = direction.func_176746_e();
        for (int i = -1; i <= 1; ++i) {
            pos = middle.func_177967_a(direction, 3).func_177967_a(logDirection, i).func_177981_b(height - 1);
            if (!this.replace.matches(world, pos)) continue;
            this.placeLog(world, pos, logDirection.func_176740_k(), changedBlocks, boundingBox);
        }
    }

    public static class Builder
    extends BasicTreeFeature.InnerBuilder<Builder, MahoganyTreeFeature> {
        public Builder() {
            this.log = BOPBlocks.mahogany_log.func_176223_P();
            this.leaves = BOPBlocks.mahogany_leaves.func_176223_P();
            this.minHeight = 10;
            this.maxHeight = 15;
            this.leavesLayerHeight = 1;
        }

        @Override
        public MahoganyTreeFeature create() {
            return new MahoganyTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.leafLayers, this.leavesOffset, this.maxLeavesRadius, this.leavesLayerHeight, this.placeVinesOn, this.hangingChance);
        }
    }
}

