/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.Utils;

public class ChronalExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private int tickCounter = 0;
    private long placedTime = 0L;
    private static final String PLACED_TIME_TAG = "MAHOUTSUKAI_PLACED_TIME_TAG";

    public ChronalExchangeMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.chronalExchange);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter == MTConfig.CHRONAL_EXCHANGE_BLOCK_CYCLE) {
                this.doManaGenOrLoss();
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void setPlacedTime(long t) {
        this.placedTime = t;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a(PLACED_TIME_TAG, this.placedTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.placedTime = compound.func_74763_f(PLACED_TIME_TAG);
        super.func_145839_a(compound);
    }

    public void doManaGenOrLoss() {
        IMahou mahou;
        PlayerEntity player = this.getCaster();
        if (player != null && (mahou = Utils.getPlayerMahou((LivingEntity)player)) != null) {
            int restore = this.calculateMana();
            if (restore < 0) {
                PlayerManaManager.drainMana(player, -restore, false, false);
            } else {
                int storedMana = mahou.getStoredMana();
                mahou.setStoredMana(Math.min(storedMana + restore, mahou.getMaxMana()));
            }
            PlayerManaManager.updateClientMahou((ServerPlayerEntity)player, mahou);
        }
    }

    public int calculateMana() {
        long now = this.field_145850_b.func_72820_D() % 24000L;
        if (now < 0L) {
            now += 24000L;
        }
        boolean flag = this.timeInRange(now, this.placedTime) || this.timeInRange(now - 24000L, this.placedTime) || this.timeInRange(now + 24000L, this.placedTime);
        return flag ? MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS : -MTConfig.CHRONAL_EXCHANGE_MANA_GAIN_LOSS;
    }

    public boolean timeInRange(long x, long y) {
        return x < y + 6000L && x >= y - 6000L;
    }
}

