/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity.familiar;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.entity.familiar.RenderFamiliarEntity;

@OnlyIn(value=Dist.CLIENT)
public class FamiliarModelRenderer
extends ModelRenderer {
    private float textureWidth = 64.0f;
    private float textureHeight;
    private int textureOffsetX;
    private int textureOffsetY;
    public float field_78800_c;
    public float field_78797_d;
    public float field_78798_e;
    public float field_78795_f;
    public float field_78796_g;
    public float field_78808_h;
    public boolean field_78809_i;
    public boolean field_78806_j;
    public final ObjectList<ModelBox> field_78804_l;
    public final ObjectList<FamiliarModelRenderer> field_78805_m;
    public boolean isRenderChild = false;

    public FamiliarModelRenderer(Model model) {
        super(model);
        this.textureHeight = 64.0f;
        this.field_78806_j = true;
        this.field_78804_l = new ObjectArrayList();
        this.field_78805_m = new ObjectArrayList();
        model.accept((ModelRenderer)this);
        this.setTextureSize(model.field_78090_t, model.field_78089_u);
    }

    public FamiliarModelRenderer(Model model, int texU, int texV) {
        this(model.field_78090_t, model.field_78089_u, texU, texV);
        model.accept((ModelRenderer)this);
    }

    public FamiliarModelRenderer(int texX, int texY, int offsetU, int offsetV) {
        super(texX, texY, offsetU, offsetV);
        this.textureHeight = 32.0f;
        this.field_78806_j = true;
        this.field_78804_l = new ObjectArrayList();
        this.field_78805_m = new ObjectArrayList();
        this.setTextureSize(texX, texY);
        this.setTextureOffset(offsetU, offsetV);
    }

    public void copyModelAngles(FamiliarModelRenderer renderer) {
        this.field_78795_f = renderer.field_78795_f;
        this.field_78796_g = renderer.field_78796_g;
        this.field_78808_h = renderer.field_78808_h;
        this.field_78800_c = renderer.field_78800_c;
        this.field_78797_d = renderer.field_78797_d;
        this.field_78798_e = renderer.field_78798_e;
    }

    public void addChild(FamiliarModelRenderer renderer) {
        this.field_78805_m.add((Object)renderer);
    }

    public FamiliarModelRenderer setTextureOffset(int offsetX, int offsetY) {
        this.textureOffsetX = offsetX;
        this.textureOffsetY = offsetY;
        return this;
    }

    public FamiliarModelRenderer addBox(String name, float p_217178_2_, float p_217178_3_, float p_217178_4_, int p_217178_5_, int p_217178_6_, int p_217178_7_, float p_217178_8_, int p_217178_9_, int p_217178_10_) {
        this.setTextureOffset(p_217178_9_, p_217178_10_);
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_217178_2_, p_217178_3_, p_217178_4_, p_217178_5_, p_217178_6_, p_217178_7_, p_217178_8_, p_217178_8_, p_217178_8_, this.field_78809_i, false);
        return this;
    }

    public FamiliarModelRenderer addBox(float p_228300_1_, float p_228300_2_, float p_228300_3_, float p_228300_4_, float p_228300_5_, float p_228300_6_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228300_1_, p_228300_2_, p_228300_3_, p_228300_4_, p_228300_5_, p_228300_6_, 0.0f, 0.0f, 0.0f, this.field_78809_i, false);
        return this;
    }

    public FamiliarModelRenderer addBox(float p_228304_1_, float p_228304_2_, float p_228304_3_, float p_228304_4_, float p_228304_5_, float p_228304_6_, boolean p_228304_7_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228304_1_, p_228304_2_, p_228304_3_, p_228304_4_, p_228304_5_, p_228304_6_, 0.0f, 0.0f, 0.0f, p_228304_7_, false);
        return this;
    }

    public void func_228301_a_(float p_228301_1_, float p_228301_2_, float p_228301_3_, float p_228301_4_, float p_228301_5_, float p_228301_6_, float p_228301_7_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228301_1_, p_228301_2_, p_228301_3_, p_228301_4_, p_228301_5_, p_228301_6_, p_228301_7_, p_228301_7_, p_228301_7_, this.field_78809_i, false);
    }

    public void func_228302_a_(float p_228302_1_, float p_228302_2_, float p_228302_3_, float p_228302_4_, float p_228302_5_, float p_228302_6_, float p_228302_7_, float p_228302_8_, float p_228302_9_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228302_1_, p_228302_2_, p_228302_3_, p_228302_4_, p_228302_5_, p_228302_6_, p_228302_7_, p_228302_8_, p_228302_9_, this.field_78809_i, false);
    }

    public void func_228303_a_(float p_228303_1_, float p_228303_2_, float p_228303_3_, float p_228303_4_, float p_228303_5_, float p_228303_6_, float p_228303_7_, boolean p_228303_8_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228303_1_, p_228303_2_, p_228303_3_, p_228303_4_, p_228303_5_, p_228303_6_, p_228303_7_, p_228303_7_, p_228303_7_, p_228303_8_, false);
    }

    private void addBox(int p_228305_1_, int p_228305_2_, float p_228305_3_, float p_228305_4_, float p_228305_5_, float p_228305_6_, float p_228305_7_, float p_228305_8_, float p_228305_9_, float p_228305_10_, float p_228305_11_, boolean p_228305_12_, boolean p_228305_13_) {
        this.field_78804_l.add((Object)new ModelBox(p_228305_1_, p_228305_2_, p_228305_3_, p_228305_4_, p_228305_5_, p_228305_6_, p_228305_7_, p_228305_8_, p_228305_9_, p_228305_10_, p_228305_11_, p_228305_12_, this.textureWidth, this.textureHeight));
    }

    public void func_78793_a(float p_78793_1_, float p_78793_2_, float p_78793_3_) {
        this.field_78800_c = p_78793_1_;
        this.field_78797_d = p_78793_2_;
        this.field_78798_e = p_78793_3_;
    }

    public void func_228308_a_(MatrixStack p_228308_1_, IVertexBuilder p_228308_2_, int p_228308_3_, int p_228308_4_) {
        this.func_228309_a_(p_228308_1_, p_228308_2_, p_228308_3_, p_228308_4_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(MatrixStack p_228308_1_, IRenderTypeBuffer p_228308_2_, int p_228308_3_, int p_228308_4_) {
        this.render(p_228308_1_, p_228308_2_, p_228308_3_, p_228308_4_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(MatrixStack p_228309_1_, IRenderTypeBuffer p_228309_2_, int p_228309_3_, int p_228309_4_, float p_228309_5_, float p_228309_6_, float p_228309_7_, float p_228309_8_) {
        if (!(!this.field_78806_j || this.field_78804_l.isEmpty() && this.field_78805_m.isEmpty())) {
            p_228309_1_.func_227860_a_();
            this.func_228307_a_(p_228309_1_);
            IVertexBuilder bb = this.isRenderChild ? p_228309_2_.getBuffer(MahoujinRenderType.createMahoujinRenderType(RenderFamiliarEntity.t2, 0, false)) : p_228309_2_.getBuffer(MahoujinRenderType.createMahoujinRenderType(RenderFamiliarEntity.t1, 0, false));
            if (!this.isRenderChild) {
                this.doRender(p_228309_1_.func_227866_c_(), bb, p_228309_3_, p_228309_4_, p_228309_5_, p_228309_6_, p_228309_7_, p_228309_8_);
            } else {
                this.doRender(p_228309_1_.func_227866_c_(), bb, p_228309_3_, p_228309_4_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (FamiliarModelRenderer offsetu : this.field_78805_m) {
                offsetu.render(p_228309_1_, p_228309_2_, p_228309_3_, p_228309_4_, p_228309_5_, p_228309_6_, p_228309_7_, p_228309_8_);
            }
            p_228309_1_.func_227865_b_();
        }
    }

    public void func_228309_a_(MatrixStack p_228309_1_, IVertexBuilder p_228309_2_, int p_228309_3_, int p_228309_4_, float p_228309_5_, float p_228309_6_, float p_228309_7_, float p_228309_8_) {
        if (!(!this.field_78806_j || this.field_78804_l.isEmpty() && this.field_78805_m.isEmpty())) {
            p_228309_1_.func_227860_a_();
            this.func_228307_a_(p_228309_1_);
            this.doRender(p_228309_1_.func_227866_c_(), p_228309_2_, p_228309_3_, p_228309_4_, p_228309_5_, p_228309_6_, p_228309_7_, p_228309_8_);
            for (FamiliarModelRenderer offsetu : this.field_78805_m) {
                offsetu.func_228309_a_(p_228309_1_, p_228309_2_, p_228309_3_, p_228309_4_, p_228309_5_, p_228309_6_, p_228309_7_, p_228309_8_);
            }
            p_228309_1_.func_227865_b_();
        }
    }

    public void func_228307_a_(MatrixStack p_228307_1_) {
        p_228307_1_.func_227861_a_((double)(this.field_78800_c / 16.0f), (double)(this.field_78797_d / 16.0f), (double)(this.field_78798_e / 16.0f));
        if (this.field_78808_h != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.field_78808_h));
        }
        if (this.field_78796_g != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.field_78796_g));
        }
        if (this.field_78795_f != 0.0f) {
            p_228307_1_.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(this.field_78795_f));
        }
    }

    private void doRender(MatrixStack.Entry p_228306_1_, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        Matrix4f lvt_9_1_ = p_228306_1_.func_227870_a_();
        Matrix3f offsetu = p_228306_1_.func_227872_b_();
        for (ModelBox box : this.field_78804_l) {
            for (TexturedQuad endY : box.quads) {
                Vector3f endZ = endY.normal.func_229195_e_();
                endZ.func_229188_a_(offsetu);
                float zx = endZ.func_195899_a();
                float zy = endZ.func_195900_b();
                float zz = endZ.func_195902_c();
                for (int k = 0; k < 4; ++k) {
                    PositionTextureVertex vertex = endY.vertexPositions[k];
                    float lvt_23_1_ = vertex.position.func_195899_a() / 16.0f;
                    float lvt_24_1_ = vertex.position.func_195900_b() / 16.0f;
                    float lvt_25_1_ = vertex.position.func_195902_c() / 16.0f;
                    Vector4f vec = new Vector4f(lvt_23_1_, lvt_24_1_, lvt_25_1_, 1.0f);
                    vec.func_229372_a_(lvt_9_1_);
                    builder.func_225588_a_(vec.func_195910_a(), vec.func_195913_b(), vec.func_195914_c(), r, g, b, a, vertex.textureU, vertex.textureV, overlay, light, zx, zy, zz);
                }
            }
        }
    }

    public FamiliarModelRenderer setTextureSize(int p_78787_1_, int p_78787_2_) {
        this.textureWidth = p_78787_1_;
        this.textureHeight = p_78787_2_;
        return this;
    }

    public ModelBox getRandomCube(Random p_228310_1_) {
        return (ModelBox)((Object)this.field_78804_l.get(p_228310_1_.nextInt(this.field_78804_l.size())));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelBox
    extends ModelRenderer.ModelBox {
        private final TexturedQuad[] quads;
        public final float field_78252_a;
        public final float field_78250_b;
        public final float field_78251_c;
        public final float field_78248_d;
        public final float field_78249_e;
        public final float field_78246_f;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirrorIn, float texHeight, float texWidth) {
            super(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirrorIn, texHeight, texWidth);
            this.field_78252_a = x;
            this.field_78250_b = y;
            this.field_78251_c = z;
            this.field_78248_d = x + width;
            this.field_78249_e = y + height;
            this.field_78246_f = z + depth;
            this.quads = new TexturedQuad[6];
            float endX = x + width;
            float endY = y + height;
            float endZ = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            endX += deltaX;
            endY += deltaY;
            endZ += deltaZ;
            if (mirrorIn) {
                float swap = endX;
                endX = x;
                x = swap;
            }
            PositionTextureVertex lvt_18_2_ = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex lvt_19_1_ = new PositionTextureVertex(endX, y, z, 0.0f, 8.0f);
            PositionTextureVertex lvt_20_1_ = new PositionTextureVertex(endX, endY, z, 8.0f, 8.0f);
            PositionTextureVertex k = new PositionTextureVertex(x, endY, z, 8.0f, 0.0f);
            PositionTextureVertex lvt_22_1_ = new PositionTextureVertex(x, y, endZ, 0.0f, 0.0f);
            PositionTextureVertex lvt_23_1_ = new PositionTextureVertex(endX, y, endZ, 0.0f, 8.0f);
            PositionTextureVertex lvt_24_1_ = new PositionTextureVertex(endX, endY, endZ, 8.0f, 8.0f);
            PositionTextureVertex lvt_25_1_ = new PositionTextureVertex(x, endY, endZ, 8.0f, 0.0f);
            float vec = texOffX;
            float lvt_27_1_ = (float)texOffX + depth;
            float lvt_28_1_ = (float)texOffX + depth + width;
            float lvt_29_1_ = (float)texOffX + depth + width + width;
            float lvt_30_1_ = (float)texOffX + depth + width + depth;
            float lvt_31_1_ = (float)texOffX + depth + width + depth + width;
            float lvt_32_1_ = texOffY;
            float lvt_33_1_ = (float)texOffY + depth;
            float lvt_34_1_ = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{lvt_23_1_, lvt_22_1_, lvt_18_2_, lvt_19_1_}, lvt_27_1_, lvt_32_1_, lvt_28_1_, lvt_33_1_, texHeight, texWidth, mirrorIn, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{lvt_20_1_, k, lvt_25_1_, lvt_24_1_}, lvt_28_1_, lvt_33_1_, lvt_29_1_, lvt_32_1_, texHeight, texWidth, mirrorIn, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{lvt_18_2_, lvt_22_1_, lvt_25_1_, k}, vec, lvt_33_1_, lvt_27_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{lvt_19_1_, lvt_18_2_, k, lvt_20_1_}, lvt_27_1_, lvt_33_1_, lvt_28_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{lvt_23_1_, lvt_19_1_, lvt_20_1_, lvt_24_1_}, lvt_28_1_, lvt_33_1_, lvt_30_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{lvt_22_1_, lvt_23_1_, lvt_24_1_, lvt_25_1_}, lvt_30_1_, lvt_33_1_, lvt_31_1_, lvt_34_1_, texHeight, texWidth, mirrorIn, Direction.SOUTH);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positions, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirror, Direction facing) {
            this.vertexPositions = positions;
            float offsetu = 0.0f / texWidth;
            float offsetv = 0.0f / texHeight;
            positions[0] = positions[0].setTextureUV(0.0f, 0.0f);
            positions[1] = positions[1].setTextureUV(0.0f, 1.0f);
            positions[2] = positions[2].setTextureUV(1.0f, 1.0f);
            positions[3] = positions[3].setTextureUV(1.0f, 0.0f);
            if (mirror) {
                int box = positions.length;
                for (int lvt_13_1_ = 0; lvt_13_1_ < box / 2; ++lvt_13_1_) {
                    PositionTextureVertex lvt_14_1_ = positions[lvt_13_1_];
                    positions[lvt_13_1_] = positions[box - 1 - lvt_13_1_];
                    positions[box - 1 - lvt_13_1_] = lvt_14_1_;
                }
            }
            this.normal = facing.func_229386_k_();
            if (mirror) {
                this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float p_i1158_1_, float p_i1158_2_, float p_i1158_3_, float p_i1158_4_, float p_i1158_5_) {
            this(new Vector3f(p_i1158_1_, p_i1158_2_, p_i1158_3_), p_i1158_4_, p_i1158_5_);
        }

        public PositionTextureVertex setTextureUV(float p_78240_1_, float p_78240_2_) {
            return new PositionTextureVertex(this.position, p_78240_1_, p_78240_2_);
        }

        public PositionTextureVertex(Vector3f p_i225952_1_, float p_i225952_2_, float p_i225952_3_) {
            this.position = p_i225952_1_;
            this.textureU = p_i225952_2_;
            this.textureV = p_i225952_3_;
        }
    }
}

