/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.AuthorityMahoujinEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ScrollPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BorrowedAuthorityPotion
extends ScrollPotion {
    public static final UUID speedauthority = UUID.fromString("91AEAA56-376B-4498-935B-2F7F20090635");

    protected BorrowedAuthorityPotion() {
        super(ModEffects.getColorNumber(255, 255, 51));
    }

    public static void authorityPlayerTick(PlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            if (player.func_70644_a(ModEffects.BORROWED_AUTHORITY)) {
                if (!player.func_226273_bm_()) {
                    AttributeModifier a = new AttributeModifier(speedauthority, "authority_speed", MTConfig.AUTHORITY_SPEED_MULTIPLIER, AttributeModifier.Operation.MULTIPLY_BASE);
                    if (!player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(a)) {
                        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(a);
                    }
                } else {
                    player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(speedauthority);
                }
            } else {
                player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(speedauthority);
            }
        }
    }

    public static void authorityJump(LivingEntity living) {
        PlayerEntity player;
        if (living instanceof PlayerEntity && (player = (PlayerEntity)living).func_70644_a(ModEffects.BORROWED_AUTHORITY)) {
            player.func_213293_j(player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b + 0.2, player.func_213322_ci().field_72449_c);
        }
    }

    public static void authorityLivingUpdate(LivingEntity entity) {
        IMahou mahou;
        int offspeed = 5;
        if (entity != null && (mahou = Utils.getPlayerMahou(entity)) != null && mahou.getAuthorityHit()) {
            Vec3d xyz = entity.func_213322_ci();
            if (!entity.field_70170_p.field_72995_K) {
                if (xyz.func_189985_c() < (double)(offspeed * offspeed)) {
                    mahou.setAuthorityHit(false);
                    entity.field_70145_X = false;
                } else {
                    entity.field_70160_al = true;
                    entity.field_70122_E = false;
                    entity.field_70145_X = true;
                    double factor1 = MTConfig.AUTHORITY_NORMAL_SLOW_DOWN_FACTOR;
                    xyz = xyz.func_186678_a(factor1);
                    entity.func_213317_d(xyz);
                    if (entity.field_70170_p.func_72820_D() % 2L == 0L) {
                        AuthorityMahoujinEntity ame = new AuthorityMahoujinEntity(entity.field_70170_p, entity, 1.0f, 1.0f, 0.2f, 0.95f, 4.0f);
                        ame.setRotationSpeed(0.2f);
                        entity.field_70170_p.func_217376_c((Entity)ame);
                    }
                    Vec3d epos = entity.func_174791_d();
                    Vec3d motionV = entity.func_213322_ci();
                    int destroyed = 0;
                    ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
                    int i = 0;
                    while ((double)i < motionV.func_72433_c()) {
                        BlockPos nextTick = new BlockPos(epos.func_178787_e(motionV.func_72432_b().func_186678_a((double)i)));
                        Stream poss = BlockPos.func_218281_b((BlockPos)nextTick.func_177982_a(-1, -1, -1), (BlockPos)nextTick.func_177982_a(1, 1, 1));
                        poss.forEach(tmp -> {
                            BlockPos p = new BlockPos(tmp.func_177958_n(), tmp.func_177956_o(), tmp.func_177952_p());
                            BlockState bs = entity.field_70170_p.func_180495_p(p);
                            if (!Utils.isBlockAir(entity.field_70170_p, p) && (double)bs.func_177230_c().getExplosionResistance(bs, (IWorldReader)entity.field_70170_p, p, null, null) <= (double)MTConfig.AUTHORITY_BLOCK_RESISTANCE_LIMIT + 0.01 && entity.field_70170_p.func_175625_s(p) == null) {
                                affected.add(p);
                            } else if (!Utils.isBlockAir(entity.field_70170_p, p)) {
                                entity.field_70145_X = false;
                            }
                        });
                        destroyed = affected.size();
                        ++i;
                    }
                    EffectUtil.tryFakeExplosion(affected, (Entity)entity, null, "borrowed_authority", true);
                    if (destroyed > 0) {
                        double factor = MTConfig.AUTHORITY_BREAK_SLOW_DOWN_FACTOR;
                        xyz.func_186678_a(factor);
                    }
                    entity.func_213317_d(xyz);
                }
            }
        }
    }

    public static void authorityAttackFromPlayer(PlayerEntity player, Entity target) {
        double damage = MTConfig.AUTHORITY_DAMAGE_TO_OTHER;
        double damageToSelf = MTConfig.AUTHORITY_DAMAGE_TO_SELF;
        if (player.func_70644_a(ModEffects.BORROWED_AUTHORITY) && player.field_70170_p != null && !player.field_70170_p.field_72995_K && target instanceof LivingEntity) {
            Vec3d pv = player.func_174791_d();
            Vec3d look = pv.func_178788_d(target.func_213303_ch());
            BorrowedAuthorityPotion.borrowedAuthorityBoop(target, 16.0f, look.field_72450_a, look.field_72448_b, look.field_72449_c, 2.0);
            IMahou targetMahou = Utils.getPlayerMahou((LivingEntity)target);
            if (targetMahou != null) {
                targetMahou.setAuthorityHit(true);
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)damage);
                player.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)damageToSelf);
                AuthorityMahoujinEntity ame = new AuthorityMahoujinEntity(target.field_70170_p, (LivingEntity)target, player.func_174824_e(1.0f), player.func_70040_Z(), 1.0f, 1.0f, 0.2f, 0.95f, 4.0f);
                ame.setRotationSpeed(0.2f);
                target.field_70170_p.func_217376_c((Entity)ame);
                Vec3d epos = target.func_174791_d();
                Vec3d motionV = target.func_213322_ci();
                BorrowedAuthorityPotion.makeHoleWithTarget(target.field_70170_p, target, epos, motionV);
            }
        }
    }

    public static void makeHoleWithTarget(World world, Entity target, Vec3d epos, Vec3d motionV) {
        ArrayList<BlockPos> affected = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i < motionV.func_72433_c()) {
            BlockPos nextTick = new BlockPos(epos.func_178787_e(motionV.func_72432_b().func_186678_a((double)i)));
            Stream poss = BlockPos.func_218281_b((BlockPos)nextTick.func_177982_a(-1, -1, -1), (BlockPos)nextTick.func_177982_a(1, 1, 1));
            poss.forEach(tmp -> {
                BlockPos p = new BlockPos(tmp.func_177958_n(), tmp.func_177956_o(), tmp.func_177952_p());
                BlockState bs = world.func_180495_p(p);
                if (!Utils.isBlockAir(world, p) && (double)bs.func_177230_c().getExplosionResistance(bs, (IWorldReader)world, p, null, null) <= (double)MTConfig.AUTHORITY_BLOCK_RESISTANCE_LIMIT + 0.01 && target.field_70170_p.func_175625_s(p) == null) {
                    affected.add(p);
                }
            });
            ++i;
        }
        EffectUtil.tryFakeExplosion(affected, target, null, "borrowed_authority", true);
    }

    public static void borrowedAuthorityBoop(Entity entity, float strength, double x, double y, double z, double yboost) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        Vec3d motion = entity.func_213322_ci();
        double motionX = motion.field_72450_a;
        double motionY = motion.field_72448_b;
        double motionZ = motion.field_72449_c;
        motionX = 0.0;
        motionZ = 0.0;
        motionY = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.field_70122_E) {
            motionY += yboost;
        }
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    public static void borrowedAuthorityLeftClickSpace(PlayerEntity player) {
    }

    public static void borrowedAuthorityLeftClickBlock(PlayerEntity player) {
    }
}

