/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.spells.boundary;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.tile.boundary.InvisibleBarrierBlockTileEntity;

public class InvisibleBarrierBlock
extends BlockTileEntity<InvisibleBarrierBlockTileEntity> {
    AxisAlignedBB collisionCaster = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    AxisAlignedBB collisionElse = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public InvisibleBarrierBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_175972_I).func_226896_b_().func_200948_a(5.0f, 10.0f), "invisible_barrier_block");
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return new ArrayList<ItemStack>();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            if (entityIn != null && entityIn.func_70089_S()) {
                UUID entUUID = entityIn.func_110124_au();
                InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)worldIn.func_175625_s(pos);
                if (te != null) {
                    UUID casterUUID = te.getCasterUUID();
                    if (te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID)) {
                        return;
                    }
                }
            }
            double mx = entityIn.func_213322_ci().field_72450_a;
            double my = entityIn.func_213322_ci().field_72448_b;
            double mz = entityIn.func_213322_ci().field_72449_c;
            Direction side = Direction.NORTH;
            if (entityIn.func_226277_ct_() < (double)pos.func_177958_n()) {
                side = Direction.WEST;
            } else if (entityIn.func_226277_ct_() > (double)(pos.func_177958_n() + 1)) {
                side = Direction.EAST;
            } else if (entityIn.func_226278_cu_() < (double)pos.func_177956_o()) {
                side = Direction.DOWN;
            } else if (entityIn.func_226278_cu_() > (double)(pos.func_177956_o() + 1)) {
                side = Direction.UP;
            } else if (entityIn.func_226281_cx_() < (double)pos.func_177952_p()) {
                side = Direction.NORTH;
            } else if (entityIn.func_226281_cx_() > (double)(pos.func_177952_p() + 1)) {
                side = Direction.SOUTH;
            }
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof InvisibleBarrierBlockTileEntity) {
                ((InvisibleBarrierBlockTileEntity)te).setTimeSinceCollision(0, side);
            }
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Entity e;
        if (context instanceof EntitySelectionContext && (e = ((EntitySelectionContext)context).getEntity()) != null && e.func_70089_S()) {
            UUID entUUID = e.func_110124_au();
            InvisibleBarrierBlockTileEntity te = (InvisibleBarrierBlockTileEntity)reader.func_175625_s(pos);
            if (te != null) {
                UUID casterUUID = te.getCasterUUID();
                if (!(te.whitelist != null && te.whitelist.contains(entUUID) || entUUID.equals(casterUUID))) {
                    return VoxelShapes.func_197881_a((AxisAlignedBB)this.collisionElse);
                }
            }
        }
        return VoxelShapes.func_197881_a((AxisAlignedBB)this.collisionCaster);
    }

    public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    @Override
    public Class<InvisibleBarrierBlockTileEntity> getTileEntityClass() {
        return InvisibleBarrierBlockTileEntity.class;
    }

    @Override
    @Nullable
    public InvisibleBarrierBlockTileEntity createTileEntity(BlockState state, IBlockReader reader) {
        return new InvisibleBarrierBlockTileEntity();
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return VoxelShapes.func_197881_a((AxisAlignedBB)this.collisionCaster);
    }

    public boolean func_208619_r() {
        return true;
    }
}

