/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;

public class TextBox
extends TextFieldWidget {
    protected final String numericRegex;
    protected final boolean numeric;
    protected final boolean allowNegative;
    protected int minLength;
    protected Integer clampMin;
    protected Integer clampMax;

    public TextBox(Object text, FontRenderer fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBox(Object text, FontRenderer fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(fontRenderer, 0, 0, width, height, text.toString());
        this.func_146180_a(text.toString());
        this.numeric = isNumeric;
        this.allowNegative = negative;
        String regex = null;
        if (this.numeric) {
            regex = this.allowNegative ? "[^-?\\d]" : "[^\\d]";
        }
        this.numericRegex = regex;
    }

    public void setClamp(Integer min, Integer max) {
        this.clampMin = min;
        this.clampMax = max;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void func_146191_b(String par1Str) {
        super.func_146191_b(par1Str);
        if (this.numeric) {
            String fixed = this.func_146179_b().replaceAll(this.numericRegex, "");
            if (this.allowNegative) {
                String start = fixed.startsWith("-") ? "-" : "";
                fixed = start + fixed.replaceAll("-", "");
            }
            super.func_146180_a(fixed);
        }
    }

    public void setText(Object object) {
        super.func_146180_a(object.toString());
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean hasMinLength() {
        String text = this.func_146179_b();
        int textLen = text == null ? 0 : text.length();
        return this.minLength <= textLen;
    }

    public boolean charTyped(char c, int key) {
        if (this.numeric && this.isFocused()) {
            this.clamp();
        }
        super.charTyped(c, key);
        return true;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        super.keyPressed(key, value, modifier);
        return true;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.func_146176_q() && !this.hasMinLength()) {
            int red = Color.red.getRGB();
            int x1 = this.getX() - 1;
            int y1 = this.getY() - 1;
            int x2 = x1 + this.getWidth() + 1;
            int y2 = y1 + this.getHeight() + 1;
            TextBox.fill((int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)red);
            TextBox.fill((int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)red);
            TextBox.fill((int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)red);
            TextBox.fill((int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)red);
        }
    }

    public Integer clamp() {
        if (!this.numeric) {
            return null;
        }
        String text = this.func_146179_b();
        if (this.clampMin != null) {
            if (text == null || text.length() == 0 || text.equals("-")) {
                return null;
            }
            try {
                this.setText(Math.max(this.clampMin, Integer.parseInt(text)));
            }
            catch (Exception e) {
                this.setText(this.clampMin);
            }
            if (this.clampMax != null) {
                try {
                    this.setText(Math.min(this.clampMax, Integer.parseInt(text)));
                }
                catch (Exception e) {
                    this.setText(this.clampMax);
                }
            }
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getX() {
        return this.x;
    }

    public void func_212952_l(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public int getCenterX() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getMiddleY() {
        return this.getY() + this.getHeight() / 2;
    }

    public int getBottomY() {
        return this.getY() + this.getHeight();
    }

    public int getRightX() {
        return this.getX() + this.getWidth();
    }
}

