/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.forge.event.KeyEventHandler;
import journeymap.client.service.webmap.Webmap;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<TranslationTextComponent> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(ITextComponent chat) {
        TranslationTextComponent wrap = new TranslationTextComponent("jm.common.chat_announcement", new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        StringTextComponent chat = new StringTextComponent(message);
        chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        chat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(url)));
        ChatLog.queueAnnouncement((ITextComponent)chat);
    }

    public static void announceFile(String message, File file) {
        StringTextComponent chat = new StringTextComponent(message);
        try {
            chat.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getCanonicalPath()));
            chat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new StringTextComponent(file.getCanonicalPath())));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((ITextComponent)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        StringTextComponent chat = new StringTextComponent(text);
        ChatLog.queueAnnouncement((ITextComponent)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement((ITextComponent)chat);
    }

    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = Journeymap.getClient().getCoreProperties().announceMod.get();
            ChatLog.announceMod(enableAnnounceMod);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            TranslationTextComponent message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, StringUtils.func_76338_a((String)message.func_150261_e()));
                    throw throwable;
                }
                logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
                continue;
            }
            logLevel = message.func_150271_j()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, StringUtils.func_76338_a((String)message.func_150261_e()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod || forced) {
            String keyName = KeyEventHandler.INSTANCE.kbFullscreenToggle.func_197978_k().toUpperCase();
            if (Journeymap.getClient().getWebMapProperties().enabled.get().booleanValue()) {
                try {
                    Webmap webServer = Journeymap.getClient().getJmServer();
                    String port = webServer.getPort() == 80 ? "" : ":" + webServer.getPort();
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!Journeymap.getClient().getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    extends StringTextComponent {
        public ErrorChat(String text) {
            super(text);
        }
    }
}

