/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.computercraft;

import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;

public class MachinePeripheral
implements IPeripheral {
    private static final String TYPE = SilentMechanisms.getId("machine").toString();
    private final AbstractMachineBaseTileEntity machine;

    public MachinePeripheral(AbstractMachineBaseTileEntity machine) {
        this.machine = machine;
    }

    @Nonnull
    public String getType() {
        return TYPE;
    }

    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"getEnergy", "getMaxEnergy", "getRedstoneMode", "setRedstoneMode"};
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.machine.getEnergyStored()};
            }
            case 1: {
                return new Object[]{this.machine.getMaxEnergyStored()};
            }
            case 2: {
                return new Object[]{this.machine.getRedstoneMode().name()};
            }
            case 3: {
                String name = ArgumentHelper.getString((Object[])arguments, (int)0);
                RedstoneMode mode = RedstoneMode.byName(name);
                if (mode == null) {
                    throw new LuaException("Unknown redstone mode: " + name);
                }
                this.machine.setRedstoneMode(mode);
                return new Object[]{mode.name()};
            }
        }
        throw new IllegalStateException("Method index out of range!");
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other instanceof MachinePeripheral) {
            return this.machine.equals(((MachinePeripheral)other).machine);
        }
        return false;
    }
}

