/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class TileEntityTimeChanger
extends TileEntityImpl
implements ITickableTileEntity {
    private long goalTime;

    public TileEntityTimeChanger() {
        super(ModTileEntities.TIME_CHANGER);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            List<ItemFrameEntity> frames = Helper.getAttachedItemFrames(this.field_145850_b, this.field_174879_c);
            for (ItemFrameEntity frame : frames) {
                ItemStack frameStack = frame.func_82335_i();
                if (frameStack.func_190926_b() || frameStack.func_77973_b() != ModItems.CLOCK_HAND) continue;
                if (this.goalTime > 0L) {
                    long current = this.field_145850_b.func_72820_D();
                    long toAdd = Math.min(75L, this.goalTime - current);
                    if (toAdd <= 0L) {
                        this.goalTime = 0L;
                        this.sendToClients();
                        return;
                    }
                    this.field_145850_b.func_72877_b(current + toAdd);
                    BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 35, this.field_174879_c);
                    IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot).drainAura(spot, (int)toAdd * 20);
                    if (this.field_145850_b instanceof ServerWorld) {
                        PlayerList list = this.field_145850_b.func_73046_m().func_184103_al();
                        list.func_148537_a((IPacket)new SUpdateTimePacket(this.field_145850_b.func_82737_E(), this.field_145850_b.func_72820_D(), this.field_145850_b.func_82736_K().func_223586_b(GameRules.field_223607_j)), this.field_145850_b.func_201675_m().func_186058_p());
                    }
                    return;
                }
                if (this.field_145850_b.func_82737_E() % 20L != 0L) {
                    return;
                }
                List items = this.field_145850_b.func_175647_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(1.0), EntityPredicates.field_94557_a);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.func_174874_s() || (stack = item.func_92059_d()).func_190926_b() || stack.func_77973_b() != Items.field_151113_aN) continue;
                    int dayGoal = MathHelper.func_76141_d((float)((float)frame.func_82333_j() / 8.0f * 24000.0f)) + 18000;
                    long current = this.field_145850_b.func_72820_D();
                    long toMove = (24000L - current % 24000L + (long)dayGoal) % 24000L;
                    this.goalTime = current + toMove;
                    this.sendToClients();
                    if (stack.func_190916_E() <= 1) {
                        item.func_70106_y();
                    } else {
                        stack.func_190918_g(1);
                        item.func_92058_a(stack);
                    }
                    return;
                }
            }
            if (this.goalTime > 0L) {
                this.goalTime = 0L;
                this.sendToClients();
            }
        } else if (this.goalTime > 0L && this.field_145850_b.field_73012_v.nextFloat() >= 0.25f) {
            double angle = Math.toRadians((float)this.field_145850_b.func_72820_D() * 5.0f % 360.0f);
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 + Math.sin(angle) * 3.0;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5 + Math.cos(angle) * 3.0;
            int color = this.goalTime % 24000L > 12000L ? 0xE2E2E2 : 16771366;
            NaturesAuraAPI.instance().spawnMagicParticle(x, (float)this.field_174879_c.func_177956_o() + 0.1f, z, 0.0, 0.12f, 0.0, color, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 2.0f, this.field_145850_b.field_73012_v.nextInt(100) + 100, 0.0f, false, true);
            NaturesAuraAPI.instance().spawnMagicParticle(x, (float)this.field_174879_c.func_177956_o() + 0.1f, z, 0.0, 0.0, 0.0, IAuraType.forWorld((IWorld)this.field_145850_b).getColor(), 1.0f + this.field_145850_b.field_73012_v.nextFloat(), 150, 0.0f, false, true);
        }
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_74772_a("goal", this.goalTime);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.goalTime = compound.func_74763_f("goal");
        }
    }
}

