/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.IElementNew;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementEntityRender;
import mcjty.theoneprobe.apiimpl.styles.EntityStyle;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ElementEntity
implements IElementNew {
    private final String entityName;
    private final Integer playerID;
    private final CompoundNBT entityNBT;
    private final IEntityStyle style;

    public ElementEntity(String entityName, IEntityStyle style) {
        this.entityName = entityName;
        this.entityNBT = null;
        this.style = style;
        this.playerID = null;
    }

    public ElementEntity(Entity entity, IEntityStyle style) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            this.entityNBT = null;
            this.playerID = player.func_145782_y();
        } else {
            this.entityNBT = entity.serializeNBT();
            this.playerID = null;
        }
        ResourceLocation registryName = entity.func_200600_R().getRegistryName();
        if (registryName == null) {
            registryName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R());
        }
        this.entityName = registryName.toString();
        this.style = style;
    }

    public ElementEntity(PacketBuffer buf) {
        this.entityName = NetworkTools.readString(buf);
        this.style = new EntityStyle().width(buf.readInt()).height(buf.readInt()).scale(buf.readFloat());
        this.entityNBT = buf.func_150793_b();
        this.playerID = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
    }

    @Override
    public void render(int x, int y) {
        if (this.playerID != null) {
            ElementEntityRender.renderPlayer(this.entityName, this.playerID, this.style, x, y);
        } else {
            ElementEntityRender.render(this.entityName, this.entityNBT, this.style, x, y);
        }
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        NetworkTools.writeString(buf, this.entityName);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeFloat(this.style.getScale());
        buf.func_150786_a(this.entityNBT);
        if (this.playerID != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.playerID.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_ENTITY;
    }
}

