/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.items;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RLE;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiShapeCard;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardType;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Shape;
import mcjty.rftoolsbuilder.shapes.ShapeModifier;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class ShapeCardItem
extends Item
implements INBTPreservingIngredient,
ITooltipSettings {
    private final ShapeCardType type;
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.warning(stack -> this.isDisabledInConfig()), TooltipBuilder.header(), TooltipBuilder.parameter((String)"shape", this::getShapeDescription), TooltipBuilder.parameter((String)"dimension", this::getShapeDimension), TooltipBuilder.parameter((String)"offset", this::getShapeOffset), TooltipBuilder.parameter((String)"formulas", stack -> ShapeCardItem.getShape(stack).isComposition(), stack -> {
        CompoundNBT card = stack.func_77978_p();
        if (card != null) {
            ListNBT children = card.func_150295_c("children", 10);
            return Integer.toString(children.size());
        }
        return "<none>";
    }), TooltipBuilder.parameter((String)"scan", stack -> ShapeCardItem.getShape(stack).isScan(), stack -> {
        CompoundNBT card = stack.func_77978_p();
        if (card != null) {
            int scanid = card.func_74762_e("scanid");
            return Integer.toString(scanid);
        }
        return "<none>";
    })});
    public static final int MAXIMUM_COUNT = 50000000;
    public static final int MODE_NONE = 0;
    public static final int MODE_CORNER1 = 1;
    public static final int MODE_CORNER2 = 2;

    public ShapeCardItem(ShapeCardType type) {
        super(new Item.Properties().func_200917_a(1).func_200915_b(0).func_200916_a(RFToolsBuilder.setup.getTab()));
        this.type = type;
    }

    public boolean isDisabledInConfig() {
        if (!((Boolean)BuilderConfiguration.shapeCardAllowed.get()).booleanValue()) {
            return true;
        }
        if (this.type != ShapeCardType.CARD_SHAPE) {
            if (!((Boolean)BuilderConfiguration.quarryAllowed.get()).booleanValue()) {
                return true;
            }
            if (this.type.isQuarry() && this.type.isClearing() && !((Boolean)BuilderConfiguration.clearingQuarryAllowed.get()).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    public String getShapeDescription(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return shape.getDescription() + " (" + (issolid ? "Solid" : "Hollow") + ")";
    }

    public String getShapeDimension(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return BlockPosTools.toString((BlockPos)ShapeCardItem.getDimension(itemStack));
    }

    public String getShapeOffset(ItemStack itemStack) {
        Shape shape = ShapeCardItem.getShape(itemStack);
        boolean issolid = ShapeCardItem.isSolid(itemStack);
        return BlockPosTools.toString((BlockPos)ShapeCardItem.getOffset(itemStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K) return ActionResultType.SUCCESS;
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        int mode = ShapeCardItem.getMode(stack);
        if (mode == 0) {
            if (!player.func_225608_bj_()) return ActionResultType.SUCCESS;
            if (world.func_175625_s(pos) instanceof BuilderTileEntity) {
                ShapeCardItem.setCurrentBlock(stack, new GlobalCoordinate(pos, world.func_201675_m().func_186058_p()));
                Logging.message((PlayerEntity)player, (String)(TextFormatting.GREEN + "Now select the first corner"));
                ShapeCardItem.setMode(stack, 1);
                ShapeCardItem.setCorner1(stack, null);
                return ActionResultType.SUCCESS;
            } else {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You can only do this on a builder!"));
            }
            return ActionResultType.SUCCESS;
        } else if (mode == 1) {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (!currentBlock.getDimension().equals(world.func_201675_m().func_186058_p())) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "The Builder is in another dimension!"));
                return ActionResultType.SUCCESS;
            } else if (currentBlock.getCoordinate().equals((Object)pos)) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return ActionResultType.SUCCESS;
            } else {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.GREEN + "Now select the second corner"));
                ShapeCardItem.setMode(stack, 2);
                ShapeCardItem.setCorner1(stack, pos);
            }
            return ActionResultType.SUCCESS;
        } else {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (!currentBlock.getDimension().equals(world.func_201675_m().func_186058_p())) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "The Builder is in another dimension!"));
                return ActionResultType.SUCCESS;
            } else if (currentBlock.getCoordinate().equals((Object)pos)) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return ActionResultType.SUCCESS;
            } else {
                CompoundNBT tag = stack.func_196082_o();
                BlockPos c1 = ShapeCardItem.getCorner1(stack);
                if (c1 == null) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Cleared area selection mode!"));
                    ShapeCardItem.setMode(stack, 0);
                    return ActionResultType.SUCCESS;
                } else {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.GREEN + "New settings copied to the shape card!"));
                    BlockPos center = new BlockPos((int)Math.ceil((float)(c1.func_177958_n() + pos.func_177958_n()) / 2.0f), (int)Math.ceil((float)(c1.func_177956_o() + pos.func_177956_o()) / 2.0f), (int)Math.ceil((float)(c1.func_177952_p() + pos.func_177952_p()) / 2.0f));
                    ShapeCardItem.setDimension(stack, Math.abs(c1.func_177958_n() - pos.func_177958_n()) + 1, Math.abs(c1.func_177956_o() - pos.func_177956_o()) + 1, Math.abs(c1.func_177952_p() - pos.func_177952_p()) + 1);
                    ShapeCardItem.setOffset(stack, center.func_177958_n() - currentBlock.getCoordinate().func_177958_n(), center.func_177956_o() - currentBlock.getCoordinate().func_177956_o(), center.func_177952_p() - currentBlock.getCoordinate().func_177952_p());
                    ShapeCardItem.setMode(stack, 0);
                    ShapeCardItem.setCorner1(stack, null);
                    ShapeCardItem.setShape(stack, Shape.SHAPE_BOX, true);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public Collection<String> getTagsToPreserve() {
        return Arrays.asList("mod_op", "mod_flipy", "mod_rot", "ghost_block", "children", "dimX", "dimY", "dimZ", "offsetX", "offsetY", "offsetZ", "mode");
    }

    public static void setData(CompoundNBT tagCompound, int scanID) {
        tagCompound.func_74768_a("scanid", scanID);
    }

    public static void setModifier(CompoundNBT tag, ShapeModifier modifier) {
        tag.func_74778_a("mod_op", modifier.getOperation().getCode());
        tag.func_74757_a("mod_flipy", modifier.isFlipY());
        tag.func_74778_a("mod_rot", modifier.getRotation().getCode());
    }

    public static void setGhostMaterial(CompoundNBT tag, ItemStack materialGhost) {
        if (materialGhost.func_190926_b()) {
            tag.func_82580_o("ghost_block");
        } else {
            Block block = Block.func_149634_a((Item)materialGhost.func_77973_b());
            if (block == null) {
                tag.func_82580_o("ghost_block");
            } else {
                tag.func_74778_a("ghost_block", block.getRegistryName().toString());
            }
        }
    }

    public static void setChildren(ItemStack itemStack, ListNBT list) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        tagCompound.func_218657_a("children", (INBT)list);
    }

    public static void setDimension(ItemStack itemStack, int x, int y, int z) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        if (tagCompound.func_74762_e("dimX") == x && tagCompound.func_74762_e("dimY") == y && tagCompound.func_74762_e("dimZ") == z) {
            return;
        }
        tagCompound.func_74768_a("dimX", x);
        tagCompound.func_74768_a("dimY", y);
        tagCompound.func_74768_a("dimZ", z);
    }

    public static void setOffset(ItemStack itemStack, int x, int y, int z) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        if (tagCompound.func_74762_e("offsetX") == x && tagCompound.func_74762_e("offsetY") == y && tagCompound.func_74762_e("offsetZ") == z) {
            return;
        }
        tagCompound.func_74768_a("offsetX", x);
        tagCompound.func_74768_a("offsetY", y);
        tagCompound.func_74768_a("offsetZ", z);
    }

    public static void setCorner1(ItemStack itemStack, BlockPos corner) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        if (corner == null) {
            tagCompound.func_82580_o("corner1x");
            tagCompound.func_82580_o("corner1y");
            tagCompound.func_82580_o("corner1z");
        } else {
            tagCompound.func_74768_a("corner1x", corner.func_177958_n());
            tagCompound.func_74768_a("corner1y", corner.func_177956_o());
            tagCompound.func_74768_a("corner1z", corner.func_177952_p());
        }
    }

    public static BlockPos getCorner1(ItemStack stack1) {
        CompoundNBT tagCompound = stack1.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("corner1x")) {
            return null;
        }
        return new BlockPos(tagCompound.func_74762_e("corner1x"), tagCompound.func_74762_e("corner1y"), tagCompound.func_74762_e("corner1z"));
    }

    public static int getMode(ItemStack itemStack) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74762_e("mode");
        }
        return 0;
    }

    public static void setMode(ItemStack itemStack, int mode) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        if (tagCompound.func_74762_e("mode") == mode) {
            return;
        }
        tagCompound.func_74768_a("mode", mode);
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        CompoundNBT tagCompound = itemStack.func_196082_o();
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().func_177958_n());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().func_177956_o());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().func_177952_p());
            tagCompound.func_74778_a("selectedDim", c.getDimension().getRegistryName().toString());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            String dim = tagCompound.func_74779_i("selectedDim");
            return new GlobalCoordinate(new BlockPos(x, y, z), DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(dim)));
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        this.tooltipBuilder.makeTooltip(new ResourceLocation("rftoolsbuilder", "shape_card"), itemStack, list, flag);
    }

    public static boolean isNormalShapeCard(ItemStack stack) {
        ShapeCardType type = ShapeCardItem.getType(stack);
        return type == ShapeCardType.CARD_SHAPE || type == ShapeCardType.CARD_PUMP_LIQUID;
    }

    public static ShapeCardType getType(ItemStack stack) {
        if (stack.func_77973_b() instanceof ShapeCardItem) {
            return ((ShapeCardItem)stack.func_77973_b()).type;
        }
        return ShapeCardType.CARD_UNKNOWN;
    }

    private static void addBlocks(Set<Block> blocks, Block block, Tag<Block> tag, boolean tagMatching) {
        blocks.add(block);
        if (tagMatching && tag != null) {
            for (Block b : tag.func_199885_a()) {
                blocks.add(b);
            }
        }
    }

    public static Set<Block> getVoidedBlocks(ItemStack stack) {
        HashSet<Block> blocks = new HashSet<Block>();
        boolean tagMatching = ShapeCardItem.isTagMatching(stack);
        if (ShapeCardItem.isVoiding(stack, "stone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150348_b, (Tag<Block>)Tags.Blocks.STONE, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "cobble")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150347_e, (Tag<Block>)Tags.Blocks.COBBLESTONE, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "dirt")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150346_d, (Tag<Block>)Tags.Blocks.DIRT, tagMatching);
            ShapeCardItem.addBlocks(blocks, Blocks.field_150349_c, null, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "sand")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150354_m, (Tag<Block>)Tags.Blocks.SAND, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "gravel")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150351_n, (Tag<Block>)Tags.Blocks.GRAVEL, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "netherrack")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150424_aL, (Tag<Block>)Tags.Blocks.NETHERRACK, tagMatching);
        }
        if (ShapeCardItem.isVoiding(stack, "endstone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150377_bs, (Tag<Block>)Tags.Blocks.END_STONES, tagMatching);
        }
        return blocks;
    }

    public static boolean isTagMatching(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("tagMatching");
    }

    public static boolean isVoiding(ItemStack stack, String material) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("void" + material);
    }

    public static Shape getShape(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        return ShapeCardItem.getShape(tagCompound);
    }

    public static Shape getShape(CompoundNBT tagCompound) {
        if (tagCompound == null) {
            return Shape.SHAPE_BOX;
        }
        if (!tagCompound.func_74764_b("shape")) {
            return Shape.SHAPE_BOX;
        }
        String sn = tagCompound.func_74779_i("shape");
        Shape shape = Shape.getShape(sn);
        if (shape == null) {
            return Shape.SHAPE_BOX;
        }
        return shape;
    }

    public static boolean isSolid(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        CompoundNBT tagCompound = stack.func_77978_p();
        return ShapeCardItem.isSolid(tagCompound);
    }

    public static boolean isSolid(CompoundNBT tagCompound) {
        if (tagCompound == null) {
            return true;
        }
        if (tagCompound.func_74764_b("shape")) {
            return tagCompound.func_74767_n("solid");
        }
        return false;
    }

    public static IFormula createCorrectFormula(CompoundNBT tagCompound) {
        Shape shape = ShapeCardItem.getShape(tagCompound);
        boolean solid = ShapeCardItem.isSolid(tagCompound);
        IFormula formula = shape.getFormulaFactory().get();
        return formula.correctFormula(solid);
    }

    public static int getScanId(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        CompoundNBT tagCompound = stack.func_196082_o();
        Shape shape = ShapeCardItem.getShape(tagCompound);
        if (shape != Shape.SHAPE_SCAN) {
            return 0;
        }
        return tagCompound.func_74762_e("scanid");
    }

    public static int getScanIdRecursive(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        return ShapeCardItem.getScanIdRecursive(stack.func_196082_o());
    }

    private static int getScanIdRecursive(CompoundNBT tagCompound) {
        Shape shape = ShapeCardItem.getShape(tagCompound);
        if (tagCompound.func_74764_b("scanid") && shape == Shape.SHAPE_SCAN) {
            return tagCompound.func_74762_e("scanid");
        }
        if (shape == Shape.SHAPE_COMPOSITION) {
            ListNBT children = tagCompound.func_150295_c("children", 10);
            for (int i = 0; i < children.size(); ++i) {
                CompoundNBT childTag = children.func_150305_b(i);
                int id = ShapeCardItem.getScanIdRecursive(childTag);
                if (id == 0) continue;
                return id;
            }
        }
        return 0;
    }

    public static int getFormulaCheckClient(ItemStack stack) {
        Check32 crc = new Check32();
        ShapeCardItem.getFormulaCheckClient(stack, crc);
        return crc.get();
    }

    public static void getFormulaCheckClient(ItemStack stack, Check32 crc) {
        Shape shape = ShapeCardItem.getShape(stack);
        IFormula formula = shape.getFormulaFactory().get();
        formula.getCheckSumClient(stack.func_77978_p(), crc);
    }

    public static void getLocalChecksum(CompoundNBT tagCompound, Check32 crc) {
        if (tagCompound == null) {
            return;
        }
        crc.add(ShapeCardItem.getShape(tagCompound).ordinal());
        BlockPos dim = ShapeCardItem.getDimension(tagCompound);
        crc.add(dim.func_177958_n());
        crc.add(dim.func_177956_o());
        crc.add(dim.func_177952_p());
        crc.add(ShapeCardItem.isSolid(tagCompound) ? 1 : 0);
    }

    public static void setShape(ItemStack stack, Shape shape, boolean solid) {
        CompoundNBT tagCompound = stack.func_196082_o();
        if (ShapeCardItem.isSolid(tagCompound) == solid && ShapeCardItem.getShape(tagCompound).equals((Object)shape)) {
            return;
        }
        tagCompound.func_74778_a("shape", shape.getDescription());
        tagCompound.func_74757_a("solid", solid);
    }

    public static BlockPos getDimension(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        return ShapeCardItem.getDimension(tagCompound);
    }

    public static BlockPos getDimension(CompoundNBT tagCompound) {
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        if (!tagCompound.func_74764_b("dimX")) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new BlockPos(dimX, ShapeCardItem.clampDimension(dimY, 256), dimZ);
    }

    public static BlockPos getClampedDimension(ItemStack stack, int maximum) {
        CompoundNBT tagCompound = stack.func_77978_p();
        return ShapeCardItem.getClampedDimension(tagCompound, maximum);
    }

    public static BlockPos getClampedDimension(CompoundNBT tagCompound, int maximum) {
        if (tagCompound == null) {
            return new BlockPos(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new BlockPos(ShapeCardItem.clampDimension(dimX, maximum), ShapeCardItem.clampDimension(dimY, maximum), ShapeCardItem.clampDimension(dimZ, maximum));
    }

    private static int clampDimension(int o, int maximum) {
        if (o > maximum) {
            o = maximum;
        } else if (o < 0) {
            o = 0;
        }
        return o;
    }

    public static BlockPos getOffset(ItemStack stack) {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new BlockPos(offsetX, offsetY, offsetZ);
    }

    public static BlockPos getClampedOffset(ItemStack stack, int maximum) {
        CompoundNBT tagCompound = stack.func_77978_p();
        return ShapeCardItem.getClampedOffset(tagCompound, maximum);
    }

    public static BlockPos getClampedOffset(CompoundNBT tagCompound, int maximum) {
        if (tagCompound == null) {
            return new BlockPos(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new BlockPos(ShapeCardItem.clampOffset(offsetX, maximum), ShapeCardItem.clampOffset(offsetY, maximum), ShapeCardItem.clampOffset(offsetZ, maximum));
    }

    private static int clampOffset(int o, int maximum) {
        if (o < -maximum) {
            o = -maximum;
        } else if (o > maximum) {
            o = maximum;
        }
        return o;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            GuiShapeCard.open();
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static BlockPos getMinCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        return new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
    }

    public static BlockPos getMaxCorner(BlockPos thisCoord, BlockPos dimension, BlockPos offset) {
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos minCorner = ShapeCardItem.getMinCorner(thisCoord, dimension, offset);
        return new BlockPos(minCorner.func_177958_n() + dx, minCorner.func_177956_o() + dy, minCorner.func_177952_p() + dz);
    }

    public static boolean xInChunk(int x, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77276_a == x >> 4;
    }

    public static boolean zInChunk(int z, ChunkPos chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77275_b == z >> 4;
    }

    private static void placeBlockIfPossible(World worldObj, Map<BlockPos, BlockState> blocks, int maxSize, int x, int y, int z, BlockState state, boolean forquarry) {
        BlockPos c = new BlockPos(x, y, z);
        if (worldObj == null) {
            blocks.put(c, state);
            return;
        }
        if (forquarry) {
            if (worldObj.func_175623_d(c)) {
                return;
            }
            blocks.put(c, state);
        } else if (BuilderTileEntity.isEmptyOrReplacable(worldObj, c) && blocks.size() < maxSize) {
            blocks.put(c, state);
        }
    }

    public static int getRenderPositions(ItemStack stack, boolean solid, RLE positions, StatePalette statePalette, IFormula formula, int oy) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
        int dx = clamped.func_177958_n();
        int dy = clamped.func_177956_o();
        int dz = clamped.func_177952_p();
        int cnt = 0;
        int y = oy - dy / 2;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                int v = 255;
                if (formula.isInside(x, y, z)) {
                    ++cnt;
                    BlockState lastState = formula.getLastState();
                    if (solid) {
                        if (ox == 0 || ox == dx - 1 || oy == 0 || oy == dy - 1 || oz == 0 || oz == dz - 1) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        } else if (formula.isVisible(x, y, z)) {
                            v = statePalette.alloc(lastState, -1) + 1;
                        }
                    } else {
                        v = statePalette.alloc(lastState, -1) + 1;
                    }
                }
                positions.add(v);
            }
        }
        return cnt;
    }

    public static int getDataPositions(World world, ItemStack stack, Shape shape, boolean solid, RLE positions, StatePalette statePalette) {
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
        IFormula formula = shape.getFormulaFactory().get();
        int dx = clamped.func_177958_n();
        int dy = clamped.func_177956_o();
        int dz = clamped.func_177952_p();
        formula = formula.correctFormula(solid);
        formula.setup(world, new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), stack != null ? stack.func_77978_p() : null);
        int cnt = 0;
        for (int ox = 0; ox < dx; ++ox) {
            int x = ox - dx / 2;
            for (int oz = 0; oz < dz; ++oz) {
                int z = oz - dz / 2;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = oy - dy / 2;
                    int v = 255;
                    if (formula.isInside(x, y, z)) {
                        ++cnt;
                        BlockState lastState = formula.getLastState();
                        if (lastState == null) {
                            lastState = Blocks.field_150348_b.func_176223_P();
                        }
                        v = statePalette.alloc(lastState, 0) + 1;
                    }
                    positions.add(v);
                }
            }
        }
        return cnt;
    }

    public static void composeFormula(ItemStack shapeCard, IFormula formula, World worldObj, BlockPos thisCoord, BlockPos dimension, BlockPos offset, Map<BlockPos, BlockState> blocks, int maxSize, boolean solid, boolean forquarry, ChunkPos chunk) {
        int xCoord = thisCoord.func_177958_n();
        int yCoord = thisCoord.func_177956_o();
        int zCoord = thisCoord.func_177952_p();
        int dx = dimension.func_177958_n();
        int dy = dimension.func_177956_o();
        int dz = dimension.func_177952_p();
        BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.func_177958_n(), yCoord - dy / 2 + offset.func_177956_o(), zCoord - dz / 2 + offset.func_177952_p());
        formula = formula.correctFormula(solid);
        formula.setup(worldObj, thisCoord, dimension, offset, shapeCard != null ? shapeCard.func_77978_p() : null);
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.func_177958_n() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.func_177952_p() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = tl.func_177956_o() + oy;
                    if (!formula.isInside(x, y, z)) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, formula.getLastState(), forquarry);
                }
            }
        }
    }

    private static boolean validFile(PlayerEntity player, String filename) {
        if (filename.contains("\\") || filename.contains("/") || filename.contains(":")) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Invalid filename '" + filename + "'! Cannot be a path!"), false);
            return false;
        }
        return true;
    }

    public static void save(PlayerEntity player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        boolean solid = ShapeCardItem.isSolid(card);
        BlockPos offset = ShapeCardItem.getOffset(card);
        BlockPos dimension = ShapeCardItem.getDimension(card);
        RLE positions = new RLE();
        StatePalette statePalette = new StatePalette();
        int cnt = ShapeCardItem.getDataPositions(player.func_130014_f_(), card, shape, solid, positions, statePalette);
        byte[] data = positions.getData();
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(file));){
            writer.println("SHAPE");
            writer.println("DIM:" + dimension.func_177958_n() + "," + dimension.func_177956_o() + "," + dimension.func_177952_p());
            writer.println("OFF:" + offset.func_177958_n() + "," + offset.func_177956_o() + "," + offset.func_177952_p());
            for (BlockState state : statePalette.getPalette()) {
                String r = state.func_177230_c().getRegistryName().toString();
                writer.println(r);
            }
            writer.println("DATA");
            byte[] encoded = Base64.getEncoder().encode(data);
            writer.write(new String(encoded));
        }
        catch (FileNotFoundException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Cannot write to file '" + filename + "'!"), false);
            return;
        }
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Saved shape to file '" + file.getPath() + "'"), false);
    }

    public static void load(PlayerEntity player, ItemStack card, String filename) {
        if (!ShapeCardItem.validFile(player, filename)) {
            return;
        }
        Shape shape = ShapeCardItem.getShape(card);
        if (shape != Shape.SHAPE_SCAN) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "To load a file into this card you need a linked 'scan' type card!"), false);
            return;
        }
        CompoundNBT compound = card.func_196082_o();
        int scanId = compound.func_74762_e("scanid");
        if (scanId == 0) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "This card is not linked to scan data!"), false);
            return;
        }
        File dataDir = new File("rftoolsscans");
        dataDir.mkdirs();
        File file = new File(dataDir, filename);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String s = reader.readLine();
            if (!"SHAPE".equals(s)) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "This does not appear to be a valid shapecard file!"), false);
                return;
            }
            s = reader.readLine();
            if (!s.startsWith("DIM:")) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "This does not appear to be a valid shapecard file!"), false);
                return;
            }
            BlockPos dim = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            if (!s.startsWith("OFF:")) {
                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "This does not appear to be a valid shapecard file!"), false);
                return;
            }
            BlockPos off = ShapeCardItem.parse(s.substring(4));
            s = reader.readLine();
            StatePalette statePalette = new StatePalette();
            while (!"DATA".equals(s)) {
                String[] split = StringUtils.split((String)s, (char)'@');
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
                int meta = Integer.parseInt(split[1]);
                if (block == null) {
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Could not find block '" + split[0] + "'!"), false);
                    block = Blocks.field_150348_b;
                    meta = 0;
                }
                statePalette.add(block.func_176223_P());
                s = reader.readLine();
            }
            s = reader.readLine();
            byte[] decoded = Base64.getDecoder().decode(s.getBytes());
            ShapeCardItem.setDataFromFile(scanId, card, dim, off, decoded, statePalette);
        }
        catch (FileNotFoundException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Cannot read from file '" + filename + "'!"), false);
            return;
        }
        catch (IOException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Cannot read from file '" + filename + "'!"), false);
            return;
        }
        catch (NullPointerException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "File '" + filename + "' is too short!"), false);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "File '" + filename + "' contains invalid entries!"), false);
            return;
        }
        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Loaded shape from file '" + file.getPath() + "'"), false);
    }

    private static void setDataFromFile(int scanId, ItemStack card, BlockPos dimension, BlockPos offset, byte[] data, StatePalette palette) {
    }

    private static BlockPos parse(String s) {
        String[] split = StringUtils.split((String)s, (char)',');
        return new BlockPos(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }
}

