/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;

@OnlyIn(value=Dist.CLIENT)
public class AchievementCollectButton
extends AdvancedButton {
    private final AdvancementRewards advancementRewards;
    private final IInfoBook infoBook;

    public AchievementCollectButton(AdvancementRewards advancementRewards, IInfoBook infoBook) {
        this.advancementRewards = advancementRewards;
        this.infoBook = infoBook;
    }

    protected IInfoBook getInfoBook() {
        return this.infoBook;
    }

    @Override
    public void renderTooltip(int mx, int my) {
        super.renderTooltip(mx, my);
        GlStateManager.func_227626_N_();
        if (mx >= this.x && my >= this.y && mx <= this.x + this.width && my <= this.y + this.height) {
            ArrayList lines = Lists.newArrayList();
            if (this.advancementRewards.isObtained((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
                lines.add(TextFormatting.ITALIC + L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collected", new Object[0]));
            } else {
                lines.add(TextFormatting.BOLD + L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collect", new Object[0]));
                boolean canObtain = true;
                for (IReward reward : this.advancementRewards.getRewards()) {
                    if (reward.canObtain((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) continue;
                    canObtain = false;
                }
                if (!canObtain) {
                    lines.add(TextFormatting.RED + L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collectFailure", new Object[0]));
                }
            }
            this.gui.renderTooltip(lines, mx, my);
        }
        GlStateManager.func_227627_O_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void onPress() {
        super.onPress();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        boolean canObtain = true;
        for (ResourceLocation advancement : this.advancementRewards.getAdvancements()) {
            if (AdvancementHelpers.hasAdvancementUnlocked((PlayerEntity)Minecraft.func_71410_x().field_71439_g, advancement)) continue;
            canObtain = false;
        }
        for (IReward reward : this.advancementRewards.getRewards()) {
            if (reward.canObtain((PlayerEntity)player)) continue;
            canObtain = false;
        }
        if (canObtain) {
            this.advancementRewards.obtain((PlayerEntity)player);
        }
    }

    @Override
    public void update(int x, int y, String displayName, InfoSection target, ScreenInfoBook gui) {
        super.update(x, y, displayName, target, gui);
        this.width = 80;
    }
}

