/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentHelpers {
    public static int doesEnchantApply(ItemStack itemStack, Enchantment enchantment) {
        ListNBT enchantmentList = itemStack.func_77986_q();
        for (int i = 0; i < enchantmentList.size(); ++i) {
            if (!enchantment.getRegistryName().equals((Object)new ResourceLocation(enchantmentList.func_150305_b(i).func_74779_i("id")))) continue;
            return i;
        }
        return -1;
    }

    public static int getEnchantmentLevel(ItemStack itemStack, int enchantmentListID) {
        ListNBT enchlist = itemStack.func_77986_q();
        return enchlist.func_150305_b(enchantmentListID).func_74765_d("lvl");
    }

    public static Enchantment getEnchantment(ItemStack itemStack, int enchantmentListID) {
        ListNBT enchlist = itemStack.func_77986_q();
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchlist.func_150305_b(enchantmentListID).func_74779_i("id")));
    }

    public static void setEnchantmentLevel(ItemStack itemStack, int enchantmentListID, int level) {
        ListNBT enchlist = itemStack.func_77986_q();
        if (level <= 0) {
            enchlist.remove(enchantmentListID);
            if (enchlist.size() == 0) {
                itemStack.func_77978_p().func_82580_o("Enchantments");
            }
        } else {
            CompoundNBT compound = enchlist.func_150305_b(enchantmentListID);
            compound.func_74777_a("lvl", (short)level);
        }
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_218657_a("Enchantments", (INBT)enchlist);
    }

    public static void setEnchantmentLevel(ItemStack itemStack, Enchantment enchantment, int level) {
        int existingIndex = EnchantmentHelpers.doesEnchantApply(itemStack, enchantment);
        if (existingIndex >= 0) {
            EnchantmentHelpers.setEnchantmentLevel(itemStack, existingIndex, level);
        } else {
            itemStack.func_77966_a(enchantment, level);
        }
    }
}

