/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import java.util.List;
import org.openzen.zencode.shared.Taggable;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.Modifiers;
import org.openzen.zenscript.codemodel.expression.switchvalue.SwitchValue;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.member.FieldMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.compiler.JavaExpressionVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaSwitchKeyVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javashared.JavaCompiledModule;
import org.openzen.zenscript.javashared.JavaField;
import org.openzen.zenscript.javashared.JavaParameterInfo;
import org.openzen.zenscript.javashared.JavaTypeParameterInfo;

public class CompilerUtils {
    private CompilerUtils() {
    }

    public static boolean isPrimitive(TypeID id) {
        return id instanceof BasicTypeID || id.isOptional() && id.withoutOptional() == BasicTypeID.USIZE;
    }

    public static boolean isLarge(StoredType type) {
        return type.type == BasicTypeID.DOUBLE || type.type == BasicTypeID.LONG;
    }

    public static int calcAccess(int modifiers) {
        int out = 0;
        if (Modifiers.isStatic(modifiers)) {
            out |= 8;
        }
        if (Modifiers.isFinal(modifiers)) {
            out |= 0x10;
        }
        if (Modifiers.isPublic(modifiers)) {
            out |= 1;
        }
        if (Modifiers.isPrivate(modifiers)) {
            out |= 2;
        }
        if (Modifiers.isProtected(modifiers)) {
            out |= 4;
        }
        if (Modifiers.isAbstract(modifiers)) {
            out |= 0x400;
        }
        return out;
    }

    public static void tagMethodParameters(JavaBytecodeContext context, JavaCompiledModule module, FunctionHeader header, boolean isStatic, List<TypeParameter> baseTypeTypeParameters) {
        Taggable parameter;
        int i;
        int index = isStatic ? 0 : 1;
        for (TypeParameter baseTypeTypeParameter : baseTypeTypeParameters) {
            module.setTypeParameterInfo(baseTypeTypeParameter, new JavaTypeParameterInfo(index));
            ++index;
        }
        for (i = 0; i < header.typeParameters.length; ++i) {
            parameter = header.typeParameters[i];
            module.setTypeParameterInfo((TypeParameter)parameter, new JavaTypeParameterInfo(index));
            ++index;
        }
        for (i = 0; i < header.parameters.length; ++i) {
            parameter = header.parameters[i];
            String parameterType = context.getDescriptor(((FunctionParameter)parameter).type);
            module.setParameterInfo((FunctionParameter)parameter, new JavaParameterInfo(index, parameterType));
            ++index;
        }
    }

    public static void tagConstructorParameters(JavaBytecodeContext context, JavaCompiledModule module, HighLevelDefinition definition, FunctionHeader header, boolean isEnum) {
        int i;
        int index = 1;
        for (TypeParameter typeParameter : definition.typeParameters) {
            JavaField field = new JavaField(context.getJavaClass(definition), "typeOf" + typeParameter.name, "Ljava/lang/Class;", "Ljava/lang/Class<T" + typeParameter.name + ";>;");
            JavaTypeParameterInfo info = new JavaTypeParameterInfo(index, field);
            module.setTypeParameterInfo(typeParameter, info);
            ++index;
        }
        for (i = 0; i < header.typeParameters.length; ++i) {
            TypeParameter typeParameter = header.typeParameters[i];
            JavaField field = new JavaField(context.getJavaClass(definition), "typeOf" + typeParameter.name, "Ljava/lang/Class;", "Ljava/lang/Class<T" + typeParameter.name + ";>;");
            JavaTypeParameterInfo info = new JavaTypeParameterInfo(index, field);
            module.setTypeParameterInfo(typeParameter, info);
            ++index;
        }
        for (i = 0; i < header.parameters.length; ++i) {
            FunctionParameter parameter = header.parameters[i];
            String parameterType = context.getDescriptor(parameter.type);
            module.setParameterInfo(parameter, new JavaParameterInfo(index, parameterType));
            ++index;
        }
    }

    public static void writeDefaultFieldInitializers(JavaBytecodeContext context, JavaWriter constructorWriter, HighLevelDefinition definition, boolean staticFields) {
        JavaExpressionVisitor expressionVisitor = new JavaExpressionVisitor(context, context.getJavaModule(definition.module), constructorWriter);
        for (IDefinitionMember definitionMember : definition.members) {
            FieldMember field;
            if (!(definitionMember instanceof FieldMember) || (field = (FieldMember)definitionMember).isStatic() != staticFields || field.initializer == null) continue;
            if (!staticFields) {
                constructorWriter.loadObject(0);
            }
            field.initializer.accept(expressionVisitor);
            if (staticFields) {
                constructorWriter.putStaticField(definition.name, field.name, context.getDescriptor(field.getType()));
                continue;
            }
            constructorWriter.putField(definition.name, field.name, context.getDescriptor(field.getType()));
        }
    }

    public static int getKeyForSwitch(SwitchValue expression) {
        return expression.accept(JavaSwitchKeyVisitor.INSTANCE);
    }
}

