/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.context;

import java.util.List;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.context.CompilingType;
import org.openzen.zenscript.codemodel.context.TypeResolutionContext;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.storage.BorrowStorageTag;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class LocalTypeResolutionContext
implements TypeResolutionContext {
    private final TypeResolutionContext outer;
    private final CompilingType type;
    private final TypeParameter[] parameters;

    public LocalTypeResolutionContext(TypeResolutionContext outer, CompilingType type, TypeParameter[] parameters) {
        this.outer = outer;
        this.type = type;
        this.parameters = parameters;
    }

    @Override
    public ZSPackage getRootPackage() {
        return this.outer.getRootPackage();
    }

    @Override
    public GlobalTypeRegistry getTypeRegistry() {
        return this.outer.getTypeRegistry();
    }

    @Override
    public AnnotationDefinition getAnnotation(String name) {
        return this.outer.getAnnotation(name);
    }

    @Override
    public TypeID getType(CodePosition position, List<GenericName> name) {
        CompilingType compiling;
        if (this.type != null && (compiling = this.type.getInner(name.get((int)0).name)) != null) {
            DefinitionTypeID outer = this.getTypeRegistry().getForMyDefinition(this.type.load());
            return compiling.getInnerType(this.getTypeRegistry(), name, 0, outer);
        }
        if (name.size() == 1 && name.get(0).hasNoArguments()) {
            for (TypeParameter parameter : this.parameters) {
                if (!parameter.name.equals(name.get((int)0).name)) continue;
                return this.getTypeRegistry().getGeneric(parameter);
            }
        }
        return this.outer.getType(position, name);
    }

    @Override
    public StorageTag getStorageTag(CodePosition position, String name, String[] parameters) {
        return this.outer.getStorageTag(position, name, parameters);
    }

    @Override
    public StoredType getThisType() {
        if (this.type == null) {
            return null;
        }
        DefinitionTypeID self = this.getTypeRegistry().getForMyDefinition(this.type.load());
        return self.stored(BorrowStorageTag.THIS);
    }
}

