/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketDumper;
import com.blamejared.crafttweaker.api.annotations.BracketResolver;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.blocks.MCBlockState;
import com.blamejared.crafttweaker.impl.entity.MCEntityClassification;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.blamejared.crafttweaker.impl.managers.RecipeManagerWrapper;
import com.blamejared.crafttweaker.impl.potion.MCEffect;
import com.blamejared.crafttweaker.impl.potion.MCPotion;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.util.MCDirectionAxis;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketHandlers")
public class BracketHandlers {
    @BracketResolver(value="item")
    public static IItemStack getItem(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Item BEP <item:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.ITEMS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!");
        }
        ItemStack value = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(key));
        return new MCItemStack(value);
    }

    @BracketResolver(value="potion")
    public static MCPotion getPotion(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Potion BEP <potion:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Syntax is <potion:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.POTIONS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Potion does not appear to exist!");
        }
        Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(key);
        return new MCPotion(potion);
    }

    @BracketResolver(value="effect")
    public static MCEffect getEffect(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Effect BEP <effect:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get effect with name: <effect:" + tokens + ">! Syntax is <effect:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!ForgeRegistries.POTIONS.containsKey(key)) {
            throw new IllegalArgumentException("Could not get effect with name: <potion:" + tokens + ">! Effect does not appear to exist!");
        }
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(key);
        return new MCEffect(effect);
    }

    @BracketDumper(value="item")
    public static Collection<String> getItemBracketDump() {
        HashSet<String> result = new HashSet<String>();
        for (ResourceLocation key : ForgeRegistries.ITEMS.getKeys()) {
            result.add(String.format(Locale.ENGLISH, "<item:%s>", key));
        }
        return result;
    }

    @BracketResolver(value="tag")
    public static MCTag getTag(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Tag BEP <tag:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get Tag with name: <tag:" + tokens + ">! Syntax is <tag:modid:tagname>");
        }
        return new MCTag(new ResourceLocation(tokens));
    }

    @ZenCodeType.Method
    public static IRecipeManager getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("RecipeType BEP <recipetype:%s> does not seem to be lower-cased!", tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        Optional value = Registry.field_218367_H.func_218349_b(new ResourceLocation(tokens));
        if (value.isPresent()) {
            return new RecipeManagerWrapper((IRecipeType)value.get());
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not appear to exist!");
    }

    @BracketDumper(value="recipetype")
    public static Collection<String> getRecipeTypeDump() {
        HashSet<String> result = new HashSet<String>();
        Registry.field_218367_H.func_148742_b().stream().filter(rl -> !rl.toString().equals("crafttweaker:scripts")).forEach(rl -> result.add(String.format(Locale.ENGLISH, "<recipetype:%s>", rl)));
        return result;
    }

    @BracketResolver(value="blockstate")
    public static MCBlockState getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("BlockState BEP <blockstate:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String properties;
            String blockName = split[0] + ":" + split[1];
            String string = properties = split.length > 2 ? split[2] : "";
            if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName))) {
                CraftTweakerAPI.logThrowing("Error creating BlockState!", new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not appear to exist!"), new Object[0]);
            } else {
                return BracketHandlers.getBlockState(blockName, properties);
            }
        }
        CraftTweakerAPI.logThrowing("Error creating BlockState!", new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"), new Object[0]);
        return null;
    }

    public static MCBlockState getBlockState(String name, String properties) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block == null) {
            return null;
        }
        MCBlockState blockState = new MCBlockState(block.func_176223_P());
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CraftTweakerAPI.logWarning("Invalid blockstate property format '" + propertyPair + "'. Using default property value.", new Object[0]);
                    continue;
                }
                blockState = blockState.withProperty(splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @BracketResolver(value="entitytype")
    public static MCEntityType getEntityType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            CraftTweakerAPI.logError("Could not get entitytype <entityType:%s>", tokens);
            return null;
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        if (!ForgeRegistries.ENTITIES.containsKey(resourceLocation)) {
            CraftTweakerAPI.logError("Could not get entitytype <entityType:%s>", tokens);
            return null;
        }
        return new MCEntityType((EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation));
    }

    @BracketDumper(value="entitytype")
    public static Collection<String> getEntityTypeDump() {
        return ForgeRegistries.ENTITIES.getKeys().stream().map(key -> "<entitytype:" + key + ">").collect(Collectors.toList());
    }

    @BracketResolver(value="entityclassification")
    public static MCEntityClassification getEntityClassification(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 1) {
            CraftTweakerAPI.logError("Could not get EntityClassification <entityclassification:%s>", tokens);
            return null;
        }
        if (Arrays.stream(EntityClassification.values()).anyMatch(entityClassification -> entityClassification.name().equalsIgnoreCase(tokens))) {
            CraftTweakerAPI.logError("Could not get EntityClassification <entityclassification:%s>", tokens);
            return null;
        }
        return new MCEntityClassification(EntityClassification.valueOf((String)tokens.toUpperCase()));
    }

    @BracketDumper(value="entityclassification")
    public static Collection<String> getEntityClassificationDump() {
        return Arrays.stream(EntityClassification.values()).map(key -> "<entityclassification:" + key.name().toLowerCase() + ">").collect(Collectors.toList());
    }

    @BracketResolver(value="directionaxis")
    public static MCDirectionAxis getDirectionAxis(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("DirectionAxis BEP <directionaxis:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 1) {
            throw new IllegalArgumentException("Could not get axis with name: <directionaxis:" + tokens + ">! Syntax is <directionaxis:axis>");
        }
        if (Direction.Axis.func_176717_a((String)split[0]) != null) {
            throw new IllegalArgumentException("Could not get axis with name: <directionaxis:" + tokens + ">! Axis does not appear to exist!");
        }
        return MCDirectionAxis.getAxis(Direction.Axis.func_176717_a((String)split[0]));
    }

    @BracketDumper(value="directionaxis")
    public static Collection<String> getDirectionAxisDump() {
        return Arrays.stream(Direction.Axis.values()).map(key -> "<directionaxis:" + key + ">").collect(Collectors.toList());
    }
}

