/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ScaffoldingBlock
extends Block
implements IWaterLoggable {
    private static final VoxelShape field_220121_d;
    private static final VoxelShape field_220122_e;
    private static final VoxelShape field_220123_f;
    private static final VoxelShape field_220124_g;
    public static final IntegerProperty field_220118_a;
    public static final BooleanProperty field_220119_b;
    public static final BooleanProperty field_220120_c;

    protected ScaffoldingBlock(Block.Properties p_i49976_1_) {
        super(p_i49976_1_);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_220118_a, Integer.valueOf(7)))).func_206870_a((IProperty)field_220119_b, Boolean.valueOf(false)))).func_206870_a((IProperty)field_220120_c, Boolean.valueOf(false))));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_220118_a, field_220119_b, field_220120_c});
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!context.func_216375_a(state.func_177230_c().func_199767_j())) {
            return (Boolean)state.func_177229_b((IProperty)field_220120_c) != false ? field_220122_e : field_220121_d;
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    @Override
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        int i = ScaffoldingBlock.func_220117_a((IBlockReader)((Object)world), blockpos);
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_220119_b, Boolean.valueOf(world.func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a)))).func_206870_a((IProperty)field_220118_a, Integer.valueOf(i)))).func_206870_a((IProperty)field_220120_c, Boolean.valueOf(this.func_220116_a((IBlockReader)((Object)world), blockpos, i))));
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_220119_b)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!worldIn.func_201670_d()) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i = ScaffoldingBlock.func_220117_a((IBlockReader)((Object)worldIn), pos);
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_220118_a, Integer.valueOf(i)))).func_206870_a((IProperty)field_220120_c, Boolean.valueOf(this.func_220116_a((IBlockReader)((Object)worldIn), pos, i))));
        if ((Integer)blockstate.func_177229_b((IProperty)field_220118_a) == 7) {
            if ((Integer)state.func_177229_b((IProperty)field_220118_a) == 7) {
                worldIn.func_217376_c(new FallingBlockEntity(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (BlockState)((Object)blockstate.func_206870_a((IProperty)field_220119_b, Boolean.valueOf(false)))));
            } else {
                worldIn.func_175655_b(pos, true);
            }
        } else if (state != blockstate) {
            worldIn.func_180501_a(pos, blockstate, 3);
        }
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return ScaffoldingBlock.func_220117_a((IBlockReader)((Object)worldIn), pos) < 7;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context.func_216378_a(VoxelShapes.func_197868_b(), pos, true) && !context.func_225581_b_()) {
            return field_220121_d;
        }
        return (Integer)state.func_177229_b((IProperty)field_220118_a) != 0 && (Boolean)state.func_177229_b((IProperty)field_220120_c) != false && context.func_216378_a(field_220124_g, pos, true) ? field_220123_f : VoxelShapes.func_197880_a();
    }

    @Override
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_220119_b) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    private boolean func_220116_a(IBlockReader p_220116_1_, BlockPos p_220116_2_, int p_220116_3_) {
        return p_220116_3_ > 0 && p_220116_1_.func_180495_p(p_220116_2_.func_177977_b()).func_177230_c() != this;
    }

    public static int func_220117_a(IBlockReader p_220117_0_, BlockPos p_220117_1_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_220117_1_).func_189536_c(Direction.DOWN);
        BlockState blockstate = p_220117_0_.func_180495_p((BlockPos)blockpos$mutable);
        int i = 7;
        if (blockstate.func_177230_c() == Blocks.field_222420_lI) {
            i = (Integer)blockstate.func_177229_b((IProperty)field_220118_a);
        } else if (blockstate.func_224755_d(p_220117_0_, (BlockPos)blockpos$mutable, Direction.UP)) {
            return 0;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate1 = p_220117_0_.func_180495_p((BlockPos)blockpos$mutable.func_189533_g((Vec3i)p_220117_1_).func_189536_c(direction));
            if (blockstate1.func_177230_c() != Blocks.field_222420_lI || (i = Math.min(i, (Integer)blockstate1.func_177229_b((IProperty)field_220118_a) + 1)) != 1) continue;
            break;
        }
        return i;
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    static {
        field_220123_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        field_220124_g = VoxelShapes.func_197868_b().func_197751_a(0.0, -1.0, 0.0);
        field_220118_a = BlockStateProperties.field_222510_au;
        field_220119_b = BlockStateProperties.field_208198_y;
        field_220120_c = BlockStateProperties.field_222513_b;
        VoxelShape voxelshape = Block.func_208617_a(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
        VoxelShape voxelshape1 = Block.func_208617_a(0.0, 0.0, 0.0, 2.0, 16.0, 2.0);
        VoxelShape voxelshape2 = Block.func_208617_a(14.0, 0.0, 0.0, 16.0, 16.0, 2.0);
        VoxelShape voxelshape3 = Block.func_208617_a(0.0, 0.0, 14.0, 2.0, 16.0, 16.0);
        VoxelShape voxelshape4 = Block.func_208617_a(14.0, 0.0, 14.0, 16.0, 16.0, 16.0);
        field_220121_d = VoxelShapes.func_216384_a((VoxelShape)voxelshape, (VoxelShape[])new VoxelShape[]{voxelshape1, voxelshape2, voxelshape3, voxelshape4});
        VoxelShape voxelshape5 = Block.func_208617_a(0.0, 0.0, 0.0, 2.0, 2.0, 16.0);
        VoxelShape voxelshape6 = Block.func_208617_a(14.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        VoxelShape voxelshape7 = Block.func_208617_a(0.0, 0.0, 14.0, 16.0, 2.0, 16.0);
        VoxelShape voxelshape8 = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 2.0);
        field_220122_e = VoxelShapes.func_216384_a((VoxelShape)field_220123_f, (VoxelShape[])new VoxelShape[]{field_220121_d, voxelshape6, voxelshape5, voxelshape8, voxelshape7});
    }
}

