/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.colytra.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ColytraConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.colytra.config.";

    public static PermissionMode getPermissionMode() {
        return (PermissionMode)((Object)ColytraConfig.SERVER.permissionMode.get());
    }

    public static List<String> getPermissionList() {
        return (List)ColytraConfig.SERVER.permissionList.get();
    }

    public static int getEnergyUsage() {
        return (Integer)ColytraConfig.SERVER.energyUsage.get();
    }

    public static ColytraMode getColytraMode() {
        return (ColytraMode)((Object)ColytraConfig.SERVER.colytraMode.get());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.EnumValue<PermissionMode> permissionMode;
        public final ForgeConfigSpec.ConfigValue<List<String>> permissionList;
        public final ForgeConfigSpec.EnumValue<ColytraMode> colytraMode;
        public final ForgeConfigSpec.IntValue energyUsage;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("server");
            this.permissionMode = builder.comment("Sets whether the permission list is a blacklist or whitelist").translation("gui.colytra.config.permissionMode").defineEnum("permissionMode", (Enum)PermissionMode.BLACKLIST);
            this.permissionList = builder.comment("List of items by registry name to be blacklisted/whitelisted based on Permission Mode").translation("gui.colytra.config.permissionList").define("permissionList", new ArrayList());
            this.colytraMode = builder.comment("Sets how the elytra chestplates will behave\nNORMAL: Elytras will exist separately from the chestplate, able to be separated later\nUNISON: Elytras will fuse completely with the chestplate, unable to be separated\nPERFECT: Elytras will fuse completely with the chestplate and flying will not use durability").translation("gui.colytra.config.colytraMode").defineEnum("colytraMode", (Enum)ColytraMode.NORMAL);
            this.energyUsage = builder.comment("How much energy per second elytra flight uses if Unison mode is active and the chestplate uses energy").translation("gui.colytra.config.energyUsage").defineInRange("energyUsage", 1000, 0, Integer.MAX_VALUE);
        }
    }

    public static enum ColytraMode {
        NORMAL,
        UNISON,
        PERFECT;

    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }
}

