/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.items;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.ToolType;
import wile.engineerstools.ModConfig;
import wile.engineerstools.ModEngineersTools;
import wile.engineerstools.items.ModBlockItem;
import wile.engineerstools.libmc.detail.Auxiliaries;
import wile.engineerstools.libmc.detail.ExtendedShapelessRecipe;

public class RediaToolItem
extends AxeItem
implements ExtendedShapelessRecipe.IRepairableToolItem {
    private static int enchantability = ItemTier.DIAMOND.func_200927_e();
    private static int max_item_damage = 3000;
    private static int initial_item_damage_percent = 100;
    private static boolean with_torch_placing = true;
    private static boolean with_hoeing = true;
    private static boolean with_tree_felling = true;
    private static boolean with_shearing = true;
    private static boolean with_safe_attacking = true;
    private static int[] efficiency_decay = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 3, 4};
    private static int[] fortune_decay = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 2, 3};
    private static float dirt_digging_speed = 14.0f;
    private static float grass_digging_speed = 15.0f;
    private static final List<Vec3i> hoffsets = ImmutableList.of((Object)new Vec3i(1, 0, 0), (Object)new Vec3i(1, 0, 1), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(0, 0, -1), (Object)new Vec3i(1, 0, -1));

    public static void on_config(boolean without_redia_torchplacing, boolean without_redia_hoeing, boolean without_redia_tree_chopping, int durability, String efficiency_curve, String fortune_curve, int redia_tool_initial_durability_percent, int attack_cooldown_ms, boolean without_safe_attacking) {
        int i;
        int i2;
        boolean parsing_ok;
        ArrayList<Integer> dc;
        boolean with_torch_placing = !without_redia_torchplacing;
        with_hoeing = !without_redia_hoeing;
        with_tree_felling = !without_redia_tree_chopping;
        max_item_damage = MathHelper.func_76125_a((int)durability, (int)750, (int)4000);
        initial_item_damage_percent = MathHelper.func_76125_a((int)redia_tool_initial_durability_percent, (int)1, (int)100);
        with_safe_attacking = !without_safe_attacking;
        ModEngineersTools.LOGGER.info("REDIA tool config: " + (with_torch_placing ? "" : "no-") + "torch-placing, " + (with_hoeing ? "" : "no-") + "hoeing, " + (with_tree_felling ? "" : "no-") + "tree-felling, " + (with_safe_attacking ? "" : "no-") + "safe-attack," + " durability:" + max_item_damage + ", initial-durability:" + redia_tool_initial_durability_percent);
        String[] sc = efficiency_curve.trim().replaceAll("[^,0-9]", "").split(",");
        if (sc.length > 0) {
            dc = new ArrayList<Integer>();
            parsing_ok = true;
            for (i2 = 0; i2 < sc.length && i2 < efficiency_decay.length; ++i2) {
                try {
                    dc.add(MathHelper.func_76125_a((int)Integer.parseInt(sc[i2]), (int)0, (int)4));
                    continue;
                }
                catch (Exception ex) {
                    ModEngineersTools.logger().error("Parsing efficiency curve failed (number at index " + i2 + ")");
                    parsing_ok = false;
                    break;
                }
            }
            if (!parsing_ok) {
                ModEngineersTools.logger().warn("Using default efficiency curve due to error.");
            } else {
                for (i2 = 1; i2 < dc.size(); ++i2) {
                    if ((Integer)dc.get(i2) >= (Integer)dc.get(i2 - 1)) continue;
                    dc.set(i2, (Integer)dc.get(i2 - 1));
                }
                while (dc.size() < efficiency_decay.length) {
                    dc.add((Integer)dc.get(dc.size() - 1));
                }
            }
        }
        StringBuilder confout = new StringBuilder();
        confout.append("REDIA tool efficiency curve: [");
        for (i = 0; i < efficiency_decay.length; ++i) {
            confout.append(Math.round(efficiency_decay[i])).append(",");
        }
        confout.deleteCharAt(confout.length() - 1).append("]");
        ModEngineersTools.LOGGER.info(confout.toString());
        sc = fortune_curve.trim().replaceAll("[^,0-9]", "").split(",");
        if (sc.length > 0) {
            dc = new ArrayList();
            parsing_ok = true;
            for (i2 = 0; i2 < sc.length && i2 < fortune_decay.length; ++i2) {
                try {
                    dc.add(MathHelper.func_76125_a((int)Integer.parseInt(sc[i2]), (int)0, (int)4));
                    continue;
                }
                catch (Exception ex) {
                    ModEngineersTools.logger().error("Parsing fortune curve failed (number at index " + i2 + ")");
                    parsing_ok = false;
                    break;
                }
            }
            if (!parsing_ok) {
                ModEngineersTools.logger().warn("Using default fortune curve due to error.");
            } else {
                for (i2 = 1; i2 < dc.size(); ++i2) {
                    if ((Integer)dc.get(i2) >= (Integer)dc.get(i2 - 1)) continue;
                    dc.set(i2, (Integer)dc.get(i2 - 1));
                }
                while (dc.size() < fortune_decay.length) {
                    dc.add((Integer)dc.get(dc.size() - 1));
                }
            }
        }
        confout = new StringBuilder();
        confout.append("REDIA tool fortune curve: [");
        for (i = 0; i < fortune_decay.length; ++i) {
            confout.append(Math.round(fortune_decay[i])).append(",");
        }
        confout.deleteCharAt(confout.length() - 1).append("]");
        ModEngineersTools.LOGGER.info(confout.toString());
    }

    public RediaToolItem(Item.Properties properties) {
        super((IItemTier)ItemTier.DIAMOND, 5.0f, -3.0f, properties.addToolType(ToolType.AXE, ItemTier.DIAMOND.func_200925_d()).addToolType(ToolType.PICKAXE, ItemTier.DIAMOND.func_200925_d()).addToolType(ToolType.SHOVEL, ItemTier.DIAMOND.func_200925_d()).func_200917_a(1).func_208103_a(Rarity.UNCOMMON).func_200915_b(max_item_damage));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, (IBlockReader)world, tooltip, flag, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return enchantability;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return super.func_82789_a(toRepair, repair);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return ItemTier.DIAMOND.func_200925_d();
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return max_item_damage;
    }

    public boolean func_150897_b(BlockState block) {
        return true;
    }

    public float getSmeltingExperience(ItemStack item) {
        return 0.0f;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185308_t) {
            return false;
        }
        if (enchantment == Enchantments.field_185305_q) {
            return false;
        }
        if (enchantment == Enchantments.field_180313_o) {
            return true;
        }
        if (enchantment == Enchantments.field_185304_p) {
            return true;
        }
        if (enchantment == Enchantments.field_185302_k) {
            return true;
        }
        if (enchantment == Enchantments.field_77334_n) {
            return true;
        }
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return ModConfig.isOptedOut((Item)this) ? ModBlockItem.DISABLED_TABS : ModBlockItem.ENABLED_TABS;
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        if (stack.func_77952_i() == 0 && stack.func_77978_p() == null) {
            stack.func_196085_b(this.absoluteDmg(initial_item_damage_percent));
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (!with_safe_attacking) {
            return false;
        }
        if (entity instanceof VillagerEntity) {
            return true;
        }
        if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n() && ((TameableEntity)entity).func_152114_e((LivingEntity)player)) {
            return true;
        }
        if (entity instanceof ZombiePigmanEntity && ((ZombiePigmanEntity)entity).func_70638_az() == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType rv;
        Direction facing = context.func_196000_l();
        Hand hand = context.func_221531_n();
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Vec3d hitvec = context.func_221532_j();
        if (context.func_195999_j().func_225608_bj_()) {
            rv = this.tryPlantSnipping(player, world, pos, hand, facing, hitvec);
            if (rv != ActionResultType.PASS) {
                return rv;
            }
            if (facing == Direction.UP) {
                rv = this.tryDigOver(player, world, pos, hand, facing, hitvec);
                if (rv != ActionResultType.PASS) {
                    return rv;
                }
            } else if (facing.func_176740_k().func_176722_c()) {
                rv = this.tryTorchPlacing(context);
                if (rv != ActionResultType.PASS) {
                    return rv;
                }
            } else {
                rv = super.func_195939_a(context);
            }
        } else {
            rv = this.tryTorchPlacing(context);
            if (rv != ActionResultType.PASS) {
                return rv;
            }
        }
        return rv;
    }

    public boolean func_179218_a(ItemStack tool, World world, BlockState state, BlockPos pos, LivingEntity player) {
        if (world.field_72995_K) {
            return true;
        }
        if (state.func_185887_b((IBlockReader)world, pos) > 0.2f) {
            tool.func_222118_a(1, player, p -> p.func_213334_d(player.func_184600_cs()));
        }
        if (with_tree_felling && player instanceof PlayerEntity && player.func_225608_bj_()) {
            this.tryTreeFelling(world, state, pos, player);
        }
        this.decayEnchantments(tool);
        return true;
    }

    public boolean func_111207_a(ItemStack tool, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        return this.tryEntityShearing(tool, player, entity, hand);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.field_77864_a;
    }

    @Override
    public ItemStack onShapelessRecipeRepaired(ItemStack stack, int previousDamage, int repairedDamage) {
        if (repairedDamage == 0) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            int max_efficiency = this.durabilityDependentEfficiency(stack);
            int act_efficiency = enchantments.getOrDefault(Enchantments.field_185305_q, 0);
            int max_fortune = this.durabilityDependentFortune(stack);
            int act_fortune = enchantments.getOrDefault(Enchantments.field_185308_t, 0);
            if (act_fortune > 0 || act_efficiency >= max_efficiency) {
                enchantments.put(Enchantments.field_185308_t, Math.min(act_fortune + 2, max_fortune));
            }
            if (act_efficiency < max_efficiency) {
                enchantments.put(Enchantments.field_185305_q, Math.min(act_efficiency + 2, max_efficiency));
            }
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
        return stack;
    }

    private int absoluteDmg(int dmg) {
        return max_item_damage * (100 - MathHelper.func_76125_a((int)dmg, (int)1, (int)100)) / 100;
    }

    private double relativeDurability(ItemStack stack) {
        return MathHelper.func_151237_a((double)((double)(this.getMaxDamage(stack) - this.getDamage(stack)) / (double)this.getMaxDamage(stack)), (double)0.0, (double)1.0);
    }

    private int durabilityDependentFortune(ItemStack stack) {
        return fortune_decay[MathHelper.func_76125_a((int)((int)(this.relativeDurability(stack) * (double)fortune_decay.length)), (int)0, (int)(fortune_decay.length - 1))];
    }

    private int durabilityDependentEfficiency(ItemStack stack) {
        return efficiency_decay[MathHelper.func_76125_a((int)((int)(this.relativeDurability(stack) * (double)efficiency_decay.length)), (int)0, (int)(efficiency_decay.length - 1))];
    }

    private void decayEnchantments(ItemStack stack) {
        if (Math.random() > 0.17) {
            return;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchantments.containsKey(Enchantments.field_185308_t)) {
            int fortune = this.durabilityDependentFortune(stack);
            if (fortune <= 0) {
                enchantments.remove(Enchantments.field_185308_t);
            } else {
                enchantments.put(Enchantments.field_185308_t, fortune);
            }
        }
        if (enchantments.containsKey(Enchantments.field_185305_q)) {
            int efficiency = this.durabilityDependentEfficiency(stack);
            if (efficiency <= 0) {
                enchantments.remove(Enchantments.field_185305_q);
            } else {
                enchantments.put(Enchantments.field_185305_q, efficiency);
            }
        }
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
    }

    private boolean tryEntityShearing(ItemStack tool, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K || !(entity instanceof IShearable)) {
            return false;
        }
        IShearable target = (IShearable)entity;
        BlockPos pos = new BlockPos((Vec3i)entity.func_180425_c());
        if (target.isShearable(tool, (IWorldReader)entity.field_70170_p, pos)) {
            List drops = target.onSheared(tool, (IWorld)entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool));
            Random rand = new Random();
            drops.forEach(d -> {
                ItemEntity ent = entity.func_70099_a(d, 1.0f);
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            });
            tool.func_222118_a(1, entity, e -> e.func_213334_d(hand));
            player.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.8f, 1.1f);
        }
        return true;
    }

    private ActionResultType tryPlantSnipping(PlayerEntity player, World world, BlockPos pos, Hand hand, Direction facing, Vec3d hitvec) {
        if (!with_shearing) {
            return ActionResultType.PASS;
        }
        ItemStack tool = player.func_184586_b(hand);
        if (tool.func_77973_b() != this) {
            return ActionResultType.PASS;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!state.func_203425_a(BlockTags.field_206952_E) && block != Blocks.field_196553_aF && block != Blocks.field_150349_c && block != Blocks.field_196554_aH && block != Blocks.field_196555_aI && block != Blocks.field_150395_bd && block != Blocks.field_150473_bD && !block.func_203417_a(BlockTags.field_199897_a)) {
            return ActionResultType.PASS;
        }
        ItemEntity ie = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((IItemProvider)block.func_199767_j()));
        ie.func_174869_p();
        world.func_217376_c((Entity)ie);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        tool.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
        world.func_184133_a(player, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.8f, 1.1f);
        return ActionResultType.SUCCESS;
    }

    private ActionResultType tryTorchPlacing(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        if (!with_torch_placing) {
            return ActionResultType.PASS;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != Blocks.field_150478_aa.func_199767_j()) continue;
            ItemStack tool = player.func_184586_b(hand);
            player.func_184611_a(hand, stack);
            ItemUseContext torch_context = new ItemUseContext(context.func_195999_j(), context.func_221531_n(), new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), context.func_221533_k()));
            ActionResultType r = stack.func_77973_b().func_195939_a(torch_context);
            player.func_184611_a(hand, tool);
            return r;
        }
        return ActionResultType.PASS;
    }

    private ActionResultType tryDigOver(PlayerEntity player, World world, BlockPos pos, Hand hand, Direction facing, Vec3d hitvec) {
        BlockState state;
        if (!with_hoeing) {
            return ActionResultType.PASS;
        }
        if (world.func_175625_s(pos) != null) {
            return ActionResultType.PASS;
        }
        BlockState replaced = state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof GrassBlock || block == Blocks.field_150346_d) {
            replaced = Blocks.field_150458_ak.func_176223_P();
        } else if (block instanceof FarmlandBlock) {
            replaced = Blocks.field_196660_k.func_176223_P();
        } else if (block == Blocks.field_196660_k) {
            replaced = Blocks.field_185774_da.func_176223_P();
        } else if (block instanceof GrassPathBlock) {
            replaced = Blocks.field_150346_d.func_176223_P();
        }
        if (replaced != state) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 0.8f, 1.1f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, replaced, 3);
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() == this) {
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean tryTreeFelling(World world, BlockState state, BlockPos pos, LivingEntity player) {
        if (!state.func_215686_e((IBlockReader)world, pos) || state.func_185904_a() != Material.field_151575_d) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (!state.func_177230_c().getTags().contains(new ResourceLocation("minecraft", "logs"))) {
            return false;
        }
        this.chopTree(world, state, pos, player);
        return true;
    }

    private List<BlockPos> findBlocksAround(World world, BlockPos centerPos, BlockState leaf_type_state, Set<BlockPos> checked, int recursion_left) {
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        for (int y = -1; y <= 1; ++y) {
            BlockPos layer = centerPos.func_177982_a(0, y, 0);
            for (Vec3i v : hoffsets) {
                BlockPos pos = layer.func_177971_a(v);
                if (checked.contains(pos) || world.func_180495_p(pos).func_177230_c() != leaf_type_state.func_177230_c()) continue;
                checked.add(pos);
                to_decay.add(pos);
                if (recursion_left <= 0) continue;
                to_decay.addAll(this.findBlocksAround(world, pos, leaf_type_state, checked, recursion_left - 1));
            }
        }
        return to_decay;
    }

    private static boolean isSameLog(BlockState a, BlockState b) {
        return a.func_177230_c() == b.func_177230_c();
    }

    private static boolean isLeaves(BlockState state) {
        if (state.func_177230_c() instanceof LeavesBlock) {
            return true;
        }
        return state.func_177230_c().getTags().contains(new ResourceLocation("minecraft", "leaves"));
    }

    private void breakBlock(World world, BlockPos pos, LivingEntity entity) {
        BlockState state = world.func_180495_p(pos);
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j(0.005f);
        }
        Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, null, (Entity)entity, (ItemStack)new ItemStack((IItemProvider)this));
        IFluidState fstate = world.func_204610_c(pos);
        if (world.func_180501_a(pos, fstate.func_206883_i(), 11)) {
            // empty if block
        }
    }

    private void chopTree(World world, BlockState broken_state, BlockPos startPos, LivingEntity player) {
        Block broken_block = broken_state.func_177230_c();
        if (!(broken_block instanceof LogBlock)) {
            return;
        }
        ItemStack tool = player.func_184614_ca();
        if (tool.func_77973_b() != this) {
            tool = player.func_184592_cb();
        }
        if (tool.func_77973_b() != this) {
            return;
        }
        int max_broken_blocks = (tool.func_77958_k() - tool.func_77952_i()) * 2 / 3;
        long ymin = startPos.func_177956_o();
        long max_leaf_distance = 6L;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> to_break = new ArrayList<BlockPos>();
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        checked.add(startPos);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        LinkedList<BlockPos> upqueue = new LinkedList<BlockPos>();
        queue.add(startPos);
        int cutlevel = 0;
        int steps_left = 64;
        while (!queue.isEmpty() && --steps_left >= 0) {
            BlockPos pos = (BlockPos)queue.removeFirst();
            BlockPos uppos = pos.func_177984_a();
            BlockState upstate = world.func_180495_p(uppos);
            if (!checked.contains(uppos)) {
                checked.add(uppos);
                if (RediaToolItem.isSameLog(upstate, broken_state)) {
                    upqueue.add(uppos);
                    to_break.add(uppos);
                    steps_left = 64;
                } else {
                    boolean isleaf = RediaToolItem.isLeaves(upstate);
                    if (isleaf || world.func_175623_d(uppos) || upstate.func_177230_c() instanceof VineBlock) {
                        if (isleaf) {
                            to_decay.add(uppos);
                        }
                        for (Vec3i v : hoffsets) {
                            BlockPos p2 = uppos.func_177971_a(v);
                            if (checked.contains(p2)) continue;
                            checked.add(p2);
                            BlockState st = world.func_180495_p(p2);
                            Block bl = st.func_177230_c();
                            if (RediaToolItem.isSameLog(st, broken_state)) {
                                queue.add(p2);
                                to_break.add(p2);
                                continue;
                            }
                            if (!RediaToolItem.isLeaves(st)) continue;
                            to_decay.add(p2);
                        }
                    }
                }
            }
            for (Vec3i v : hoffsets) {
                BlockPos p3 = pos.func_177971_a(v);
                if (checked.contains(p3)) continue;
                checked.add(p3);
                if (p3.func_177951_i((Vec3i)new BlockPos(startPos.func_177958_n(), p3.func_177956_o(), startPos.func_177952_p())) > (double)(3 + cutlevel * cutlevel)) continue;
                BlockState st = world.func_180495_p(p3);
                Block bl = st.func_177230_c();
                if (RediaToolItem.isSameLog(st, broken_state)) {
                    queue.add(p3);
                    to_break.add(p3);
                    continue;
                }
                if (!RediaToolItem.isLeaves(st)) continue;
                to_decay.add(p3);
            }
            if (!queue.isEmpty() || upqueue.isEmpty()) continue;
            queue = upqueue;
            upqueue = new LinkedList();
            ++cutlevel;
        }
        for (BlockPos pos : to_decay) {
            int dist = 1;
            to_break.addAll(this.findBlocksAround(world, pos, broken_state, checked, dist));
        }
        if (!to_decay.isEmpty()) {
            BlockState leaf_type_state = world.func_180495_p((BlockPos)to_decay.get(0));
            ArrayList<BlockPos> leafs = to_decay;
            to_decay = new ArrayList();
            for (BlockPos pos : leafs) {
                int dist = 2;
                to_decay.add(pos);
                to_decay.addAll(this.findBlocksAround(world, pos, leaf_type_state, checked, dist));
            }
        }
        checked.remove(startPos);
        for (BlockPos pos : to_break) {
            this.breakBlock(world, pos, player);
        }
        for (BlockPos pos : to_decay) {
            this.breakBlock(world, pos, player);
        }
        int dmg = to_break.size() * 6 / 5 + to_decay.size() / 10 - 1;
        if (dmg < 1) {
            dmg = 1;
        }
        tool.func_222118_a(dmg, player, p -> p.func_213334_d(player.func_184600_cs()));
        if (player instanceof PlayerEntity) {
            float exhaustion = MathHelper.func_76131_a((float)((float)dmg / 8.0f), (float)0.5f, (float)20.0f);
            ((PlayerEntity)player).func_71020_j(exhaustion);
        }
    }
}

