/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic_view.ViewDistHandler;

import com.dynamic_view.DynView;
import com.dynamic_view.ViewDistHandler.IDynamicViewDistanceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ServerDynamicViewDistanceManager
implements IDynamicViewDistanceManager {
    private static final int UPDATE_LEEWAY = 2;
    private static ServerDynamicViewDistanceManager instance;
    private final int minChunkViewDist;
    private final int maxChunkViewDist;
    private final double meanTickToStayBelow;
    private int currentChunkViewDist = 0;

    private ServerDynamicViewDistanceManager() {
        this.minChunkViewDist = (Integer)DynView.getConfig().getCommonConfig().minChunkViewDist.get();
        this.maxChunkViewDist = (Integer)DynView.getConfig().getCommonConfig().maxChunkViewDist.get();
        this.meanTickToStayBelow = ((Integer)DynView.getConfig().getCommonConfig().meanAvgTickTime.get()).intValue();
        this.currentChunkViewDist = this.minChunkViewDist;
    }

    public static IDynamicViewDistanceManager getInstance() {
        if (instance == null) {
            instance = new ServerDynamicViewDistanceManager();
        }
        return instance;
    }

    @Override
    public void initViewDist() {
        ServerLifecycleHooks.getCurrentServer().func_184103_al().func_217884_a(this.currentChunkViewDist);
    }

    @Override
    public void updateViewDistForMeanTick() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.func_184103_al().func_181057_v().isEmpty()) {
            return;
        }
        double meanTickTime = (double)ServerDynamicViewDistanceManager.average(server.field_71311_j) * 1.0E-6;
        if (meanTickTime - 2.0 > this.meanTickToStayBelow && this.currentChunkViewDist > this.minChunkViewDist) {
            --this.currentChunkViewDist;
            if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                DynView.LOGGER.info("Mean tick: " + Math.round(meanTickTime * 100.0) / 100L + "ms decreasing chunk view distance to: " + this.currentChunkViewDist);
            }
            server.func_184103_al().func_217884_a(this.currentChunkViewDist);
        }
        if (meanTickTime + 2.0 < this.meanTickToStayBelow && this.currentChunkViewDist < this.maxChunkViewDist) {
            ++this.currentChunkViewDist;
            if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                DynView.LOGGER.info("Mean tick: " + Math.round(meanTickTime * 100.0) / 100L + "ms increasing chunk view distance to: " + this.currentChunkViewDist);
            }
            server.func_184103_al().func_217884_a(this.currentChunkViewDist);
        }
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

