/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.client.gui.bag.ContainerFlowerBag;
import vazkii.botania.common.block.BlockModFlower;

public class ItemFlowerBag
extends Item {
    public ItemFlowerBag(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onPickupItem);
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT oldCapNbt) {
        return new InvProvider();
    }

    private void onPickupItem(EntityItemPickupEvent event) {
        ItemStack entityStack = event.getItem().func_92059_d();
        if (Block.func_149634_a((Item)entityStack.func_77973_b()) instanceof BlockModFlower && entityStack.func_190916_E() > 0) {
            int color = ((BlockModFlower)Block.func_149634_a((Item)entityStack.func_77973_b())).color.func_196059_a();
            for (int i = 0; i < event.getPlayer().field_71071_by.func_70302_i_(); ++i) {
                ItemStack bag;
                if (i == event.getPlayer().field_71071_by.field_70461_c || (bag = event.getPlayer().field_71071_by.func_70301_a(i)).func_190926_b() || bag.func_77973_b() != this) continue;
                IItemHandler bagInv = (IItemHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
                ItemStack result = bagInv.insertItem(color, entityStack, false);
                int numPickedUp = entityStack.func_190916_E() - result.func_190916_E();
                event.getItem().func_92058_a(result);
                if (numPickedUp <= 0) continue;
                event.setCanceled(true);
                if (!event.getItem().func_174814_R()) {
                    event.getItem().field_70170_p.func_184148_a(null, event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((event.getItem().field_70170_p.field_73012_v.nextFloat() - event.getItem().field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147359_a((IPacket)new SCollectItemPacket(event.getItem().func_145782_y(), event.getPlayer().func_145782_y(), numPickedUp));
                event.getPlayer().field_71070_bA.func_75142_b();
                return;
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            SimpleNamedContainerProvider container = new SimpleNamedContainerProvider((w, p, pl) -> new ContainerFlowerBag(w, p, stack), stack.func_200301_q());
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)container, buf -> buf.writeBoolean(hand == Hand.MAIN_HAND));
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (!world.field_72995_K) {
                IItemHandler tileInv;
                if (tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).isPresent()) {
                    tileInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElseThrow(NullPointerException::new);
                } else if (tile instanceof IInventory) {
                    tileInv = new InvWrapper((IInventory)tile);
                } else {
                    return ActionResultType.FAIL;
                }
                ctx.func_195996_i().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(bagInv -> {
                    for (int i = 0; i < bagInv.getSlots(); ++i) {
                        ItemStack flower = bagInv.getStackInSlot(i);
                        ((IItemHandlerModifiable)bagInv).setStackInSlot(i, ItemHandlerHelper.insertItemStacked((IItemHandler)tileInv, (ItemStack)flower, (boolean)false));
                    }
                });
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static class InvProvider
    implements ICapabilitySerializable<INBT> {
        private final IItemHandler inv = new ItemStackHandler(16){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                Block blk = Block.func_149634_a((Item)stack.func_77973_b());
                return !stack.func_190926_b() && blk.getClass() == BlockModFlower.class && slot == ((BlockModFlower)blk).color.func_196059_a();
            }
        };
        private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> this.inv);

        private InvProvider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.opt);
        }

        public INBT serializeNBT() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
        }

        public void deserializeNBT(INBT nbt) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, nbt);
        }
    }
}

