/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.world;

import com.performant.coremod.Performant;
import com.performant.coremod.commands.ReportData;
import com.performant.coremod.config.ConfigurationCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.server.timings.TimeTracker;
import org.apache.logging.log4j.LogManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={World.class})
public class WorldMixin {
    World self = (World)this;
    @Shadow
    protected boolean field_147481_N;
    @Shadow
    protected Set<TileEntity> field_147483_b;
    @Shadow
    public List<TileEntity> field_175730_i;
    @Shadow
    @Final
    protected List<TileEntity> field_147484_a;
    Map<String, Integer> unloadTEs = new HashMap<String, Integer>();
    Map<BlockPos, Integer> tePausedTimes = new HashMap<BlockPos, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_217391_K() {
        for (Map.Entry<String, Integer> entry : this.unloadTEs.entrySet()) {
            if (entry.getValue() <= 0) continue;
            entry.setValue(entry.getValue() - 1);
        }
        IProfiler iprofiler = this.self.func_217381_Z();
        iprofiler.func_76320_a("blockEntities");
        this.field_147481_N = true;
        if (!this.field_147483_b.isEmpty()) {
            for (TileEntity te : this.field_147483_b) {
                int pause = 0;
                if (ConfigurationCache.TEChunkUnloadLag && !this.self.field_72995_K && this.unloadTEs.containsKey(te.getClass().getTypeName())) {
                    pause = this.unloadTEs.get(te.getClass().getTypeName());
                }
                if (pause != 0) continue;
                long prev = System.currentTimeMillis();
                te.onChunkUnloaded();
                prev = System.currentTimeMillis() - prev;
                if (!ConfigurationCache.TEChunkUnloadLag || prev <= 0L || !(ConfigurationCache.CURRENT_MEAN_TICK_TIME > (double)ConfigurationCache.meanTickTH)) continue;
                this.unloadTEs.put(te.getClass().getTypeName(), 200 * (int)prev);
            }
            this.self.field_175730_i.removeAll(this.field_147483_b);
            this.self.field_147482_g.removeAll(this.field_147483_b);
            this.field_147483_b.clear();
        }
        Iterator<TileEntity> iterator = this.field_175730_i.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            TileEntity tileentity;
            block25: {
                tileentity = iterator.next();
                if (!tileentity.func_145837_r() && tileentity.func_145830_o()) {
                    BlockPos blockpos = tileentity.func_174877_v();
                    if (this.self.func_72863_F().func_222866_a(blockpos) && this.self.func_175723_af().func_177746_a(blockpos)) {
                        try {
                            TimeTracker.TILE_ENTITY_UPDATE.trackStart((Object)tileentity);
                            iprofiler.func_76320_a(String.valueOf(tileentity.func_200662_C().getRegistryName()));
                            if (tileentity.func_200662_C().func_223045_a(this.self.func_180495_p(blockpos).func_177230_c())) {
                                if (!ConfigurationCache.TELoadBalancing || this.self.field_72995_K) {
                                    ((ITickableTileEntity)tileentity).func_73660_a();
                                } else {
                                    int pauseTicks = this.tePausedTimes.getOrDefault(blockpos, 0);
                                    if (pauseTicks > 0) {
                                        this.tePausedTimes.put(blockpos, --pauseTicks);
                                    } else {
                                        long time = System.currentTimeMillis();
                                        ((ITickableTileEntity)tileentity).func_73660_a();
                                        time = System.currentTimeMillis() - time;
                                        if (time > 0L && ConfigurationCache.CURRENT_MEAN_TICK_TIME > (double)ConfigurationCache.meanTickTH && (pauseTicks = (int)time * 100 / ConfigurationCache.timeForTEs) > 0) {
                                            if (ConfigurationCache.generateReport) {
                                                ReportData data = new ReportData();
                                                data.te = tileentity;
                                                data.totalTickTime = (int)time;
                                                data.world = this.self;
                                                ReportData.addTileEntityReport(tileentity, data);
                                            }
                                            this.tePausedTimes.put(blockpos, pauseTicks += this.self.field_73012_v.nextInt(3));
                                            if (ConfigurationCache.TEDebugOutput && pauseTicks > 20) {
                                                Performant.LOGGER.info("Pausing very laggy TE, Tileentity " + new TranslationTextComponent(tileentity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]).getString() + " at:" + blockpos + " dim:" + this.self.field_73011_w.func_186058_p().func_186068_a() + " took a " + time + " ms to tick");
                                                this.tePausedTimes.put(blockpos, pauseTicks += 500);
                                            }
                                        }
                                    }
                                }
                            } else {
                                tileentity.func_222814_r();
                            }
                            iprofiler.func_76319_b();
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking block entity");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block entity being ticked");
                            tileentity.func_145828_a(crashreportcategory);
                            if (((Boolean)ForgeConfig.SERVER.removeErroringTileEntities.get()).booleanValue()) {
                                LogManager.getLogger().fatal("{}", (Object)crashreport.func_71502_e());
                                tileentity.func_145843_s();
                                this.self.func_175713_t(tileentity.func_174877_v());
                                break block25;
                            }
                            throw new ReportedException(crashreport);
                        }
                        finally {
                            TimeTracker.TILE_ENTITY_UPDATE.trackEnd((Object)tileentity);
                        }
                    }
                }
            }
            if (!tileentity.func_145837_r()) continue;
            iterator.remove();
            this.self.field_147482_g.remove(tileentity);
            if (!this.self.func_175667_e(tileentity.func_174877_v()) || (chunk = this.self.func_175726_f(tileentity.func_174877_v())).func_177424_a(tileentity.func_174877_v(), Chunk.CreateEntityType.CHECK) != tileentity) continue;
            chunk.func_177425_e(tileentity.func_174877_v());
        }
        this.field_147481_N = false;
        iprofiler.func_219895_b("pendingBlockEntities");
        if (!this.field_147484_a.isEmpty()) {
            for (int i = 0; i < this.field_147484_a.size(); ++i) {
                TileEntity tileentity1 = this.field_147484_a.get(i);
                if (tileentity1.func_145837_r()) continue;
                if (!this.self.field_147482_g.contains(tileentity1)) {
                    this.self.func_175700_a(tileentity1);
                }
                if (!this.self.func_175667_e(tileentity1.func_174877_v())) continue;
                Chunk chunk = this.self.func_175726_f(tileentity1.func_174877_v());
                BlockState blockstate = chunk.func_180495_p(tileentity1.func_174877_v());
                chunk.func_177426_a(tileentity1.func_174877_v(), tileentity1);
                this.self.func_184138_a(tileentity1.func_174877_v(), blockstate, blockstate, 3);
            }
            this.field_147484_a.clear();
        }
        iprofiler.func_76319_b();
    }
}

