/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Arrays;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class LocalizerDefault
implements ILocalizer {
    public static final LocalizerDefault INSTANCE = new LocalizerDefault();

    private LocalizerDefault() {
    }

    @Override
    public ITextComponent localizeMaterialForm(String formTranslationKey, IMaterial material, String overrideKey) {
        LanguageMap languageMap = LanguageMap.func_74808_a();
        Map<String, String> locMap = ApiImpl.INSTANCE.currentMaterialLocalizationMap();
        if (languageMap.func_210813_b(overrideKey)) {
            return new TranslationTextComponent(overrideKey, new Object[0]);
        }
        if (locMap.containsKey(overrideKey)) {
            return new StringTextComponent(locMap.get(overrideKey));
        }
        String materialKey = "jaopca.material." + material.getName();
        String materialName = languageMap.func_210813_b(materialKey) ? languageMap.func_74805_b(materialKey) : (locMap.containsKey(materialKey) ? locMap.get(materialKey) : LocalizerDefault.splitAndCapitalize(material.getName()));
        if (languageMap.func_210813_b(formTranslationKey) || !locMap.containsKey(formTranslationKey)) {
            return new TranslationTextComponent(formTranslationKey, new Object[]{materialName});
        }
        return new StringTextComponent(String.format(locMap.get(overrideKey), materialName));
    }

    public static String splitAndCapitalize(String underscore) {
        return Arrays.stream(StringUtils.split((String)underscore, (char)'_')).map(StringUtils::capitalize).reduce((s1, s2) -> s1 + ' ' + s2).orElse("");
    }
}

