/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.pathfinding;

import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import com.github.alexthe666.rats.server.pathfinding.AStarNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class AStar {
    protected List<AStarNode> confirmedList = new ArrayList<AStarNode>();
    protected List<AStarNode> shoppingList = new ArrayList<AStarNode>();
    protected boolean includeAir;
    private Map<Long, AStarNode> nodeMap = new HashMap<Long, AStarNode>();
    private AStarNode start;
    private AStarNode end;
    private int overflowLimit = 0;
    private boolean pathFound = false;

    public AStar(BlockPos startPos, BlockPos endPos, int overflowLimit, boolean includeAir) {
        this.start = new AStarNode(this, null, startPos, 0.0, endPos);
        this.end = new AStarNode(this, this.start, endPos, 0.0, endPos);
        this.overflowLimit = overflowLimit;
        this.includeAir = includeAir;
    }

    protected static boolean isRatTube(IWorldReader world, BlockPos offset) {
        return world.func_175625_s(offset) instanceof TileEntityRatTube;
    }

    public static BlockPos getConnectedToRatTube(IBlockReader world, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockPos statePos = pos.func_177972_a(facing);
            BlockState state = world.func_180495_p(statePos);
            if (!(state.func_177230_c() instanceof BlockRatTube)) continue;
            for (int i = 0; i < Direction.values().length; ++i) {
                BooleanProperty bool = BlockRatTube.ALL_OPEN_PROPS[i];
                BlockPos offsetInPos = statePos.func_177972_a(Direction.values()[i]);
                if (!((Boolean)state.func_177229_b((IProperty)bool)).booleanValue() || !world.func_180495_p(offsetInPos).isAir(world, offsetInPos) && !(world.func_180495_p(offsetInPos).func_177230_c() instanceof BlockRatCage)) continue;
                return offsetInPos;
            }
        }
        return null;
    }

    public BlockPos[] getPath(IWorldReader world) {
        this.shoppingList.add(this.start);
        while (this.confirmedList.size() < this.overflowLimit && !this.pathFound && this.shoppingList.size() > 0) {
            AStarNode n = this.shoppingList.get(0);
            for (AStarNode nt : this.shoppingList) {
                if (!(nt.getCost() < n.getCost())) continue;
                n = nt;
            }
            if (n.calcCost < 1.0) {
                this.pathFound = true;
                this.end = n;
                break;
            }
            n.generateReachablePos(world);
            this.shoppingList.remove(n);
            this.confirmedList.add(n);
        }
        if (!this.pathFound) {
            int length = this.confirmedList.size();
            BlockPos[] locations = new BlockPos[length];
            for (int i = 0; i < length; ++i) {
                locations[i] = this.confirmedList.get(i).getPos();
            }
            return locations;
        }
        int length = 1;
        AStarNode n = this.end;
        while (n.start != null) {
            n = n.start;
            ++length;
        }
        BlockPos[] locations = new BlockPos[length];
        n = this.end;
        for (int i = length - 1; i > 0; --i) {
            locations[i] = n.getPos();
            n = n.start;
        }
        locations[0] = this.start.getPos();
        return locations;
    }

    public AStarNode getNodeFromMap(BlockPos pos) {
        Long toLong = pos.func_218275_a();
        if (this.nodeMap.get(toLong) == null) {
            AStarNode node = new AStarNode(this, null, pos, 0.0, this.end.getPos());
            this.nodeMap.put(pos.func_218275_a(), node);
            return node;
        }
        return this.nodeMap.get(toLong);
    }
}

