/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.inventory.ContainerEmpty;
import com.github.alexthe666.rats.server.inventory.ContainerRatCraftingTable;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageUpdateTileSlots;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityRatCraftingTable
extends LockableTileEntity
implements ITickableTileEntity,
ISidedInventory {
    private static final Predicate<ItemStack> EMPTY_ITEM_PREDICATE = new Predicate<ItemStack>(){

        public boolean apply(@Nullable ItemStack itemStack) {
            return itemStack != null && !itemStack.func_190926_b();
        }
    };
    private static final int[] SLOTS_TOP = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private static final IRecipeSerializer[] RECIPES_TO_SCAN = new IRecipeSerializer[]{IRecipeSerializer.field_222157_a, IRecipeSerializer.field_222157_a};
    private static List<IRecipe> EMPTY_LIST = new ArrayList<IRecipe>();
    public int prevCookTime;
    public boolean hasRat;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
    public int cookTime;
    private int totalCookTime = 200;
    public final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 2: {
                    return TileEntityRatCraftingTable.this.cookTime;
                }
                case 3: {
                    return TileEntityRatCraftingTable.this.totalCookTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 2: {
                    TileEntityRatCraftingTable.this.cookTime = value;
                    break;
                }
                case 3: {
                    TileEntityRatCraftingTable.this.totalCookTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private String furnaceCustomName;
    private boolean canSwapRecipe;
    private List<IRecipe> currentApplicableRecipes = new ArrayList<IRecipe>();
    private IRecipe selectedRecipe = null;
    private int selectedRecipeIndex = 0;

    public TileEntityRatCraftingTable() {
        super(RatsTileEntityRegistry.RAT_CRAFTING_TABLE);
    }

    public static boolean hasIngredients(IRecipe recipe, NonNullList<ItemStack> stacks) {
        HashMap<Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>();
        for (Map.Entry<Ingredient, Integer> ing : TileEntityRatCraftingTable.compressRecipe(recipe).entrySet()) {
            ingredients.put(ing.getKey(), ing.getValue());
        }
        Iterator itr = ingredients.keySet().iterator();
        block1: while (itr.hasNext()) {
            Ingredient ingredient = (Ingredient)itr.next();
            ItemStack[] matches = ingredient.func_193365_a();
            int count = 0;
            boolean removedCount = false;
            int maxCount = (Integer)ingredients.get(ingredient);
            for (ItemStack stack : stacks) {
                if (TileEntityRatCraftingTable.doesArrayContainStack(matches, stack)) {
                    count += stack.func_190916_E();
                }
                if (count < maxCount) continue;
                itr.remove();
                continue block1;
            }
        }
        return ingredients.isEmpty();
    }

    public static NonNullList<ItemStack> consumeIngredients(IRecipe recipe, NonNullList<ItemStack> stacks, NonNullList<ItemStack> inv) {
        int i;
        HashMap<Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>();
        CraftingInventory inventoryCrafting = new CraftingInventory((Container)new ContainerEmpty(103, null), 3, 3);
        for (Map.Entry<Ingredient, Integer> ing : TileEntityRatCraftingTable.compressRecipe(recipe).entrySet()) {
            ingredients.put(ing.getKey(), ing.getValue());
        }
        Iterator itr = ingredients.keySet().iterator();
        NonNullList removedItems = NonNullList.func_191196_a();
        block1: while (itr.hasNext()) {
            Ingredient ingredient = (Ingredient)itr.next();
            ItemStack[] matches = ingredient.func_193365_a();
            int removedCount = 0;
            int maxCount = (Integer)ingredients.get(ingredient);
            for (ItemStack stack : stacks) {
                if (TileEntityRatCraftingTable.doesArrayContainStack(matches, stack) && removedCount < maxCount) {
                    ItemStack copyStack = stack.func_77946_l();
                    copyStack.func_190920_e(removedCount += Math.min(stack.func_190916_E(), maxCount));
                    removedItems.add((Object)copyStack);
                    stack.func_190918_g(removedCount);
                }
                if (removedCount < maxCount) continue;
                itr.remove();
                continue block1;
            }
        }
        for (i = 0; i < stacks.size(); ++i) {
            inv.set(i + 2, stacks.get(i));
        }
        for (i = 0; i < removedItems.size(); ++i) {
            inventoryCrafting.func_70299_a(i, (ItemStack)removedItems.get(i));
        }
        NonNullList remainWEmpties = recipe.func_179532_b((IInventory)inventoryCrafting);
        NonNullList remain = NonNullList.func_191196_a();
        for (ItemStack remaining : remainWEmpties) {
            if (remaining.func_190926_b()) continue;
            remain.add((Object)remaining);
        }
        return remain;
    }

    public static Map<Ingredient, Integer> compressRecipe(IRecipe recipe) {
        ArrayList<ItemStack> countedIngredients = new ArrayList<ItemStack>();
        HashMap<Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>();
        for (int i = 0; i < recipe.func_192400_c().size(); ++i) {
            Ingredient ingredient = (Ingredient)recipe.func_192400_c().get(i);
            ItemStack[] matches = ingredient.func_193365_a();
            int index = 0;
            if (matches.length <= 0) continue;
            ItemStack counted = matches[index].func_77946_l();
            int count = 0;
            if (TileEntityRatCraftingTable.doesListContainStack(countedIngredients, counted) || counted.func_190926_b() || counted.func_77973_b() == Items.field_190931_a) continue;
            for (int j = 0; j < recipe.func_192400_c().size(); ++j) {
                if (!TileEntityRatCraftingTable.doesArrayContainStack(((Ingredient)recipe.func_192400_c().get(j)).func_193365_a(), counted)) continue;
                ++count;
            }
            counted.func_190920_e(count);
            ingredients.put(ingredient, count);
            countedIngredients.add(counted);
        }
        return ingredients;
    }

    private static boolean doesArrayContainStack(ItemStack[] list, ItemStack stack) {
        for (ItemStack currentItem : list) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)currentItem)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesListContainStack(List<ItemStack> list, ItemStack stack) {
        for (ItemStack currentItem : list) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)currentItem)) continue;
            return true;
        }
        return false;
    }

    private List<IRecipe> findMatchingRecipesFor(ItemStack stack) {
        List<IRecipe> matchingRecipes = EMPTY_LIST;
        if (!stack.func_190926_b()) {
            matchingRecipes = new ArrayList<IRecipe>();
            RecipeManager manager = this.field_145850_b.func_199532_z();
            for (IRecipe irecipe : manager.func_199510_b()) {
                if (irecipe.func_222127_g() != IRecipeType.field_222149_a || !irecipe.func_194133_a(3, 3) || !irecipe.func_77571_b().func_77969_a(stack)) continue;
                matchingRecipes.add(irecipe);
            }
        }
        return matchingRecipes;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{1};
        }
        return SLOTS_TOP;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.totalCookTime = 200;
            this.cookTime = 0;
            this.currentApplicableRecipes.clear();
            this.currentApplicableRecipes = this.findMatchingRecipesFor(stack);
            this.selectedRecipe = null;
            this.selectedRecipeIndex = 0;
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K) {
            RatsMod.sendMSGToAll(new MessageUpdateTileSlots(this.func_174877_v().func_218275_a(), this.func_189517_E_()));
        }
    }

    public int getCookTime(ItemStack stack) {
        return 200;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 1;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_73660_a() {
        boolean flag = false;
        this.hasRat = false;
        this.prevCookTime = this.cookTime;
        for (EntityRat rat : this.field_145850_b.func_217357_a(EntityRat.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p(), (double)this.field_174879_c.func_177958_n() + 1.0, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 1.0))) {
            if (!rat.func_70909_n() || !rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CRAFTING)) continue;
            this.hasRat = true;
        }
        if (!this.currentApplicableRecipes.isEmpty()) {
            this.selectedRecipe = this.currentApplicableRecipes.size() <= 1 ? this.currentApplicableRecipes.get(0) : this.currentApplicableRecipes.get(this.selectedRecipeIndex);
        } else {
            this.currentApplicableRecipes = this.findMatchingRecipesFor(this.func_70301_a(0));
        }
        if (this.selectedRecipe != null && (this.func_70301_a(1).func_190926_b() || this.func_70301_a(1).func_77969_a(this.selectedRecipe.func_77571_b()) && this.func_70301_a(1).func_190916_E() + this.selectedRecipe.func_77571_b().func_190916_E() <= this.selectedRecipe.func_77571_b().func_77976_d() && this.func_70301_a(1).func_77985_e())) {
            NonNullList stacks = NonNullList.func_191196_a();
            for (int i = 2; i < 11; ++i) {
                stacks.add(this.inventory.get(i));
            }
            if (TileEntityRatCraftingTable.hasIngredients(this.selectedRecipe, (NonNullList<ItemStack>)stacks) && this.hasRat) {
                ++this.cookTime;
                flag = true;
                if (this.cookTime >= 200) {
                    this.cookTime = 0;
                    if (this.func_70301_a(1).func_77969_a(this.selectedRecipe.func_77571_b()) && this.func_70301_a(1).func_190916_E() < 64) {
                        this.func_70301_a(1).func_190917_f(this.selectedRecipe.func_77571_b().func_190916_E());
                    } else if (this.func_70301_a(1).func_190926_b()) {
                        this.func_70299_a(1, this.selectedRecipe.func_77571_b().func_77946_l());
                    }
                    NonNullList<ItemStack> remainingItems = TileEntityRatCraftingTable.consumeIngredients(this.selectedRecipe, (NonNullList<ItemStack>)stacks, this.inventory);
                    for (ItemStack stack : remainingItems) {
                        boolean depositied = false;
                        for (int i = 2; i < 11; ++i) {
                            if (stack.func_77985_e() && ((ItemStack)this.inventory.get(i)).func_77969_a(stack) && ((ItemStack)this.inventory.get(i)).func_190916_E() + stack.func_190916_E() <= ((ItemStack)this.inventory.get(i)).func_77976_d() && !depositied) {
                                int remainingSize = ((ItemStack)this.inventory.get(i)).func_77976_d() - ((ItemStack)this.inventory.get(i)).func_190916_E();
                                int addToSize = Math.min(remainingSize, stack.func_190916_E());
                                stack.func_190918_g(addToSize);
                                ((ItemStack)this.inventory.get(i)).func_190917_f(addToSize);
                                if (stack.func_190916_E() <= 0) {
                                    depositied = true;
                                    break;
                                }
                            }
                            if (!((ItemStack)this.inventory.get(i)).func_190926_b() || depositied) continue;
                            depositied = true;
                            this.func_70299_a(i, stack);
                            break;
                        }
                        if (depositied || this.field_145850_b.field_72995_K) continue;
                        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 1.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (ItemStack)stack);
                    }
                }
            }
        }
        if (!flag && this.cookTime > 0) {
            this.cookTime = 0;
        }
    }

    public void increaseRecipe() {
        if (!this.currentApplicableRecipes.isEmpty() && this.currentApplicableRecipes.size() > 1) {
            ++this.selectedRecipeIndex;
            if (this.selectedRecipeIndex > this.currentApplicableRecipes.size() - 1) {
                this.selectedRecipeIndex = 0;
            }
            this.selectedRecipe = this.currentApplicableRecipes.get(this.selectedRecipeIndex);
        }
    }

    public void decreaseRecipe() {
        if (!this.currentApplicableRecipes.isEmpty() && this.currentApplicableRecipes.size() > 1) {
            --this.selectedRecipeIndex;
            if (this.selectedRecipeIndex < 0) {
                this.selectedRecipeIndex = this.currentApplicableRecipes.size() - 1;
            }
            this.selectedRecipe = this.currentApplicableRecipes.get(this.selectedRecipeIndex);
        }
    }

    public String getGuiID() {
        return "rats:rat_crafting_table";
    }

    public int getFieldCount() {
        return 1;
    }

    public int getField(int id) {
        return this.cookTime;
    }

    public void setField(int id, int value) {
        this.cookTime = value;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        if (!compound.func_74779_i("CustomName").isEmpty()) {
            this.furnaceCustomName = compound.func_74779_i("CustomName");
        }
        this.currentApplicableRecipes.clear();
        this.currentApplicableRecipes = this.findMatchingRecipesFor((ItemStack)this.inventory.get(0));
        this.selectedRecipe = null;
        this.selectedRecipeIndex = 0;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return compound;
    }

    public IRecipe getSelectedRecipe() {
        return this.selectedRecipe;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.rat_crafting_table", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public boolean hasMultipleRecipes() {
        return this.currentApplicableRecipes.size() > 1;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerRatCraftingTable(id, (IInventory)this, playerInventory, this.furnaceData);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }
}

