/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRattlingGunBullet;
import com.github.alexthe666.rats.server.entity.IPirat;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class EntityRattlingGun
extends MobEntity
implements IRatlantean,
IPirat {
    private static final List<ItemStack> EMPTY_EQUIPMENT = Collections.emptyList();
    private static final DataParameter<Boolean> FIRING = EntityDataManager.func_187226_a(EntityRattlingGun.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean prevFire;
    private int fireCooldown = 0;

    public EntityRattlingGun(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_213323_x_();
    }

    public boolean func_70039_c(CompoundNBT compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        super.func_70039_c(compound);
        return true;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public Entity func_184179_bs() {
        if (!this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityRat)) continue;
                return entity;
            }
        }
        return null;
    }

    public double func_70033_W() {
        return 0.45;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float radius = 0.9f;
        float angle = (float)Math.PI / 180 * (this.field_70177_z + 150.0f);
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        double extraY = 1.3215;
        passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + extraY, this.func_226281_cx_() + extraZ);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRING, (Object)false);
    }

    public boolean isFiring() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRING);
    }

    public void setFiring(boolean firing) {
        this.field_70180_af.func_187227_b(FIRING, (Object)firing);
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        Vec3d vec3d = this.func_213322_ci();
        this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        this.field_70757_a = 20;
        if (this.field_70725_aQ >= 40) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (PlayerEntity)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i);
                    this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                int j;
                for (j = 0; j < 1 + this.field_70146_Z.nextInt(2); ++j) {
                    this.func_70099_a(new ItemStack((IItemProvider)Items.field_151055_y), 0.0f);
                }
                for (j = 0; j < 3 + this.field_70146_Z.nextInt(7); ++j) {
                    this.func_70099_a(new ItemStack((IItemProvider)Items.field_151042_j), 0.0f);
                }
            }
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Entity rat = this.func_184179_bs();
        if (this.func_184187_bx() != null && !this.func_184187_bx().func_184218_aH()) {
            this.func_184187_bx().func_184205_a((Entity)this, true);
        }
        if (this.prevFire != this.isFiring()) {
            this.fireCooldown = 4;
        }
        if (this.isFiring() && this.fireCooldown == 0) {
            this.setFiring(false);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        this.prevFire = this.isFiring();
        if (rat != null && rat instanceof LivingEntity) {
            EntityRat rattus;
            LivingEntity riding = (LivingEntity)this.func_184179_bs();
            this.field_70177_z = riding.field_70177_z;
            this.field_70126_B = riding.field_70177_z;
            this.field_70759_as = riding.field_70177_z;
            if (riding instanceof EntityRat && (rattus = (EntityRat)this.func_184179_bs()).func_70638_az() != null && rattus.func_70638_az().func_145782_y() != this.func_145782_y()) {
                this.func_70625_a((Entity)rattus.func_70638_az(), 30.0f, 30.0f);
                this.shoot(rattus);
            }
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.func_145775_I();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return EMPTY_EQUIPMENT;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.func_184179_bs() == null) {
            if (!player.func_184188_bt().isEmpty()) {
                boolean flag = false;
                for (Entity entity : player.func_184188_bt()) {
                    if (!(entity instanceof EntityRat)) continue;
                    flag = true;
                    System.out.println(this.field_70170_p.field_72995_K);
                    entity.func_184205_a((Entity)this, false);
                    break;
                }
                return flag;
            }
        } else {
            Entity passenger = this.func_184179_bs();
            if (passenger instanceof EntityRat && ((EntityRat)passenger).func_152114_e((LivingEntity)player)) {
                ((EntityRat)passenger).func_184210_p();
                ((EntityRat)passenger).func_184220_m((Entity)player);
                return true;
            }
        }
        return false;
    }

    public void shoot(EntityRat pirat) {
        LivingEntity target = pirat.func_70638_az();
        if (target == null) {
            target = this.field_70170_p.func_217362_a((Entity)this, 30.0);
        }
        if (target != null) {
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70761_aq = f % 360.0f;
            this.field_70177_z = f % 360.0f;
            this.field_70759_as = f % 360.0f;
            pirat.field_70761_aq = f % 360.0f;
            pirat.field_70177_z = f % 360.0f;
            pirat.field_70759_as = f % 360.0f;
            EntityRattlingGunBullet cannonball = new EntityRattlingGunBullet(RatsEntityRegistry.RATTLING_GUN_BULLET, this.field_70170_p, (LivingEntity)pirat);
            float radius = 1.6f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * 0.2f) - 0.1;
            double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * 0.2f) - 0.1;
            double extraY = 1.35 + this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * 0.1f) - 0.05;
            double d02 = target.func_226278_cu_() + (double)target.func_70047_e() / 2.0;
            double d1 = target.func_226277_ct_() - extraX;
            double d3 = target.func_226281_cx_() - extraZ;
            double d22 = d02 - extraY;
            float velocity = 2.2f;
            cannonball.func_70107_b(extraX, extraY, extraZ);
            cannonball.func_70186_c(d1, d22, d3, velocity, 0.4f);
            this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)cannonball);
            }
            this.setFiring(true);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187881_gQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187881_gQ;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean shouldRiderFaceForward(PlayerEntity player) {
        return true;
    }

    public EntityRattlingGun(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(RatsEntityRegistry.RATTLING_GUN, worldIn);
    }

    public void func_213352_e(Vec3d vec) {
    }
}

