/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityGolemBeam;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.IFluidBlock;

public class EntityMarbleCheeseGolem
extends MonsterEntity
implements IAnimatedEntity,
IRangedAttackMob,
IRatlantean {
    public static final Animation ANIMATION_MELEE = Animation.create((int)15);
    public static final Animation ANIMATION_RANGED = Animation.create((int)15);
    private static final Predicate<LivingEntity> NOT_RATLANTEAN = new Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS);
    private int blockBreakCounter;
    private int animationTick;
    private boolean useRangedAttack = false;
    private Animation currentAnimation;

    public EntityMarbleCheeseGolem(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
        this.field_70728_aV = 50;
        this.field_70138_W = 2.0f;
        this.field_70765_h = new AIMoveControl(this);
    }

    public static boolean canDestroyBlock(Block blockIn) {
        return blockIn != Blocks.field_150357_h && blockIn != Blocks.field_150384_bq && blockIn != Blocks.field_150378_br && blockIn != Blocks.field_150483_bI && blockIn != Blocks.field_185776_dc && blockIn != Blocks.field_185777_dd && blockIn != Blocks.field_180401_cv && blockIn != Blocks.field_185779_df && blockIn != Blocks.field_189881_dj && blockIn != Blocks.field_150332_K && blockIn != Blocks.field_185775_db;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)RatConfig.ratlanteanAutomatonHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)RatConfig.ratlanteanAutomatonAttack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AIFollowPrey(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                int i1 = MathHelper.func_76128_c((double)this.func_226278_cu_());
                int l1 = MathHelper.func_76128_c((double)this.func_226277_ct_());
                int i2 = MathHelper.func_76128_c((double)this.func_226281_cx_());
                boolean flag = false;
                for (int k2 = -2; k2 <= 2; ++k2) {
                    for (int l2 = -2; l2 <= 2; ++l2) {
                        for (int j = 1; j <= 3; ++j) {
                            int i3 = l1 + k2;
                            int k = i1 + j;
                            int l = i2 + l2;
                            BlockPos blockpos = new BlockPos(i3, k, l);
                            BlockState BlockState2 = this.field_70170_p.func_180495_p(blockpos);
                            Block block = BlockState2.func_177230_c();
                            if (block instanceof IFluidBlock || !EntityMarbleCheeseGolem.canDestroyBlock(block) || block.isAir(BlockState2, (IBlockReader)this.field_70170_p, blockpos) || !block.canEntityDestroy(BlockState2, (IBlockReader)this.field_70170_p, blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)BlockState2)) continue;
                            flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                        }
                    }
                }
                if (flag) {
                    this.field_70170_p.func_217378_a(null, 1022, new BlockPos((Entity)this), 0);
                }
            }
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.useRangedAttack ? ANIMATION_MELEE : ANIMATION_RANGED);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntityMarbleCheeseGolem)) {
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.useRangedAttack = true;
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_RANGED);
        }
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RATLANTEAN_AUTOMATON_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RATLANTEAN_AUTOMATON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RATLANTEAN_AUTOMATON_DIE;
    }

    public void func_70636_d() {
        double extraY;
        double extraZ;
        double extraX;
        float angle;
        float radius;
        super.func_70636_d();
        if (this.blockBreakCounter <= 0) {
            this.blockBreakCounter = 20;
        }
        if (this.func_70638_az() != null) {
            boolean bl = this.useRangedAttack = this.func_70032_d((Entity)this.func_70638_az()) > 10.0f;
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_RANGED && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            this.setAnimation(ANIMATION_RANGED);
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 7.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_MELEE);
                this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
            }
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_MELEE && this.getAnimationTick() == 10) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 1.5f, this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_());
                this.useRangedAttack = this.field_70146_Z.nextBoolean();
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() < 0.5) {
            radius = -0.5f;
            angle = (float)Math.PI / 180 * this.field_70761_aq;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            extraY = 1.25 + this.func_226278_cu_();
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, extraX + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 0.25, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * 0.5f) - 0.25, 0.0, (double)-0.1f, 0.0);
        }
        if (this.useRangedAttack && this.getAnimation() == ANIMATION_RANGED && this.getAnimationTick() == 6) {
            radius = -3.8f;
            angle = (float)Math.PI / 180 * this.field_70761_aq - 160.0f;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            extraY = (double)2.4f + this.func_226278_cu_();
            double targetRelativeX = (this.func_70638_az() == null ? this.func_70676_i((float)1.0f).field_72450_a : this.func_70638_az().func_226277_ct_()) - extraX;
            double targetRelativeY = (this.func_70638_az() == null ? this.func_70676_i((float)1.0f).field_72448_b : this.func_70638_az().func_226278_cu_()) - extraY;
            double targetRelativeZ = (this.func_70638_az() == null ? this.func_70676_i((float)1.0f).field_72449_c : this.func_70638_az().func_226281_cx_()) - extraZ;
            EntityGolemBeam beam = new EntityGolemBeam(RatsEntityRegistry.RATLANTEAN_AUTOMATON_BEAM, this.field_70170_p, (LivingEntity)this);
            beam.func_70107_b(extraX, extraY, extraZ);
            beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.1f);
            this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)beam);
            }
            this.useRangedAttack = this.field_70146_Z.nextBoolean();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MELEE, ANIMATION_RANGED};
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    class AIFollowPrey
    extends Goal {
        private final EntityMarbleCheeseGolem parentEntity;
        public int attackTimer;
        private double followDist;

        public AIFollowPrey(EntityMarbleCheeseGolem ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            this.followDist = EntityMarbleCheeseGolem.this.func_174813_aQ().func_72320_b();
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            return LivingEntity2 != null && ((double)LivingEntity2.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)LivingEntity2));
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            double maxFollow;
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double d = maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            if ((double)LivingEntity2.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                EntityMarbleCheeseGolem.this.field_70765_h.func_75642_a(LivingEntity2.func_226277_ct_(), LivingEntity2.func_226278_cu_() + 1.0, LivingEntity2.func_226281_cx_(), 1.0);
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !EntityMarbleCheeseGolem.this.field_70765_h.func_75640_a() && EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityMarbleCheeseGolem.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(15) - 7, EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(11) - 5, EntityMarbleCheeseGolem.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityMarbleCheeseGolem.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityMarbleCheeseGolem.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                if (EntityMarbleCheeseGolem.this.func_70638_az() != null) break;
                EntityMarbleCheeseGolem.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityMarbleCheeseGolem vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vec3d vec3d = new Vec3d(this.func_179917_d() - EntityMarbleCheeseGolem.this.func_226277_ct_(), this.func_179919_e() - EntityMarbleCheeseGolem.this.func_226278_cu_(), this.func_179918_f() - EntityMarbleCheeseGolem.this.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = EntityMarbleCheeseGolem.this.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityMarbleCheeseGolem.this.func_213317_d(EntityMarbleCheeseGolem.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityMarbleCheeseGolem.this.func_213317_d(EntityMarbleCheeseGolem.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.1 / d0)));
                    if (EntityMarbleCheeseGolem.this.func_70638_az() == null) {
                        Vec3d vec3d1 = EntityMarbleCheeseGolem.this.func_213322_ci();
                        EntityMarbleCheeseGolem.this.field_70761_aq = EntityMarbleCheeseGolem.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityMarbleCheeseGolem.this.func_70638_az().func_226277_ct_() - EntityMarbleCheeseGolem.this.func_226277_ct_();
                        double d5 = EntityMarbleCheeseGolem.this.func_70638_az().func_226281_cx_() - EntityMarbleCheeseGolem.this.func_226281_cx_();
                        EntityMarbleCheeseGolem.this.field_70761_aq = EntityMarbleCheeseGolem.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

