/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelFlyingDutchrat;
import com.github.alexthe666.rats.server.entity.EntityDutchrat;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;

public class LayerDutchratHelmet
extends LayerRenderer<EntityDutchrat, ModelFlyingDutchrat<EntityDutchrat>> {
    private final IEntityRenderer<EntityDutchrat, ModelFlyingDutchrat<EntityDutchrat>> ratRenderer;
    private static final BipedModel backup = new BipedModel(1.0f);
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public LayerDutchratHelmet(IEntityRenderer<EntityDutchrat, ModelFlyingDutchrat<EntityDutchrat>> ratRendererIn) {
        super(ratRendererIn);
        this.ratRenderer = ratRendererIn;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityDutchrat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.func_227860_a_();
        ((ModelFlyingDutchrat)this.ratRenderer.func_217764_d()).body1.func_228307_a_(matrixStackIn);
        ((ModelFlyingDutchrat)this.ratRenderer.func_217764_d()).neck.func_228307_a_(matrixStackIn);
        ((ModelFlyingDutchrat)this.ratRenderer.func_217764_d()).head.func_228307_a_(matrixStackIn);
        matrixStackIn.func_227861_a_(0.0, (double)-0.77f, 0.0);
        ItemStack itemstack = rat.func_184582_a(EquipmentSlotType.HEAD);
        if (itemstack.func_77973_b() instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)itemstack.func_77973_b();
            BipedModel<?> a = this.getArmorModelHook((LivingEntity)rat, itemstack, EquipmentSlotType.HEAD, backup);
            ResourceLocation tex = this.getArmorResource((Entity)rat, itemstack, EquipmentSlotType.HEAD, null);
            IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)tex), (boolean)false, (boolean)false);
            a.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.func_227865_b_();
    }

    protected BipedModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slot, BipedModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlotType)slot, (BipedModel)model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

