/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;

public interface IChunk
extends IBlockReader,
IStructureReader {
    @Nullable
    public BlockState func_177436_a(BlockPos var1, BlockState var2, boolean var3);

    public void func_177426_a(BlockPos var1, TileEntity var2);

    public void func_76612_a(Entity var1);

    @Nullable
    default public ChunkSection func_186031_y() {
        ChunkSection[] chunkSectionArray = this.func_76587_i();
        for (int i = chunkSectionArray.length - 1; i >= 0; --i) {
            ChunkSection chunkSection = chunkSectionArray[i];
            if (ChunkSection.func_222628_a(chunkSection)) continue;
            return chunkSection;
        }
        return null;
    }

    default public int func_76625_h() {
        ChunkSection chunkSection = this.func_186031_y();
        return chunkSection == null ? 0 : chunkSection.func_222632_g();
    }

    public Set<BlockPos> func_203066_o();

    public ChunkSection[] func_76587_i();

    public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f();

    public void func_201607_a(Heightmap.Type var1, long[] var2);

    public Heightmap func_217303_b(Heightmap.Type var1);

    public int func_201576_a(Heightmap.Type var1, int var2, int var3);

    public ChunkPos func_76632_l();

    public void func_177432_b(long var1);

    public Map<String, StructureStart> func_201609_c();

    public void func_201612_a(Map<String, StructureStart> var1);

    default public boolean func_76606_c(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= 256) {
            n2 = 255;
        }
        for (\u2603 = n; \u2603 <= n2; \u2603 += 16) {
            if (ChunkSection.func_222628_a(this.func_76587_i()[\u2603 >> 4])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BiomeContainer func_225549_i_();

    public void func_177427_f(boolean var1);

    public boolean func_201593_f();

    public ChunkStatus func_201589_g();

    public void func_177425_e(BlockPos var1);

    default public void func_201594_d(BlockPos blockPos) {
        LogManager.getLogger().warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)blockPos);
    }

    public ShortList[] func_201614_D();

    default public void func_201636_b(short s, int n) {
        IChunk.func_217308_a(this.func_201614_D(), n).add(s);
    }

    default public void func_201591_a(CompoundNBT compoundNBT) {
        LogManager.getLogger().warn("Trying to set a BlockEntity, but this operation is not supported.");
    }

    @Nullable
    public CompoundNBT func_201579_g(BlockPos var1);

    @Nullable
    public CompoundNBT func_223134_j(BlockPos var1);

    public Stream<BlockPos> func_217304_m();

    public ITickList<Block> func_205218_i_();

    public ITickList<Fluid> func_212247_j();

    default public BitSet func_205749_a(GenerationStage.Carving carving) {
        throw Util.func_229757_c_(new RuntimeException("Meaningless in this context"));
    }

    public UpgradeData func_196966_y();

    public void func_177415_c(long var1);

    public long func_177416_w();

    public static ShortList func_217308_a(ShortList[] shortListArray, int n) {
        if (shortListArray[n] == null) {
            shortListArray[n] = new ShortArrayList();
        }
        return shortListArray[n];
    }

    public boolean func_217310_r();

    public void func_217305_b(boolean var1);
}

