/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.storage.loot.LootTables;

public class SlimeEntity
extends MobEntity
implements IMob {
    private static final DataParameter<Integer> field_184711_bt = EntityDataManager.func_187226_a(SlimeEntity.class, DataSerializers.field_187192_b);
    public float field_70813_a;
    public float field_70811_b;
    public float field_70812_c;
    private boolean field_175452_bi;

    public SlimeEntity(EntityType<? extends SlimeEntity> entityType, World world) {
        super((EntityType<? extends MobEntity>)entityType, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new FloatGoal(this));
        this.field_70714_bg.func_75776_a(2, new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, new FaceRandomGoal(this));
        this.field_70714_bg.func_75776_a(5, new HopGoal(this));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, 10, true, false, livingEntity -> Math.abs(livingEntity.func_226278_cu_() - this.func_226278_cu_()) <= 4.0));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184711_bt, 1);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void func_70799_a(int n, boolean bl) {
        this.field_70180_af.func_187227_b(field_184711_bt, n);
        this.func_226264_Z_();
        this.func_213323_x_();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(n * n);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2f + 0.1f * (float)n);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(n);
        if (bl) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.field_70728_aV = n;
    }

    public int func_70809_q() {
        return this.field_70180_af.func_187225_a(field_184711_bt);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Size", this.func_70809_q() - 1);
        compoundNBT.func_74757_a("wasOnGround", this.field_175452_bi);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        int n = compoundNBT.func_74762_e("Size");
        if (n < 0) {
            n = 0;
        }
        this.func_70799_a(n + 1, false);
        super.func_70037_a(compoundNBT);
        this.field_175452_bi = compoundNBT.func_74767_n("wasOnGround");
    }

    public boolean func_189101_db() {
        return this.func_70809_q() <= 1;
    }

    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197592_C;
    }

    @Override
    protected boolean func_225511_J_() {
        return this.func_70809_q() > 0;
    }

    @Override
    public void func_70071_h_() {
        this.field_70811_b += (this.field_70813_a - this.field_70811_b) * 0.5f;
        this.field_70812_c = this.field_70811_b;
        super.func_70071_h_();
        if (this.field_70122_E && !this.field_175452_bi) {
            int n = this.func_70809_q();
            for (\u2603 = 0; \u2603 < n * 8; ++\u2603) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                \u2603 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                \u2603 = MathHelper.func_76126_a(f) * (float)n * 0.5f * \u2603;
                \u2603 = MathHelper.func_76134_b(f) * (float)n * 0.5f * \u2603;
                this.field_70170_p.func_195594_a(this.func_195404_m(), this.func_226277_ct_() + (double)\u2603, this.func_226278_cu_(), this.func_226281_cx_() + (double)\u2603, 0.0, 0.0, 0.0);
            }
            this.func_184185_a(this.func_184709_cY(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.field_70813_a = -0.5f;
        } else if (!this.field_70122_E && this.field_175452_bi) {
            this.field_70813_a = 1.0f;
        }
        this.field_175452_bi = this.field_70122_E;
        this.func_70808_l();
    }

    protected void func_70808_l() {
        this.field_70813_a *= 0.6f;
    }

    protected int func_70806_k() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    @Override
    public void func_213323_x_() {
        double d = this.func_226277_ct_();
        \u2603 = this.func_226278_cu_();
        \u2603 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d, \u2603, \u2603);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (field_184711_bt.equals(dataParameter)) {
            this.func_213323_x_();
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(dataParameter);
    }

    public EntityType<? extends SlimeEntity> func_200600_R() {
        return super.func_200600_R();
    }

    @Override
    public void func_70106_y() {
        int n = this.func_70809_q();
        if (!this.field_70170_p.field_72995_K && n > 1 && this.func_110143_aJ() <= 0.0f) {
            \u2603 = 2 + this.field_70146_Z.nextInt(3);
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                float f = ((float)(\u2603 % 2) - 0.5f) * (float)n / 4.0f;
                \u2603 = ((float)(\u2603 / 2) - 0.5f) * (float)n / 4.0f;
                SlimeEntity \u26032 = this.func_200600_R().func_200721_a(this.field_70170_p);
                if (this.func_145818_k_()) {
                    \u26032.func_200203_b(this.func_200201_e());
                }
                if (this.func_104002_bU()) {
                    \u26032.func_110163_bv();
                }
                \u26032.func_184224_h(this.func_190530_aW());
                \u26032.func_70799_a(n / 2, true);
                \u26032.func_70012_b(this.func_226277_ct_() + (double)f, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + (double)\u2603, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c(\u26032);
            }
        }
        super.func_70106_y();
    }

    @Override
    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (entity instanceof IronGolemEntity && this.func_70800_m()) {
            this.func_175451_e((LivingEntity)entity);
        }
    }

    @Override
    public void func_70100_b_(PlayerEntity playerEntity) {
        if (this.func_70800_m()) {
            this.func_175451_e(playerEntity);
        }
    }

    protected void func_175451_e(LivingEntity livingEntity) {
        if (this.func_70089_S()) {
            int n = this.func_70809_q();
            if (this.func_70068_e(livingEntity) < 0.6 * (double)n * (0.6 * (double)n) && this.func_70685_l(livingEntity) && livingEntity.func_70097_a(DamageSource.func_76358_a(this), this.func_225512_er_())) {
                this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a(this, livingEntity);
            }
        }
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 0.625f * entitySize.field_220316_b;
    }

    protected boolean func_70800_m() {
        return !this.func_189101_db() && this.func_70613_aW();
    }

    protected float func_225512_er_() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.func_189101_db()) {
            return SoundEvents.field_187898_fy;
        }
        return SoundEvents.field_187880_fp;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        if (this.func_189101_db()) {
            return SoundEvents.field_187896_fx;
        }
        return SoundEvents.field_187874_fm;
    }

    protected SoundEvent func_184709_cY() {
        if (this.func_189101_db()) {
            return SoundEvents.field_187900_fz;
        }
        return SoundEvents.field_187886_fs;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_70809_q() == 1 ? this.func_200600_R().func_220348_g() : LootTables.field_186419_a;
    }

    public static boolean func_223366_c(EntityType<SlimeEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (iWorld.func_72912_H().func_76067_t() == WorldType.field_77138_c && random.nextInt(4) != 1) {
            return false;
        }
        if (iWorld.func_175659_aa() != Difficulty.PEACEFUL) {
            Biome biome = iWorld.func_226691_t_(blockPos);
            if (biome == Biomes.field_76780_h && blockPos.func_177956_o() > 50 && blockPos.func_177956_o() < 70 && random.nextFloat() < 0.5f && random.nextFloat() < iWorld.func_130001_d() && iWorld.func_201696_r(blockPos) <= random.nextInt(8)) {
                return SlimeEntity.func_223315_a(entityType, iWorld, spawnReason, blockPos, random);
            }
            ChunkPos \u26032 = new ChunkPos(blockPos);
            boolean bl = \u2603 = SharedSeedRandom.func_205190_a(\u26032.field_77276_a, \u26032.field_77275_b, iWorld.func_72905_C(), 987234911L).nextInt(10) == 0;
            if (random.nextInt(10) == 0 && \u2603 && blockPos.func_177956_o() < 40) {
                return SlimeEntity.func_223315_a(entityType, iWorld, spawnReason, blockPos, random);
            }
        }
        return false;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f * (float)this.func_70809_q();
    }

    @Override
    public int func_70646_bf() {
        return 0;
    }

    protected boolean func_70807_r() {
        return this.func_70809_q() > 0;
    }

    @Override
    protected void func_70664_aZ() {
        Vec3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, this.func_175134_bD(), vec3d.field_72449_c);
        this.field_70160_al = true;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        int n = this.field_70146_Z.nextInt(3);
        if (n < 2 && this.field_70146_Z.nextFloat() < 0.5f * difficultyInstance.func_180170_c()) {
            ++n;
        }
        \u2603 = 1 << n;
        this.func_70799_a(\u2603, true);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    protected SoundEvent func_184710_cZ() {
        return this.func_189101_db() ? SoundEvents.field_189110_fE : SoundEvents.field_187882_fq;
    }

    @Override
    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(0.255f * (float)this.func_70809_q());
    }

    static class HopGoal
    extends Goal {
        private final SlimeEntity field_179458_a;

        public HopGoal(SlimeEntity slimeEntity) {
            this.field_179458_a = slimeEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_179458_a.func_184218_aH();
        }

        @Override
        public void func_75246_d() {
            ((MoveHelperController)this.field_179458_a.func_70605_aq()).func_179921_a(1.0);
        }
    }

    static class FloatGoal
    extends Goal {
        private final SlimeEntity field_179457_a;

        public FloatGoal(SlimeEntity slimeEntity) {
            this.field_179457_a = slimeEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slimeEntity.func_70661_as().func_212239_d(true);
        }

        @Override
        public boolean func_75250_a() {
            return (this.field_179457_a.func_70090_H() || this.field_179457_a.func_180799_ab()) && this.field_179457_a.func_70605_aq() instanceof MoveHelperController;
        }

        @Override
        public void func_75246_d() {
            if (this.field_179457_a.func_70681_au().nextFloat() < 0.8f) {
                this.field_179457_a.func_70683_ar().func_75660_a();
            }
            ((MoveHelperController)this.field_179457_a.func_70605_aq()).func_179921_a(1.2);
        }
    }

    static class FaceRandomGoal
    extends Goal {
        private final SlimeEntity field_179461_a;
        private float field_179459_b;
        private int field_179460_c;

        public FaceRandomGoal(SlimeEntity slimeEntity) {
            this.field_179461_a = slimeEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            return this.field_179461_a.func_70638_az() == null && (this.field_179461_a.field_70122_E || this.field_179461_a.func_70090_H() || this.field_179461_a.func_180799_ab() || this.field_179461_a.func_70644_a(Effects.field_188424_y)) && this.field_179461_a.func_70605_aq() instanceof MoveHelperController;
        }

        @Override
        public void func_75246_d() {
            if (--this.field_179460_c <= 0) {
                this.field_179460_c = 40 + this.field_179461_a.func_70681_au().nextInt(60);
                this.field_179459_b = this.field_179461_a.func_70681_au().nextInt(360);
            }
            ((MoveHelperController)this.field_179461_a.func_70605_aq()).func_179920_a(this.field_179459_b, false);
        }
    }

    static class AttackGoal
    extends Goal {
        private final SlimeEntity field_179466_a;
        private int field_179465_b;

        public AttackGoal(SlimeEntity slimeEntity) {
            this.field_179466_a = slimeEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = this.field_179466_a.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            if (livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return this.field_179466_a.func_70605_aq() instanceof MoveHelperController;
        }

        @Override
        public void func_75249_e() {
            this.field_179465_b = 300;
            super.func_75249_e();
        }

        @Override
        public boolean func_75253_b() {
            LivingEntity livingEntity = this.field_179466_a.func_70638_az();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.func_70089_S()) {
                return false;
            }
            if (livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).field_71075_bZ.field_75102_a) {
                return false;
            }
            return --this.field_179465_b > 0;
        }

        @Override
        public void func_75246_d() {
            this.field_179466_a.func_70625_a(this.field_179466_a.func_70638_az(), 10.0f, 10.0f);
            ((MoveHelperController)this.field_179466_a.func_70605_aq()).func_179920_a(this.field_179466_a.field_70177_z, this.field_179466_a.func_70800_m());
        }
    }

    static class MoveHelperController
    extends MovementController {
        private float field_179922_g;
        private int field_179924_h;
        private final SlimeEntity field_179925_i;
        private boolean field_179923_j;

        public MoveHelperController(SlimeEntity slimeEntity) {
            super(slimeEntity);
            this.field_179925_i = slimeEntity;
            this.field_179922_g = 180.0f * slimeEntity.field_70177_z / (float)Math.PI;
        }

        public void func_179920_a(float f, boolean bl) {
            this.field_179922_g = f;
            this.field_179923_j = bl;
        }

        public void func_179921_a(double d) {
            this.field_75645_e = d;
            this.field_188491_h = MovementController.Action.MOVE_TO;
        }

        @Override
        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.field_179922_g, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
                return;
            }
            this.field_188491_h = MovementController.Action.WAIT;
            if (this.field_75648_a.field_70122_E) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_179924_h-- <= 0) {
                    this.field_179924_h = this.field_179925_i.func_70806_k();
                    if (this.field_179923_j) {
                        this.field_179924_h /= 3;
                    }
                    this.field_179925_i.func_70683_ar().func_75660_a();
                    if (this.field_179925_i.func_70807_r()) {
                        this.field_179925_i.func_184185_a(this.field_179925_i.func_184710_cZ(), this.field_179925_i.func_70599_aP(), ((this.field_179925_i.func_70681_au().nextFloat() - this.field_179925_i.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    }
                } else {
                    this.field_179925_i.field_70702_br = 0.0f;
                    this.field_179925_i.field_191988_bg = 0.0f;
                    this.field_75648_a.func_70659_e(0.0f);
                }
            } else {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            }
        }
    }
}

