/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.raid.Raid;

public abstract class PatrollerEntity
extends MonsterEntity {
    private BlockPos field_213639_b;
    private boolean field_213640_c;
    private boolean field_213641_d;

    protected PatrollerEntity(EntityType<? extends PatrollerEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new PatrolGoal<PatrollerEntity>(this, 0.7, 0.595));
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.field_213639_b != null) {
            compoundNBT.func_218657_a("PatrolTarget", NBTUtil.func_186859_a(this.field_213639_b));
        }
        compoundNBT.func_74757_a("PatrolLeader", this.field_213640_c);
        compoundNBT.func_74757_a("Patrolling", this.field_213641_d);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_74764_b("PatrolTarget")) {
            this.field_213639_b = NBTUtil.func_186861_c(compoundNBT.func_74775_l("PatrolTarget"));
        }
        this.field_213640_c = compoundNBT.func_74767_n("PatrolLeader");
        this.field_213641_d = compoundNBT.func_74767_n("Patrolling");
    }

    @Override
    public double func_70033_W() {
        return -0.45;
    }

    public boolean func_213637_dY() {
        return true;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        if (spawnReason != SpawnReason.PATROL && spawnReason != SpawnReason.EVENT && spawnReason != SpawnReason.STRUCTURE && this.field_70146_Z.nextFloat() < 0.06f && this.func_213637_dY()) {
            this.field_213640_c = true;
        }
        if (this.func_213630_eb()) {
            this.func_184201_a(EquipmentSlotType.HEAD, Raid.func_221312_H());
            this.func_184642_a(EquipmentSlotType.HEAD, 2.0f);
        }
        if (spawnReason == SpawnReason.PATROL) {
            this.field_213641_d = true;
        }
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    public static boolean func_223330_b(EntityType<? extends PatrollerEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (iWorld.func_226658_a_(LightType.BLOCK, blockPos) > 8) {
            return false;
        }
        return PatrollerEntity.func_223324_d(entityType, iWorld, spawnReason, blockPos, random);
    }

    @Override
    public boolean func_213397_c(double d) {
        return !this.field_213641_d || d > 16384.0;
    }

    public void func_213631_g(BlockPos blockPos) {
        this.field_213639_b = blockPos;
        this.field_213641_d = true;
    }

    public BlockPos func_213638_dZ() {
        return this.field_213639_b;
    }

    public boolean func_213632_ea() {
        return this.field_213639_b != null;
    }

    public void func_213635_r(boolean bl) {
        this.field_213640_c = bl;
        this.field_213641_d = true;
    }

    public boolean func_213630_eb() {
        return this.field_213640_c;
    }

    public boolean func_213634_ed() {
        return true;
    }

    public void func_213636_ee() {
        this.field_213639_b = new BlockPos(this).func_177982_a(-500 + this.field_70146_Z.nextInt(1000), 0, -500 + this.field_70146_Z.nextInt(1000));
        this.field_213641_d = true;
    }

    protected boolean func_213633_ef() {
        return this.field_213641_d;
    }

    protected void func_226541_s_(boolean bl) {
        this.field_213641_d = bl;
    }

    public static class PatrolGoal<T extends PatrollerEntity>
    extends Goal {
        private final T field_220839_a;
        private final double field_220840_b;
        private final double field_220841_c;
        private long field_226542_d_;

        public PatrolGoal(T t, double d, double d2) {
            this.field_220839_a = t;
            this.field_220840_b = d;
            this.field_220841_c = d2;
            this.field_226542_d_ = -1L;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            boolean bl = ((PatrollerEntity)this.field_220839_a).field_70170_p.func_82737_E() < this.field_226542_d_;
            return ((PatrollerEntity)this.field_220839_a).func_213633_ef() && ((MobEntity)this.field_220839_a).func_70638_az() == null && !((Entity)this.field_220839_a).func_184207_aI() && ((PatrollerEntity)this.field_220839_a).func_213632_ea() && !bl;
        }

        @Override
        public void func_75249_e() {
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            boolean bl = ((PatrollerEntity)this.field_220839_a).func_213630_eb();
            PathNavigator \u26032 = ((MobEntity)this.field_220839_a).func_70661_as();
            if (\u26032.func_75500_f()) {
                List<PatrollerEntity> list = this.func_226544_g_();
                if (((PatrollerEntity)this.field_220839_a).func_213633_ef() && list.isEmpty()) {
                    ((PatrollerEntity)this.field_220839_a).func_226541_s_(false);
                } else if (!bl || !((PatrollerEntity)this.field_220839_a).func_213638_dZ().func_218137_a(((Entity)this.field_220839_a).func_213303_ch(), 10.0)) {
                    Vec3d vec3d = new Vec3d(((PatrollerEntity)this.field_220839_a).func_213638_dZ());
                    \u2603 = ((Entity)this.field_220839_a).func_213303_ch();
                    \u2603 = \u2603.func_178788_d(vec3d);
                    vec3d = \u2603.func_178785_b(90.0f).func_186678_a(0.4).func_178787_e(vec3d);
                    \u2603 = vec3d.func_178788_d(\u2603).func_72432_b().func_186678_a(10.0).func_178787_e(\u2603);
                    BlockPos \u26033 = new BlockPos(\u2603);
                    if (!\u26032.func_75492_a((\u26033 = ((PatrollerEntity)this.field_220839_a).field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, \u26033)).func_177958_n(), \u26033.func_177956_o(), \u26033.func_177952_p(), bl ? this.field_220841_c : this.field_220840_b)) {
                        this.func_226545_h_();
                        this.field_226542_d_ = ((PatrollerEntity)this.field_220839_a).field_70170_p.func_82737_E() + 200L;
                    } else if (bl) {
                        for (PatrollerEntity patrollerEntity : list) {
                            patrollerEntity.func_213631_g(\u26033);
                        }
                    }
                } else {
                    ((PatrollerEntity)this.field_220839_a).func_213636_ee();
                }
            }
        }

        private List<PatrollerEntity> func_226544_g_() {
            return ((PatrollerEntity)this.field_220839_a).field_70170_p.func_175647_a(PatrollerEntity.class, ((Entity)this.field_220839_a).func_174813_aQ().func_186662_g(16.0), patrollerEntity -> patrollerEntity.func_213634_ed() && !patrollerEntity.func_70028_i((Entity)this.field_220839_a));
        }

        private boolean func_226545_h_() {
            Random random = ((LivingEntity)this.field_220839_a).func_70681_au();
            BlockPos \u26032 = ((PatrollerEntity)this.field_220839_a).field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos((Entity)this.field_220839_a).func_177982_a(-8 + random.nextInt(16), 0, -8 + random.nextInt(16)));
            return ((MobEntity)this.field_220839_a).func_70661_as().func_75492_a(\u26032.func_177958_n(), \u26032.func_177956_o(), \u26032.func_177952_p(), this.field_220840_b);
        }
    }
}

