/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.container.FilterContainer;
import com.raoulvdberge.refinedstorage.inventory.fluid.FilterFluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.FilterItemsItemHandler;
import com.raoulvdberge.refinedstorage.render.Styles;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FilterItem
extends Item {
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_MOD_FILTER = "ModFilter";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ICON = "Icon";
    private static final String NBT_FLUID_ICON = "FluidIcon";
    private static final String NBT_TYPE = "Type";
    public static final String NBT_FLUID_FILTERS = "FluidFilters";

    public FilterItem() {
        super(new Item.Properties().func_200916_a(RS.MAIN_GROUP).func_200917_a(1));
        this.setRegistryName("refinedstorage", "filter");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (player.func_213453_ef()) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)new ItemStack((IItemProvider)RSItems.FILTER));
            }
            player.func_213829_a(new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("gui.refinedstorage.filter", new Object[0]);
                }

                @Nullable
                public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
                    return new FilterContainer(player, inventory.func_70448_g(), windowId);
                }
            });
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(new TranslationTextComponent("sidebutton.refinedstorage.mode." + (FilterItem.getMode(stack) == 0 ? "whitelist" : "blacklist"), new Object[0]).func_150255_a(Styles.YELLOW));
        if (FilterItem.isModFilter(stack)) {
            tooltip.add(new TranslationTextComponent("gui.refinedstorage.filter.mod_filter", new Object[0]).func_150255_a(Styles.BLUE));
        }
        FilterItemsItemHandler items = new FilterItemsItemHandler(stack);
        RenderUtils.addCombinedItemsToTooltip(tooltip, false, items.getFilteredItems());
        FilterFluidInventory fluids = new FilterFluidInventory(stack);
        RenderUtils.addCombinedFluidsToTooltip(tooltip, false, fluids.getFilteredFluids());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static int getCompare(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_COMPARE) ? stack.func_77978_p().func_74762_e(NBT_COMPARE) : 1;
    }

    public static void setCompare(ItemStack stack, int compare) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a(NBT_COMPARE, compare);
    }

    public static int getMode(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_MODE) ? stack.func_77978_p().func_74762_e(NBT_MODE) : 0;
    }

    public static void setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a(NBT_MODE, mode);
    }

    public static boolean isModFilter(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_MOD_FILTER) && stack.func_77978_p().func_74767_n(NBT_MOD_FILTER);
    }

    public static void setModFilter(ItemStack stack, boolean modFilter) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74757_a(NBT_MOD_FILTER, modFilter);
    }

    public static String getName(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_NAME) ? stack.func_77978_p().func_74779_i(NBT_NAME) : "";
    }

    public static void setName(ItemStack stack, String name) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74778_a(NBT_NAME, name);
    }

    @Nonnull
    public static ItemStack getIcon(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_ICON) ? ItemStack.func_199557_a((CompoundNBT)stack.func_77978_p().func_74775_l(NBT_ICON)) : ItemStack.field_190927_a;
    }

    public static void setIcon(ItemStack stack, ItemStack icon) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_218657_a(NBT_ICON, (INBT)icon.serializeNBT());
    }

    public static void setFluidIcon(ItemStack stack, @Nullable FluidStack icon) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (icon == null) {
            stack.func_77978_p().func_82580_o(NBT_FLUID_ICON);
        } else {
            stack.func_77978_p().func_218657_a(NBT_FLUID_ICON, (INBT)icon.writeToNBT(new CompoundNBT()));
        }
    }

    @Nonnull
    public static FluidStack getFluidIcon(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_FLUID_ICON) ? FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p().func_74775_l(NBT_FLUID_ICON)) : FluidStack.EMPTY;
    }

    public static int getType(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_TYPE) ? stack.func_77978_p().func_74762_e(NBT_TYPE) : 0;
    }

    public static void setType(ItemStack stack, int type) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a(NBT_TYPE, type);
    }
}

